/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.reporting.components.internal.ComponentRenderer;
import org.gradle.api.reporting.components.internal.SourceSetRenderer;
import org.gradle.api.reporting.components.internal.TrackingReportRenderer;
import org.gradle.api.reporting.components.internal.TypeAwareBinaryRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.reporting.ReportRenderer;

public class ComponentReportRenderer
extends TextReportRenderer {
    private final ComponentRenderer componentRenderer;
    private final TrackingReportRenderer<LanguageSourceSet, TextReportBuilder> sourceSetRenderer;
    private final TrackingReportRenderer<BinarySpec, TextReportBuilder> binaryRenderer;

    public ComponentReportRenderer(FileResolver fileResolver, TypeAwareBinaryRenderer binaryRenderer) {
        this.setFileResolver(fileResolver);
        this.sourceSetRenderer = new TrackingReportRenderer<LanguageSourceSet, TextReportBuilder>(new SourceSetRenderer());
        this.binaryRenderer = new TrackingReportRenderer<BinarySpec, TextReportBuilder>(binaryRenderer);
        this.componentRenderer = new ComponentRenderer(this.sourceSetRenderer, this.binaryRenderer);
    }

    @Override
    public void complete() {
        this.getTextOutput().println();
        this.getTextOutput().println("Note: currently not all plugins register their components, so some components may not be visible here.");
        super.complete();
    }

    public void renderComponents(Collection<ComponentSpec> components) {
        if (components.isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println("No components defined for this project.");
            return;
        }
        boolean seen = false;
        for (ComponentSpec component : components) {
            if (seen) {
                this.getBuilder().getOutput().println();
            } else {
                seen = true;
            }
            this.getBuilder().item(component, this.componentRenderer);
        }
    }

    public void renderSourceSets(Collection<LanguageSourceSet> sourceSets) {
        Set<LanguageSourceSet> additionalSourceSets = this.collectAdditionalSourceSets(sourceSets);
        this.outputCollection(additionalSourceSets, "Additional source sets", this.sourceSetRenderer, "source sets");
    }

    public void renderBinaries(Collection<BinarySpec> binaries) {
        Set<BinarySpec> additionalBinaries = this.collectAdditionalBinaries(binaries);
        this.outputCollection(additionalBinaries, "Additional binaries", this.binaryRenderer, "binaries");
    }

    private Set<LanguageSourceSet> collectAdditionalSourceSets(Collection<LanguageSourceSet> sourceSets) {
        TreeSet result2 = Sets.newTreeSet(SourceSetRenderer.SORT_ORDER);
        result2.addAll(sourceSets);
        result2.removeAll(this.sourceSetRenderer.getItems());
        return result2;
    }

    private Set<BinarySpec> collectAdditionalBinaries(Collection<BinarySpec> binaries) {
        TreeSet result2 = Sets.newTreeSet(TypeAwareBinaryRenderer.SORT_ORDER);
        result2.addAll(binaries);
        result2.removeAll(this.binaryRenderer.getItems());
        return result2;
    }

    private <T> void outputCollection(Collection<? extends T> items, String title, ReportRenderer<T, TextReportBuilder> renderer, String elementsPlural) {
        if (!items.isEmpty()) {
            this.getBuilder().getOutput().println();
            this.getBuilder().collection(title, items, renderer, elementsPlural);
        }
    }
}

