/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.publish.ivy.internal.artifact.AbstractIvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationCoordinates;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;

public class SingleOutputTaskIvyArtifact
extends AbstractIvyArtifact {
    private final TaskProvider<? extends Task> generator;
    private final IvyPublicationCoordinates coordinates;
    private final String extension;
    private final String type;
    private final String classifier;
    private final TaskDependencyInternal buildDependencies;

    public SingleOutputTaskIvyArtifact(TaskProvider<? extends Task> generator, IvyPublicationCoordinates coordinates, String extension, String type, @Nullable String classifier, TaskDependencyFactory taskDependencyFactory) {
        super(taskDependencyFactory);
        this.generator = generator;
        this.coordinates = coordinates;
        this.extension = extension;
        this.type = type;
        this.classifier = classifier;
        this.buildDependencies = taskDependencyFactory.visitingDependencies(context -> context.add(generator.get()));
    }

    @Override
    protected String getDefaultName() {
        return (String)this.coordinates.getModule().get();
    }

    @Override
    protected String getDefaultType() {
        return this.type;
    }

    @Override
    protected String getDefaultExtension() {
        return this.extension;
    }

    @Override
    protected String getDefaultClassifier() {
        return this.classifier;
    }

    @Override
    protected String getDefaultConf() {
        return null;
    }

    @Override
    protected TaskDependency getDefaultBuildDependencies() {
        return this.buildDependencies;
    }

    @Override
    public File getFile() {
        return ((Task)this.generator.get()).getOutputs().getFiles().getSingleFile();
    }

    public boolean isEnabled() {
        TaskInternal task = (TaskInternal)this.generator.get();
        return task.getOnlyIf().isSatisfiedBy(task);
    }

    @Override
    public boolean shouldBePublished() {
        return this.isEnabled();
    }
}

