/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.scala;

import javax.inject.Inject;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultScalaSourceSet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.internal.tasks.scala.DefaultScalaPluginExtension;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.plugins.scala.ScalaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.ScalaRuntime;
import org.gradle.api.tasks.ScalaSourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.scala.ScalaCompile;
import org.gradle.api.tasks.scala.ScalaDoc;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.jvm.tasks.Jar;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.language.scala.tasks.AbstractScalaCompile;
import org.gradle.language.scala.tasks.KeepAliveMode;

public abstract class ScalaBasePlugin
implements Plugin<Project> {
    public static final String DEFAULT_ZINC_VERSION = "1.9.3";
    private static final String DEFAULT_SCALA_ZINC_VERSION = "2.13";
    @VisibleForTesting
    public static final String ZINC_CONFIGURATION_NAME = "zinc";
    public static final String SCALA_RUNTIME_EXTENSION_NAME = "scalaRuntime";
    public static final String SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME = "scalaCompilerPlugins";
    private final ObjectFactory objectFactory;
    private final JvmPluginServices jvmPluginServices;

    @Inject
    public ScalaBasePlugin(ObjectFactory objectFactory, JvmPluginServices jvmPluginServices) {
        this.objectFactory = objectFactory;
        this.jvmPluginServices = jvmPluginServices;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        ScalaRuntime scalaRuntime = project.getExtensions().create(SCALA_RUNTIME_EXTENSION_NAME, ScalaRuntime.class, project);
        ScalaPluginExtension scalaPluginExtension = project.getExtensions().create(ScalaPluginExtension.class, "scala", DefaultScalaPluginExtension.class, new Object[0]);
        Usage incrementalAnalysisUsage = this.objectFactory.named(Usage.class, "incremental-analysis");
        Category incrementalAnalysisCategory = this.objectFactory.named(Category.class, "scala-analysis");
        this.configureConfigurations((ProjectInternal)project, incrementalAnalysisCategory, incrementalAnalysisUsage, scalaPluginExtension);
        ScalaBasePlugin.configureCompileDefaults(project, scalaRuntime, (DefaultJavaPluginExtension)ScalaBasePlugin.javaPluginExtension(project));
        this.configureSourceSetDefaults((ProjectInternal)project, incrementalAnalysisCategory, incrementalAnalysisUsage);
        this.configureScaladoc(project, scalaRuntime);
    }

    private void configureConfigurations(ProjectInternal project, Category incrementalAnalysisCategory, Usage incrementalAnalysisUsage, ScalaPluginExtension scalaPluginExtension) {
        DependencyHandler dependencyHandler = project.getDependencies();
        Configuration plugins = project.getConfigurations().resolvableDependencyScopeUnlocked(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME);
        plugins.setTransitive(false);
        this.jvmPluginServices.configureAsRuntimeClasspath(plugins);
        Configuration zinc = project.getConfigurations().resolvableDependencyScopeUnlocked(ZINC_CONFIGURATION_NAME);
        zinc.setVisible(false);
        zinc.setDescription("The Zinc incremental compiler to be used for this Scala project.");
        zinc.getResolutionStrategy().eachDependency(rule -> {
            if (rule.getRequested().getGroup().equals("com.typesafe.zinc") && rule.getRequested().getName().equals(ZINC_CONFIGURATION_NAME)) {
                rule.useTarget("org.scala-sbt:zinc_2.13:1.9.3");
                rule.because("Typesafe Zinc is no longer maintained.");
            }
        });
        zinc.defaultDependencies(dependencies -> {
            dependencies.add(dependencyHandler.create("org.scala-sbt:zinc_2.13:" + (String)scalaPluginExtension.getZincVersion().get()));
            zinc.getIncoming().afterResolve(resolvableDependencies -> resolvableDependencies.getResolutionResult().allComponents(component -> {
                if (component.getModuleVersion() != null && component.getModuleVersion().getName().equals("scala-library") && !component.getModuleVersion().getVersion().startsWith(DEFAULT_SCALA_ZINC_VERSION)) {
                    throw new InvalidUserCodeException("The version of 'scala-library' was changed while using the default Zinc version. Version " + component.getModuleVersion().getVersion() + " is not compatible with org.scala-sbt:zinc_" + DEFAULT_SCALA_ZINC_VERSION + ":" + DEFAULT_ZINC_VERSION);
                }
            }));
        });
        zinc.getDependencyConstraints().add(dependencyHandler.getConstraints().create("org.apache.logging.log4j:log4j-core", constraint -> constraint.version(version -> {
            version.require("2.17.1");
            version.reject("[2.0, 2.17.1)");
        })));
        Configuration incrementalAnalysisElements = project.getConfigurations().migratingUnlocked("incrementalScalaAnalysisElements", ConfigurationRolesForMigration.CONSUMABLE_DEPENDENCY_SCOPE_TO_CONSUMABLE);
        incrementalAnalysisElements.setVisible(false);
        incrementalAnalysisElements.setDescription("Incremental compilation analysis files");
        incrementalAnalysisElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, incrementalAnalysisUsage);
        incrementalAnalysisElements.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, incrementalAnalysisCategory);
        AttributeMatchingStrategy<Usage> matchingStrategy = dependencyHandler.getAttributesSchema().attribute(Usage.USAGE_ATTRIBUTE);
        matchingStrategy.getDisambiguationRules().add(UsageDisambiguationRules.class, actionConfiguration -> {
            actionConfiguration.params(incrementalAnalysisUsage);
            actionConfiguration.params(this.objectFactory.named(Usage.class, "java-api"));
            actionConfiguration.params(this.objectFactory.named(Usage.class, "java-runtime"));
        });
    }

    private void configureSourceSetDefaults(ProjectInternal project, Category incrementalAnalysisCategory, Usage incrementalAnalysisUsage) {
        ScalaBasePlugin.javaPluginExtension(project).getSourceSets().all(sourceSet -> {
            ScalaSourceDirectorySet scalaSource = this.getScalaSourceDirectorySet((SourceSet)sourceSet);
            sourceSet.getExtensions().add(ScalaSourceDirectorySet.class, "scala", scalaSource);
            scalaSource.srcDir(project.file("src/" + sourceSet.getName() + "/scala"));
            ScalaSourceDirectorySet scalaSourceFiles = scalaSource;
            sourceSet.getResources().getFilter().exclude(SerializableLambdas.spec(element -> scalaSourceFiles.contains(element.getFile())));
            sourceSet.getAllJava().source(scalaSource);
            sourceSet.getAllSource().source(scalaSource);
            Configuration incrementalAnalysis = ScalaBasePlugin.createIncrementalAnalysisConfigurationFor(project.getConfigurations(), incrementalAnalysisCategory, incrementalAnalysisUsage, sourceSet);
            this.createScalaCompileTask(project, (SourceSet)sourceSet, scalaSource, incrementalAnalysis);
        });
    }

    private ScalaSourceDirectorySet getScalaSourceDirectorySet(SourceSet sourceSet) {
        DefaultScalaSourceSet scalaSourceSet = this.objectFactory.newInstance(DefaultScalaSourceSet.class, ((DefaultSourceSet)sourceSet).getDisplayName(), this.objectFactory);
        DeprecationLogger.whileDisabled(() -> new DslObject(sourceSet).getConvention().getPlugins().put("scala", scalaSourceSet));
        return scalaSourceSet.getScala();
    }

    private static Configuration createIncrementalAnalysisConfigurationFor(RoleBasedConfigurationContainerInternal configurations, Category incrementalAnalysisCategory, Usage incrementalAnalysisUsage, SourceSet sourceSet) {
        Configuration classpath = configurations.getByName(sourceSet.getImplementationConfigurationName());
        Configuration incrementalAnalysis = configurations.migratingUnlocked("incrementalScalaAnalysisFor" + sourceSet.getName(), ConfigurationRolesForMigration.RESOLVABLE_DEPENDENCY_SCOPE_TO_RESOLVABLE);
        incrementalAnalysis.setVisible(false);
        incrementalAnalysis.setDescription("Incremental compilation analysis files for " + ((DefaultSourceSet)sourceSet).getDisplayName());
        incrementalAnalysis.extendsFrom(classpath);
        incrementalAnalysis.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, incrementalAnalysisUsage);
        incrementalAnalysis.getAttributes().attribute(Category.CATEGORY_ATTRIBUTE, incrementalAnalysisCategory);
        return incrementalAnalysis;
    }

    private void createScalaCompileTask(Project project, SourceSet sourceSet, ScalaSourceDirectorySet scalaSource, Configuration incrementalAnalysis) {
        NamedDomainObjectProvider compileTask = project.getTasks().register(sourceSet.getCompileTaskName("scala"), ScalaCompile.class, scalaCompile -> {
            JvmPluginsHelper.compileAgainstJavaOutputs(scalaCompile, sourceSet, this.objectFactory);
            JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, scalaSource, scalaCompile.getOptions(), project);
            scalaCompile.setDescription("Compiles the " + scalaSource + ".");
            scalaCompile.setSource(scalaSource);
            scalaCompile.getJavaLauncher().convention(ScalaBasePlugin.getJavaLauncher(project));
            this.configureIncrementalAnalysis(project, sourceSet, incrementalAnalysis, (ScalaCompile)scalaCompile);
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, (SourceDirectorySet)scalaSource, project, (TaskProvider<? extends AbstractCompile>)compileTask, compileTask.map(AbstractScalaCompile::getOptions));
        project.getTasks().named(sourceSet.getClassesTaskName(), arg_0 -> ScalaBasePlugin.lambda$createScalaCompileTask$10((TaskProvider)compileTask, arg_0));
    }

    private void configureIncrementalAnalysis(Project project, SourceSet sourceSet, Configuration incrementalAnalysis, ScalaCompile scalaCompile) {
        scalaCompile.getAnalysisMappingFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".mapping"));
        IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
        incrementalOptions.getAnalysisFile().set(project.getLayout().getBuildDirectory().file("tmp/scala/compilerAnalysis/" + scalaCompile.getName() + ".analysis"));
        incrementalOptions.getClassfileBackupDir().set(project.getLayout().getBuildDirectory().file("tmp/scala/classfileBackup/" + scalaCompile.getName() + ".bak"));
        Jar jarTask = (Jar)project.getTasks().findByName(sourceSet.getJarTaskName());
        if (jarTask != null) {
            incrementalOptions.getPublishedCode().set(jarTask.getArchiveFile());
        }
        scalaCompile.getAnalysisFiles().from(incrementalAnalysis.getIncoming().artifactView(viewConfiguration -> {
            viewConfiguration.lenient(true);
            viewConfiguration.componentFilter(element -> element instanceof ProjectComponentIdentifier);
        }).getFiles());
        scalaCompile.dependsOn(scalaCompile.getAnalysisFiles());
    }

    private static void configureCompileDefaults(Project project, ScalaRuntime scalaRuntime, DefaultJavaPluginExtension javaExtension) {
        project.getTasks().withType(ScalaCompile.class).configureEach(compile -> {
            ConventionMapping conventionMapping = compile.getConventionMapping();
            conventionMapping.map("scalaClasspath", () -> scalaRuntime.inferScalaClasspath(compile.getClasspath()));
            conventionMapping.map("zincClasspath", () -> project.getConfigurations().getAt(ZINC_CONFIGURATION_NAME));
            conventionMapping.map(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME, () -> project.getConfigurations().getAt(SCALA_COMPILER_PLUGINS_CONFIGURATION_NAME));
            conventionMapping.map("sourceCompatibility", () -> ScalaBasePlugin.computeJavaSourceCompatibilityConvention(javaExtension, compile).toString());
            conventionMapping.map("targetCompatibility", () -> ScalaBasePlugin.computeJavaTargetCompatibilityConvention(javaExtension, compile).toString());
            compile.getScalaCompileOptions().getKeepAliveMode().convention(KeepAliveMode.SESSION);
        });
    }

    private static JavaVersion computeJavaSourceCompatibilityConvention(DefaultJavaPluginExtension javaExtension, ScalaCompile compileTask) {
        JavaVersion rawSourceCompatibility = javaExtension.getRawSourceCompatibility();
        if (rawSourceCompatibility != null) {
            return rawSourceCompatibility;
        }
        return JavaVersion.toVersion(((JavaLauncher)compileTask.getJavaLauncher().get()).getMetadata().getLanguageVersion().toString());
    }

    private static JavaVersion computeJavaTargetCompatibilityConvention(DefaultJavaPluginExtension javaExtension, ScalaCompile compileTask) {
        JavaVersion rawTargetCompatibility = javaExtension.getRawTargetCompatibility();
        if (rawTargetCompatibility != null) {
            return rawTargetCompatibility;
        }
        return JavaVersion.toVersion(compileTask.getSourceCompatibility());
    }

    private void configureScaladoc(Project project, ScalaRuntime scalaRuntime) {
        project.getTasks().withType(ScalaDoc.class).configureEach(scalaDoc -> {
            scalaDoc.getConventionMapping().map("scalaClasspath", () -> scalaRuntime.inferScalaClasspath(scalaDoc.getClasspath()));
            scalaDoc.getConventionMapping().map("destinationDir", () -> ScalaBasePlugin.javaPluginExtension(project).getDocsDir().dir("scaladoc").get().getAsFile());
            scalaDoc.getConventionMapping().map("title", () -> project.getExtensions().getByType(ReportingExtension.class).getApiDocTitle());
            scalaDoc.getJavaLauncher().convention(ScalaBasePlugin.getJavaLauncher(project));
        });
    }

    private static Provider<JavaLauncher> getJavaLauncher(Project project) {
        JavaPluginExtension extension = ScalaBasePlugin.javaPluginExtension(project);
        JavaToolchainService service = ScalaBasePlugin.extensionOf(project, JavaToolchainService.class);
        return service.launcherFor(extension.getToolchain());
    }

    private static JavaPluginExtension javaPluginExtension(Project project) {
        return ScalaBasePlugin.extensionOf(project, JavaPluginExtension.class);
    }

    private static <T> T extensionOf(ExtensionAware extensionAware, Class<T> type) {
        return extensionAware.getExtensions().getByType(type);
    }

    private static /* synthetic */ void lambda$createScalaCompileTask$10(TaskProvider compileTask, Task task) {
        task.dependsOn(compileTask);
    }

    static class UsageDisambiguationRules
    implements AttributeDisambiguationRule<Usage> {
        private final ImmutableSet<Usage> expectedUsages;
        private final Usage javaRuntime;

        @Inject
        UsageDisambiguationRules(Usage incrementalAnalysis, Usage javaApi, Usage javaRuntime) {
            this.javaRuntime = javaRuntime;
            this.expectedUsages = ImmutableSet.of((Object)incrementalAnalysis, (Object)javaApi, (Object)javaRuntime);
        }

        @Override
        public void execute(MultipleCandidatesDetails<Usage> details) {
            if (details.getConsumerValue() == null && details.getCandidateValues().equals(this.expectedUsages)) {
                details.closestMatch(this.javaRuntime);
            }
        }
    }
}

