/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.util.DateUtils;
import org.gradle.api.internal.tasks.testing.junit.result.JUnitXmlResultOptions;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.xml.SimpleXmlWriter;

public class JUnitXmlResultWriter {
    private final String hostName;
    private final TestResultsProvider testResultsProvider;
    private final JUnitXmlResultOptions options;

    public JUnitXmlResultWriter(String hostName, TestResultsProvider testResultsProvider, JUnitXmlResultOptions options) {
        this.hostName = hostName;
        this.testResultsProvider = testResultsProvider;
        this.options = options;
    }

    public void write(TestClassResult result2, OutputStream output) {
        long classId = result2.getId();
        try {
            SimpleXmlWriter writer2 = new SimpleXmlWriter(output, "  ");
            writer2.startElement("testsuite").attribute("name", result2.getXmlTestSuiteName()).attribute("tests", String.valueOf(result2.getTestsCount())).attribute("skipped", String.valueOf(result2.getSkippedCount())).attribute("failures", String.valueOf(result2.getFailuresCount())).attribute("errors", "0").attribute("timestamp", DateUtils.format((long)result2.getStartTime(), (String)"yyyy-MM-dd'T'HH:mm:ss")).attribute("hostname", this.hostName).attribute("time", String.valueOf((double)result2.getDuration() / 1000.0));
            writer2.startElement("properties");
            writer2.endElement();
            List<TestMethodResult> methodResults = result2.getResults();
            String className = result2.getClassName();
            if (this.options.mergeReruns) {
                this.writeTestCasesWithMergeRerunHandling(writer2, methodResults, className, classId);
            } else {
                this.writeTestCasesWithDiscreteRerunHandling(writer2, methodResults, className, classId);
            }
            writer2.startElement("system-out");
            this.writeOutputs(writer2, classId, !this.options.outputPerTestCase, TestOutputEvent.Destination.StdOut);
            writer2.endElement();
            writer2.startElement("system-err");
            this.writeOutputs(writer2, classId, !this.options.outputPerTestCase, TestOutputEvent.Destination.StdErr);
            writer2.endElement();
            writer2.endElement();
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    private void writeOutputs(SimpleXmlWriter writer2, long classId, boolean allClassOutput, TestOutputEvent.Destination destination) throws IOException {
        writer2.startCDATA();
        if (allClassOutput) {
            this.testResultsProvider.writeAllOutput(classId, destination, writer2);
        } else {
            this.testResultsProvider.writeNonTestOutput(classId, destination, writer2);
        }
        writer2.endCDATA();
    }

    private void writeTestCasesWithMergeRerunHandling(SimpleXmlWriter writer2, Iterable<TestMethodResult> methodResults, String className, long classId) throws IOException {
        List<List<TestMethodResult>> groupedExecutions = this.groupExecutions(methodResults);
        for (List<TestMethodResult> groupedExecution : groupedExecutions) {
            if (groupedExecution.size() == 1) {
                this.writeTestCase(writer2, this.discreteTestCase(className, classId, groupedExecution.get(0)));
                continue;
            }
            TestMethodResult firstExecution = groupedExecution.get(0);
            TestMethodResult lastExecution = groupedExecution.get(groupedExecution.size() - 1);
            boolean allFailed = lastExecution.getResultType() == TestResult.ResultType.FAILURE;
            long duration = allFailed ? firstExecution.getDuration() : lastExecution.getDuration();
            this.writeTestCase(writer2, new TestCase(firstExecution.getDisplayName(), className, duration, this.mergeRerunExecutions(allFailed, groupedExecution, firstExecution, classId)));
        }
    }

    private Iterable<TestCaseExecution> mergeRerunExecutions(final boolean allFailed, List<TestMethodResult> groupedExecution, final TestMethodResult firstExecution, final long classId) {
        return Iterables.concat((Iterable)Iterables.transform(groupedExecution, (Function)new Function<TestMethodResult, Iterable<? extends TestCaseExecution>>(){

            public Iterable<? extends TestCaseExecution> apply(TestMethodResult execution) {
                switch (execution.getResultType()) {
                    case SUCCESS: {
                        return Collections.singleton(JUnitXmlResultWriter.this.success(classId, execution.getId()));
                    }
                    case SKIPPED: {
                        return Collections.singleton(JUnitXmlResultWriter.this.skipped(classId, execution.getId()));
                    }
                    case FAILURE: {
                        return JUnitXmlResultWriter.this.failures(classId, execution, allFailed ? (execution == firstExecution ? FailureType.FAILURE : FailureType.RERUN_FAILURE) : FailureType.FLAKY_FAILURE);
                    }
                }
                throw new IllegalStateException("unhandled type: " + (Object)((Object)execution.getResultType()));
            }
        }));
    }

    private List<List<TestMethodResult>> groupExecutions(Iterable<TestMethodResult> methodResults) {
        ArrayList<List<TestMethodResult>> groupedExecutions = new ArrayList<List<TestMethodResult>>();
        HashMap<String, Integer> latestGroupForName = new HashMap<String, Integer>();
        for (TestMethodResult methodResult : methodResults) {
            ArrayList<TestMethodResult> executions;
            String name = methodResult.getDisplayName();
            Integer index = (Integer)latestGroupForName.get(name);
            if (index == null) {
                executions = Collections.singletonList(methodResult);
                groupedExecutions.add(executions);
                if (methodResult.getResultType() != TestResult.ResultType.FAILURE) continue;
                latestGroupForName.put(name, groupedExecutions.size() - 1);
                continue;
            }
            executions = (ArrayList<TestMethodResult>)groupedExecutions.get(index);
            if (executions.size() == 1) {
                executions = new ArrayList<TestMethodResult>(executions);
                groupedExecutions.set(index, executions);
            }
            executions.add(methodResult);
            if (methodResult.getResultType() == TestResult.ResultType.FAILURE) continue;
            latestGroupForName.remove(name);
        }
        return groupedExecutions;
    }

    private void writeTestCasesWithDiscreteRerunHandling(SimpleXmlWriter writer2, Iterable<TestMethodResult> methodResults, String className, long classId) throws IOException {
        for (TestMethodResult methodResult : methodResults) {
            this.writeTestCase(writer2, this.discreteTestCase(className, classId, methodResult));
        }
    }

    private TestCase discreteTestCase(String className, long classId, TestMethodResult methodResult) {
        return new TestCase(methodResult.getDisplayName(), className, methodResult.getDuration(), this.discreteTestCaseExecutions(classId, methodResult));
    }

    private Iterable<? extends TestCaseExecution> discreteTestCaseExecutions(long classId, TestMethodResult methodResult) {
        switch (methodResult.getResultType()) {
            case FAILURE: {
                return this.failures(classId, methodResult, FailureType.FAILURE);
            }
            case SKIPPED: {
                return Collections.singleton(this.skipped(classId, methodResult.getId()));
            }
            case SUCCESS: {
                return Collections.singleton(this.success(classId, methodResult.getId()));
            }
        }
        throw new IllegalStateException("Unexpected result type: " + (Object)((Object)methodResult.getResultType()));
    }

    private void writeTestCase(SimpleXmlWriter writer2, TestCase testCase) throws IOException {
        writer2.startElement("testcase").attribute("name", testCase.name).attribute("classname", testCase.className).attribute("time", String.valueOf((double)testCase.duration / 1000.0));
        for (TestCaseExecution testCaseExecution : testCase.executions) {
            testCaseExecution.write(writer2);
        }
        writer2.endElement();
    }

    private TestCaseExecution success(long classId, long id) {
        return new TestCaseExecutionSuccess(this.outputProvider(classId, id));
    }

    private TestCaseExecution skipped(long classId, long id) {
        return new TestCaseExecutionSkipped(this.outputProvider(classId, id));
    }

    private Iterable<TestCaseExecution> failures(final long classId, final TestMethodResult methodResult, final FailureType failureType) {
        List<TestFailure> failures = methodResult.getFailures();
        if (failures.isEmpty()) {
            return Collections.emptyList();
        }
        final TestFailure firstFailure = failures.get(0);
        return Iterables.transform(failures, (Function)new Function<TestFailure, TestCaseExecution>(){

            public TestCaseExecution apply(TestFailure failure) {
                boolean isFirst = failure == firstFailure;
                OutputProvider outputProvider = isFirst ? JUnitXmlResultWriter.this.outputProvider(classId, methodResult.getId()) : NullOutputProvider.INSTANCE;
                return new TestCaseExecutionFailure(outputProvider, failureType, failure);
            }
        });
    }

    private OutputProvider outputProvider(long classId, long id) {
        return this.options.outputPerTestCase ? new BackedOutputProvider(classId, id) : NullOutputProvider.INSTANCE;
    }

    static class NullOutputProvider
    implements OutputProvider {
        static final OutputProvider INSTANCE = new NullOutputProvider();

        NullOutputProvider() {
        }

        @Override
        public boolean has(TestOutputEvent.Destination destination) {
            return false;
        }

        @Override
        public void write(TestOutputEvent.Destination destination, Writer writer2) {
            throw new UnsupportedOperationException();
        }
    }

    class BackedOutputProvider
    implements OutputProvider {
        private final long classId;
        private final long testId;

        public BackedOutputProvider(long classId, long testId) {
            this.classId = classId;
            this.testId = testId;
        }

        @Override
        public boolean has(TestOutputEvent.Destination destination) {
            return JUnitXmlResultWriter.this.testResultsProvider.hasOutput(this.classId, this.testId, destination);
        }

        @Override
        public void write(TestOutputEvent.Destination destination, Writer writer2) {
            JUnitXmlResultWriter.this.testResultsProvider.writeTestOutput(this.classId, this.testId, destination, writer2);
        }
    }

    static interface OutputProvider {
        public boolean has(TestOutputEvent.Destination var1);

        public void write(TestOutputEvent.Destination var1, Writer var2);
    }

    private static class TestCaseExecutionFailure
    extends TestCaseExecution {
        private final TestFailure failure;
        private final FailureType type;

        TestCaseExecutionFailure(OutputProvider outputProvider, FailureType type, TestFailure failure) {
            super(outputProvider);
            this.failure = failure;
            this.type = type;
        }

        @Override
        public void write(SimpleXmlWriter writer2) throws IOException {
            writer2.startElement(this.type.elementName).attribute("message", this.failure.getMessage()).attribute("type", this.failure.getExceptionType());
            if (this.type.useStacktraceElementAndNestedOutput) {
                writer2.startElement("stackTrace").characters(this.failure.getStackTrace()).endElement();
                this.writeOutput(writer2);
                writer2.endElement();
            } else {
                writer2.characters(this.failure.getStackTrace());
                writer2.endElement();
                this.writeOutput(writer2);
            }
        }
    }

    static enum FailureType {
        FAILURE("failure", false),
        FLAKY_FAILURE("flakyFailure", true),
        RERUN_FAILURE("rerunFailure", true);

        private final String elementName;
        private final boolean useStacktraceElementAndNestedOutput;

        private FailureType(String elementName, boolean useStacktraceElementAndNestedOutput) {
            this.elementName = elementName;
            this.useStacktraceElementAndNestedOutput = useStacktraceElementAndNestedOutput;
        }
    }

    private static class TestCaseExecutionSkipped
    extends TestCaseExecution {
        TestCaseExecutionSkipped(OutputProvider outputProvider) {
            super(outputProvider);
        }

        @Override
        public void write(SimpleXmlWriter writer2) throws IOException {
            writer2.startElement("skipped").endElement();
            this.writeOutput(writer2);
        }
    }

    private static class TestCaseExecutionSuccess
    extends TestCaseExecution {
        TestCaseExecutionSuccess(OutputProvider outputProvider) {
            super(outputProvider);
        }

        @Override
        public void write(SimpleXmlWriter writer2) throws IOException {
            this.writeOutput(writer2);
        }
    }

    private static class TestCase {
        final String name;
        final String className;
        final long duration;
        final Iterable<? extends TestCaseExecution> executions;

        TestCase(String name, String className, long duration, Iterable<? extends TestCaseExecution> executions) {
            this.name = name;
            this.className = className;
            this.duration = duration;
            this.executions = executions;
        }
    }

    static abstract class TestCaseExecution {
        private final OutputProvider outputProvider;

        TestCaseExecution(OutputProvider outputProvider) {
            this.outputProvider = outputProvider;
        }

        abstract void write(SimpleXmlWriter var1) throws IOException;

        protected void writeOutput(SimpleXmlWriter writer2) throws IOException {
            if (this.outputProvider.has(TestOutputEvent.Destination.StdOut)) {
                writer2.startElement("system-out");
                writer2.startCDATA();
                this.outputProvider.write(TestOutputEvent.Destination.StdOut, writer2);
                writer2.endCDATA();
                writer2.endElement();
            }
            if (this.outputProvider.has(TestOutputEvent.Destination.StdErr)) {
                writer2.startElement("system-err");
                writer2.startCDATA();
                this.outputProvider.write(TestOutputEvent.Destination.StdErr, writer2);
                writer2.endCDATA();
                writer2.endElement();
            }
        }
    }
}

