/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NonExtensible;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.ExpandDetails;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultConfigurableFilePermissions;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.copy.ClosureBackedTransformer;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.CopySpecWrapper;
import org.gradle.api.internal.file.copy.MatchingCopyAction;
import org.gradle.api.internal.file.copy.PathNotationConverter;
import org.gradle.api.internal.file.copy.RegExpNameMapper;
import org.gradle.api.internal.file.copy.RenamingCopyAction;
import org.gradle.api.internal.file.copy.SingleParentCopySpec;
import org.gradle.api.internal.file.pattern.PatternMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.util.internal.ConfigureUtil;

@NonExtensible
public class DefaultCopySpec
implements CopySpecInternal {
    private static final NotationParser<Object, String> PATH_NOTATION_PARSER = PathNotationConverter.parser();
    protected final Factory<PatternSet> patternSetFactory;
    protected final FileCollectionFactory fileCollectionFactory;
    protected final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final ConfigurableFileCollection sourcePaths;
    private final PatternSet patternSet;
    private final List<CopySpecInternal> childSpecs = new LinkedList<CopySpecInternal>();
    private final List<CopySpecInternal> childSpecsInAdditionOrder = new LinkedList<CopySpecInternal>();
    private final List<Action<? super FileCopyDetails>> copyActions = new LinkedList<Action<? super FileCopyDetails>>();
    private final Property<ConfigurableFilePermissions> dirPermissions;
    private final Property<ConfigurableFilePermissions> filePermissions;
    private Object destDir;
    private boolean hasCustomActions;
    private Boolean caseSensitive;
    private Boolean includeEmptyDirs;
    private DuplicatesStrategy duplicatesStrategy = DuplicatesStrategy.INHERIT;
    private String filteringCharset;
    private final List<CopySpecInternal.CopySpecListener> listeners = Lists.newLinkedList();
    private PatternFilterable preserve = new PatternSet();

    @Inject
    public DefaultCopySpec(FileCollectionFactory fileCollectionFactory, ObjectFactory objectFactory, Instantiator instantiator2, Factory<PatternSet> patternSetFactory) {
        this(fileCollectionFactory, objectFactory, instantiator2, patternSetFactory, patternSetFactory.create());
    }

    public DefaultCopySpec(FileCollectionFactory fileCollectionFactory, ObjectFactory objectFactory, Instantiator instantiator2, Factory<PatternSet> patternSetFactory, PatternSet patternSet) {
        this.sourcePaths = fileCollectionFactory.configurableFiles();
        this.fileCollectionFactory = fileCollectionFactory;
        this.objectFactory = objectFactory;
        this.instantiator = instantiator2;
        this.patternSetFactory = patternSetFactory;
        this.patternSet = patternSet;
        this.filePermissions = objectFactory.property(ConfigurableFilePermissions.class);
        this.dirPermissions = objectFactory.property(ConfigurableFilePermissions.class);
    }

    public DefaultCopySpec(FileCollectionFactory fileCollectionFactory, ObjectFactory objectFactory, Instantiator instantiator2, Factory<PatternSet> patternSetFactory, @Nullable String destPath, FileCollection source, PatternSet patternSet, Collection<? extends Action<? super FileCopyDetails>> copyActions, Collection<CopySpecInternal> children) {
        this(fileCollectionFactory, objectFactory, instantiator2, patternSetFactory, patternSet);
        this.sourcePaths.from(source);
        this.destDir = destPath;
        this.copyActions.addAll(copyActions);
        for (CopySpecInternal child : children) {
            this.addChildSpec(child);
        }
    }

    @Override
    public boolean hasCustomActions() {
        if (this.hasCustomActions) {
            return true;
        }
        for (CopySpecInternal childSpec : this.childSpecs) {
            if (!childSpec.hasCustomActions()) continue;
            return true;
        }
        return false;
    }

    public List<Action<? super FileCopyDetails>> getCopyActions() {
        return this.copyActions;
    }

    @Override
    public CopySpec with(CopySpec ... copySpecs) {
        for (CopySpec copySpec : copySpecs) {
            CopySpecInternal copySpecInternal;
            if (copySpec instanceof CopySpecSource) {
                CopySpecSource copySpecSource = (CopySpecSource)((Object)copySpec);
                copySpecInternal = copySpecSource.getRootSpec();
            } else {
                copySpecInternal = (CopySpecInternal)copySpec;
            }
            this.addChildSpec(copySpecInternal);
        }
        return this;
    }

    @Override
    public CopySpec from(Object ... sourcePaths) {
        this.sourcePaths.from(sourcePaths);
        return this;
    }

    @Override
    public CopySpec from(Object sourcePath, Closure c) {
        return this.from(sourcePath, (Action)new ClosureBackedAction(c));
    }

    @Override
    public CopySpec from(Object sourcePath, Action<? super CopySpec> configureAction) {
        Preconditions.checkNotNull(configureAction, (Object)"Gradle does not allow passing null for the configuration action for CopySpec.from().");
        CopySpecInternal child = this.addChild();
        child.from(sourcePath);
        CopySpecWrapper wrapper = this.instantiator.newInstance(CopySpecWrapper.class, child);
        configureAction.execute(wrapper);
        return wrapper;
    }

    @Override
    public CopySpecInternal addFirst() {
        return this.addChildAtPosition(0);
    }

    protected CopySpecInternal addChildAtPosition(int position) {
        DefaultCopySpec child = this.instantiator.newInstance(SingleParentCopySpec.class, this.fileCollectionFactory, this.objectFactory, this.instantiator, this.patternSetFactory, this.buildRootResolver());
        this.addChildSpec(position, child);
        return child;
    }

    @Override
    public CopySpecInternal addChild() {
        SingleParentCopySpec child = new SingleParentCopySpec(this.fileCollectionFactory, this.objectFactory, this.instantiator, this.patternSetFactory, this.buildRootResolver());
        this.addChildSpec(child);
        return child;
    }

    @Override
    public CopySpecInternal addChildBeforeSpec(CopySpecInternal childSpec) {
        int position = this.childSpecs.indexOf(childSpec);
        return position != -1 ? this.addChildAtPosition(position) : this.addChild();
    }

    protected void addChildSpec(CopySpecInternal childSpec) {
        this.addChildSpec(this.childSpecs.size(), childSpec);
    }

    protected void addChildSpec(int index, CopySpecInternal childSpec) {
        this.childSpecs.add(index, childSpec);
        int additionIndex = this.childSpecsInAdditionOrder.size();
        this.childSpecsInAdditionOrder.add(childSpec);
        childSpec.addChildSpecListener((path, spec) -> {
            DefaultCopySpecAddress childPath = new DefaultCopySpecAddress(null, this, additionIndex).append(path);
            this.fireChildSpecListeners(childPath, spec);
        });
        childSpec.visit(new DefaultCopySpecAddress(null, this, additionIndex), this::fireChildSpecListeners);
    }

    private void fireChildSpecListeners(CopySpecInternal.CopySpecAddress path, CopySpecInternal spec) {
        for (CopySpecInternal.CopySpecListener listener2 : this.listeners) {
            listener2.childSpecAdded(path, spec);
        }
    }

    @Override
    public void visit(CopySpecInternal.CopySpecAddress parentPath, CopySpecInternal.CopySpecVisitor visitor) {
        visitor.visit(parentPath, this);
        int childIndex = 0;
        for (CopySpecInternal childSpec : this.childSpecsInAdditionOrder) {
            CopySpecInternal.CopySpecAddress childPath = parentPath.append(this, childIndex);
            childSpec.visit(childPath, visitor);
            ++childIndex;
        }
    }

    @Override
    public void addChildSpecListener(CopySpecInternal.CopySpecListener copySpecListener) {
        this.listeners.add(copySpecListener);
    }

    @VisibleForTesting
    public Set<Object> getSourcePaths() {
        return this.sourcePaths.getFrom();
    }

    @Nullable
    public String getDestPath() {
        return this.destDir == null ? null : PATH_NOTATION_PARSER.parseNotation(this.destDir);
    }

    @Override
    public CopySpec into(Object destDir) {
        this.destDir = destDir;
        return this;
    }

    @Override
    public CopySpec into(Object destPath, Closure configureClosure) {
        return this.into(destPath, new ClosureBackedAction(configureClosure));
    }

    @Override
    public CopySpec into(Object destPath, Action<? super CopySpec> copySpec) {
        Preconditions.checkNotNull(copySpec, (Object)"Gradle does not allow passing null for the configuration action for CopySpec.into().");
        CopySpecInternal child = this.addChild();
        child.into(destPath);
        CopySpecWrapper wrapper = this.instantiator.newInstance(CopySpecWrapper.class, child);
        copySpec.execute(wrapper);
        return wrapper;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.buildRootResolver().isCaseSensitive();
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        return this.buildRootResolver().getIncludeEmptyDirs();
    }

    @Override
    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    public DuplicatesStrategy getDuplicatesStrategyForThisSpec() {
        return this.duplicatesStrategy;
    }

    @Override
    public DuplicatesStrategy getDuplicatesStrategy() {
        return this.buildRootResolver().getDuplicatesStrategy();
    }

    @Override
    public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
        this.duplicatesStrategy = strategy;
    }

    @Override
    public CopySpec filesMatching(String pattern, Action<? super FileCopyDetails> action) {
        PatternMatcher matcher = PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), pattern);
        return this.eachFile((Action)new MatchingCopyAction(matcher, action));
    }

    @Override
    public CopySpec filesMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        if (!patterns.iterator().hasNext()) {
            throw new InvalidUserDataException("must provide at least one pattern to match");
        }
        PatternMatcher matcher = PatternMatcherFactory.getPatternsMatcher(true, this.isCaseSensitive(), patterns);
        return this.eachFile((Action)new MatchingCopyAction(matcher, action));
    }

    @Override
    public CopySpec filesNotMatching(String pattern, Action<? super FileCopyDetails> action) {
        PatternMatcher matcher = PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), pattern);
        return this.eachFile((Action)new MatchingCopyAction(matcher.negate(), action));
    }

    @Override
    public CopySpec filesNotMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        if (!patterns.iterator().hasNext()) {
            throw new InvalidUserDataException("must provide at least one pattern to not match");
        }
        PatternMatcher matcher = PatternMatcherFactory.getPatternsMatcher(true, this.isCaseSensitive(), patterns);
        return this.eachFile((Action)new MatchingCopyAction(matcher.negate(), action));
    }

    public PatternSet getPatterns() {
        return this.patternSet;
    }

    @Override
    public CopySpec include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public CopySpec include(Iterable<String> includes) {
        this.patternSet.include((Iterable)includes);
        return this;
    }

    @Override
    public CopySpec include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include((Spec)includeSpec);
        return this;
    }

    @Override
    public CopySpec include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public CopySpec setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes((Iterable)includes);
        return this;
    }

    @Override
    public CopySpec exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public CopySpec exclude(Iterable<String> excludes) {
        this.patternSet.exclude((Iterable)excludes);
        return this;
    }

    @Override
    public CopySpec exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public CopySpec exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public CopySpec setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public CopySpec rename(String sourceRegEx, String replaceWith) {
        this.appendCopyAction(new RenamingCopyAction(new RegExpNameMapper(sourceRegEx, replaceWith)));
        return this;
    }

    @Override
    public CopySpec rename(Pattern sourceRegEx, String replaceWith) {
        this.appendCopyAction(new RenamingCopyAction(new RegExpNameMapper(sourceRegEx, replaceWith)));
        return this;
    }

    @Override
    public CopySpec filter(Class<? extends FilterReader> filterType) {
        this.appendCopyAction(new TypeBackedFilterAction(filterType));
        return this;
    }

    @Override
    public CopySpec filter(Closure closure) {
        return this.filter((Transformer)new ClosureBackedTransformer(closure));
    }

    @Override
    public CopySpec filter(Transformer<String, String> transformer) {
        this.appendCopyAction(new TransformerBackedFilterAction(transformer));
        return this;
    }

    @Override
    public CopySpec filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
        this.appendCopyAction(new MapTypeBackedFilterAction(properties, filterType));
        return this;
    }

    @Override
    public CopySpec expand(Map<String, ?> properties) {
        this.appendCopyAction(new MapBackedExpandAction(properties, Actions.doNothing()));
        return this;
    }

    @Override
    public CopySpec expand(Map<String, ?> properties, Action<? super ExpandDetails> action) {
        this.appendCopyAction(new MapBackedExpandAction(properties, action));
        return this;
    }

    @Override
    public CopySpec rename(Closure closure) {
        return this.rename((Transformer)new ClosureBackedTransformer(closure));
    }

    @Override
    public CopySpec rename(Transformer<String, String> renamer) {
        this.appendCopyAction(new RenamingCopyAction(renamer));
        return this;
    }

    @Override
    public Integer getDirMode() {
        return this.getMode(this.buildRootResolver().getDirPermissions());
    }

    @Override
    public Integer getFileMode() {
        return this.getMode(this.buildRootResolver().getFilePermissions());
    }

    @Nullable
    private Integer getMode(Provider<ConfigurableFilePermissions> permissions) {
        return permissions.map(FilePermissions::toUnixNumeric).getOrNull();
    }

    @Override
    public CopyProcessingSpec setDirMode(@Nullable Integer mode) {
        this.dirPermissions.set(mode == null ? null : (ConfigurableFilePermissions)this.objectFactory.newInstance(DefaultConfigurableFilePermissions.class, this.objectFactory, mode));
        return this;
    }

    @Override
    public CopyProcessingSpec setFileMode(@Nullable Integer mode) {
        this.filePermissions.set(mode == null ? null : (ConfigurableFilePermissions)this.objectFactory.newInstance(DefaultConfigurableFilePermissions.class, this.objectFactory, mode));
        return this;
    }

    @Override
    public Property<ConfigurableFilePermissions> getFilePermissions() {
        return this.filePermissions;
    }

    @Override
    public CopyProcessingSpec filePermissions(Action<? super ConfigurableFilePermissions> configureAction) {
        DefaultConfigurableFilePermissions permissions = this.objectFactory.newInstance(DefaultConfigurableFilePermissions.class, this.objectFactory, DefaultConfigurableFilePermissions.getDefaultUnixNumeric(false));
        configureAction.execute(permissions);
        this.filePermissions.set(permissions);
        return this;
    }

    @Override
    public Property<ConfigurableFilePermissions> getDirPermissions() {
        return this.dirPermissions;
    }

    @Override
    public CopyProcessingSpec dirPermissions(Action<? super ConfigurableFilePermissions> configureAction) {
        DefaultConfigurableFilePermissions permissions = this.objectFactory.newInstance(DefaultConfigurableFilePermissions.class, this.objectFactory, DefaultConfigurableFilePermissions.getDefaultUnixNumeric(true));
        configureAction.execute(permissions);
        this.dirPermissions.set(permissions);
        return this;
    }

    @Override
    public CopySpec eachFile(Action<? super FileCopyDetails> action) {
        this.appendCopyAction(action);
        return this;
    }

    private void appendCopyAction(Action<? super FileCopyDetails> action) {
        this.hasCustomActions = true;
        this.copyActions.add(action);
    }

    @Override
    public void appendCachingSafeCopyAction(Action<? super FileCopyDetails> action) {
        this.copyActions.add(action);
    }

    @Override
    public PatternFilterable getPreserve() {
        return this.preserve;
    }

    @Override
    public CopySpecInternal preserve(Action<? super PatternFilterable> action) {
        action.execute(this.preserve);
        return this;
    }

    @Override
    public CopySpec eachFile(Closure closure) {
        this.appendCopyAction(ConfigureUtil.configureUsing(closure));
        return this;
    }

    public Collection<CopySpecInternal> getChildren() {
        return this.childSpecs;
    }

    @Override
    public void walk(Action<? super CopySpecResolver> action) {
        this.buildRootResolver().walk(action);
    }

    @Override
    public CopySpecResolver buildResolverRelativeToParent(CopySpecResolver parent) {
        return new DefaultCopySpecResolver(parent);
    }

    @Override
    public CopySpecResolver buildRootResolver() {
        return new DefaultCopySpecResolver(null);
    }

    public FileCollection getSourceRootsForThisSpec() {
        return this.sourcePaths;
    }

    @Override
    public String getFilteringCharset() {
        return this.buildRootResolver().getFilteringCharset();
    }

    @Override
    public void setFilteringCharset(String charset) {
        Preconditions.checkNotNull((Object)charset, (Object)"filteringCharset must not be null");
        if (!Charset.isSupported(charset)) {
            throw new InvalidUserDataException(String.format("filteringCharset %s is not supported by your JVM", charset));
        }
        this.filteringCharset = charset;
    }

    private static class DefaultCopySpecAddress
    implements CopySpecInternal.CopySpecAddress {
        private final DefaultCopySpecAddress parent;
        private final CopySpecInternal spec;
        private final int additionIndex;

        public DefaultCopySpecAddress(@Nullable DefaultCopySpecAddress parent, CopySpecInternal spec, int additionIndex) {
            this.parent = parent;
            this.spec = spec;
            this.additionIndex = additionIndex;
        }

        @Override
        public CopySpecInternal.CopySpecAddress getParent() {
            return this.parent;
        }

        @Override
        public CopySpecInternal getSpec() {
            return this.spec;
        }

        @Override
        public int getAdditionIndex() {
            return this.additionIndex;
        }

        @Override
        public DefaultCopySpecAddress append(CopySpecInternal spec, int additionIndex) {
            return new DefaultCopySpecAddress(this, spec, additionIndex);
        }

        @Override
        public DefaultCopySpecAddress append(CopySpecInternal.CopySpecAddress relativeAddress) {
            CopySpecInternal.CopySpecAddress parent = relativeAddress.getParent();
            DefaultCopySpecAddress newParent = parent == null ? this : this.append(parent);
            return new DefaultCopySpecAddress(newParent, relativeAddress.getSpec(), relativeAddress.getAdditionIndex());
        }

        @Override
        public CopySpecResolver unroll(StringBuilder path) {
            CopySpecResolver resolver = this.parent != null ? this.spec.buildResolverRelativeToParent(this.parent.unroll(path)) : this.spec.buildRootResolver();
            path.append("$").append(this.additionIndex + 1);
            return resolver;
        }

        public String toString() {
            String parentPath = this.parent == null ? "" : this.parent.toString();
            return parentPath + "$" + (this.additionIndex + 1);
        }
    }

    public class DefaultCopySpecResolver
    implements CopySpecResolver {
        @Nullable
        private final CopySpecResolver parentResolver;

        private DefaultCopySpecResolver(CopySpecResolver parent) {
            this.parentResolver = parent;
        }

        @Override
        public RelativePath getDestPath() {
            RelativePath parentPath = this.parentResolver == null ? new RelativePath(false, new String[0]) : this.parentResolver.getDestPath();
            String path = DefaultCopySpec.this.getDestPath();
            if (path == null) {
                return parentPath;
            }
            if (path.startsWith("/") || path.startsWith(File.separator)) {
                return RelativePath.parse(false, path);
            }
            return RelativePath.parse(false, parentPath, path);
        }

        @Override
        public FileTree getSource() {
            return DefaultCopySpec.this.getSourceRootsForThisSpec().getAsFileTree().matching(this.getPatternSet());
        }

        @Override
        public FileTree getAllSource() {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.walk(copySpecResolver -> builder.add((Object)((FileTreeInternal)Cast.uncheckedCast(copySpecResolver.getSource()))));
            return DefaultCopySpec.this.fileCollectionFactory.treeOf((List<? extends FileTreeInternal>)builder.build());
        }

        @Override
        public Collection<? extends Action<? super FileCopyDetails>> getAllCopyActions() {
            if (this.parentResolver == null) {
                return DefaultCopySpec.this.copyActions;
            }
            ArrayList<? extends Action<? super FileCopyDetails>> allActions = new ArrayList<Action<? super FileCopyDetails>>();
            allActions.addAll(this.parentResolver.getAllCopyActions());
            allActions.addAll(DefaultCopySpec.this.copyActions);
            return allActions;
        }

        @Override
        public List<String> getAllIncludes() {
            ArrayList<String> result2 = new ArrayList<String>();
            if (this.parentResolver != null) {
                result2.addAll(this.parentResolver.getAllIncludes());
            }
            result2.addAll(DefaultCopySpec.this.patternSet.getIncludes());
            return result2;
        }

        @Override
        public List<String> getAllExcludes() {
            ArrayList<String> result2 = new ArrayList<String>();
            if (this.parentResolver != null) {
                result2.addAll(this.parentResolver.getAllExcludes());
            }
            result2.addAll(DefaultCopySpec.this.patternSet.getExcludes());
            return result2;
        }

        @Override
        public List<Spec<FileTreeElement>> getAllExcludeSpecs() {
            ArrayList<Spec<FileTreeElement>> result2 = new ArrayList<Spec<FileTreeElement>>();
            if (this.parentResolver != null) {
                result2.addAll(this.parentResolver.getAllExcludeSpecs());
            }
            result2.addAll(DefaultCopySpec.this.patternSet.getExcludeSpecs());
            return result2;
        }

        @Override
        public DuplicatesStrategy getDuplicatesStrategy() {
            if (DefaultCopySpec.this.duplicatesStrategy != DuplicatesStrategy.INHERIT) {
                return DefaultCopySpec.this.duplicatesStrategy;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getDuplicatesStrategy();
            }
            return DuplicatesStrategy.INCLUDE;
        }

        @Override
        public boolean isDefaultDuplicateStrategy() {
            if (DefaultCopySpec.this.duplicatesStrategy != DuplicatesStrategy.INHERIT) {
                return false;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.isDefaultDuplicateStrategy();
            }
            return true;
        }

        @Override
        public boolean isCaseSensitive() {
            if (DefaultCopySpec.this.caseSensitive != null) {
                return DefaultCopySpec.this.caseSensitive;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.isCaseSensitive();
            }
            return true;
        }

        @Override
        public Integer getFileMode() {
            return this.getMode(this.getImmutableFilePermissions());
        }

        @Override
        public Integer getDirMode() {
            return this.getMode(this.getImmutableDirPermissions());
        }

        @Nullable
        private Integer getMode(Provider<FilePermissions> permissions) {
            return permissions.map(FilePermissions::toUnixNumeric).getOrNull();
        }

        @Override
        public Provider<ConfigurableFilePermissions> getFilePermissions() {
            return DefaultCopySpec.this.filePermissions;
        }

        @Override
        public Provider<FilePermissions> getImmutableFilePermissions() {
            return this.getPermissions(DefaultCopySpec.this.filePermissions, CopySpecResolver::getImmutableFilePermissions);
        }

        @Override
        public Provider<ConfigurableFilePermissions> getDirPermissions() {
            return DefaultCopySpec.this.dirPermissions;
        }

        @Override
        public Provider<FilePermissions> getImmutableDirPermissions() {
            return this.getPermissions(DefaultCopySpec.this.dirPermissions, CopySpecResolver::getImmutableDirPermissions);
        }

        private Provider<FilePermissions> getPermissions(Property<ConfigurableFilePermissions> property2, Function<CopySpecResolver, Provider<FilePermissions>> parentMapper) {
            if (property2.isPresent() || this.parentResolver == null) {
                property2.finalizeValueOnRead();
                return (Provider)Cast.uncheckedCast(property2);
            }
            return parentMapper.apply(this.parentResolver);
        }

        @Override
        public boolean getIncludeEmptyDirs() {
            if (DefaultCopySpec.this.includeEmptyDirs != null) {
                return DefaultCopySpec.this.includeEmptyDirs;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getIncludeEmptyDirs();
            }
            return true;
        }

        @Override
        public List<Spec<FileTreeElement>> getAllIncludeSpecs() {
            ArrayList<Spec<FileTreeElement>> result2 = new ArrayList<Spec<FileTreeElement>>();
            if (this.parentResolver != null) {
                result2.addAll(this.parentResolver.getAllIncludeSpecs());
            }
            result2.addAll(DefaultCopySpec.this.patternSet.getIncludeSpecs());
            return result2;
        }

        public PatternSet getPatternSet() {
            PatternSet patterns = DefaultCopySpec.this.patternSetFactory.create();
            assert (patterns != null);
            patterns.setCaseSensitive(this.isCaseSensitive());
            patterns.include(this.getAllIncludes());
            patterns.includeSpecs(this.getAllIncludeSpecs());
            patterns.exclude(this.getAllExcludes());
            patterns.excludeSpecs(this.getAllExcludeSpecs());
            return patterns;
        }

        @Override
        public void walk(Action<? super CopySpecResolver> action) {
            action.execute(this);
            for (CopySpecInternal child : DefaultCopySpec.this.getChildren()) {
                child.buildResolverRelativeToParent(this).walk(action);
            }
        }

        @Override
        public String getFilteringCharset() {
            if (DefaultCopySpec.this.filteringCharset != null) {
                return DefaultCopySpec.this.filteringCharset;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getFilteringCharset();
            }
            return Charset.defaultCharset().name();
        }
    }

    private static class MapTypeBackedFilterAction
    implements Action<FileCopyDetails> {
        private final Map<String, ?> properties;
        private final Class<? extends FilterReader> filterType;

        public MapTypeBackedFilterAction(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
            this.properties = properties;
            this.filterType = filterType;
        }

        @Override
        public void execute(FileCopyDetails fileCopyDetails) {
            fileCopyDetails.filter(this.properties, this.filterType);
        }
    }

    private static class TransformerBackedFilterAction
    implements Action<FileCopyDetails> {
        private final Transformer<String, String> transformer;

        public TransformerBackedFilterAction(Transformer<String, String> transformer) {
            this.transformer = transformer;
        }

        @Override
        public void execute(FileCopyDetails fileCopyDetails) {
            fileCopyDetails.filter(this.transformer);
        }
    }

    private static class TypeBackedFilterAction
    implements Action<FileCopyDetails> {
        private final Class<? extends FilterReader> filterType;

        public TypeBackedFilterAction(Class<? extends FilterReader> filterType) {
            this.filterType = filterType;
        }

        @Override
        public void execute(FileCopyDetails fileCopyDetails) {
            fileCopyDetails.filter(this.filterType);
        }
    }

    private static class MapBackedExpandAction
    implements Action<FileCopyDetails> {
        private final Map<String, ?> properties;
        private final Action<? super ExpandDetails> action;

        public MapBackedExpandAction(Map<String, ?> properties, Action<? super ExpandDetails> action) {
            this.properties = properties;
            this.action = action;
        }

        @Override
        public void execute(FileCopyDetails fileCopyDetails) {
            fileCopyDetails.expand(this.properties, this.action);
        }
    }
}

