/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AntFileCollectionBuilder;
import org.gradle.api.internal.file.AntFileCollectionMatchingTaskBuilder;
import org.gradle.api.internal.file.AntFileSetBuilder;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionBackedFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.FilteredFileCollection;
import org.gradle.api.internal.file.SubtractingFileCollection;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.FileBackedDirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.provider.BuildableBackedSetProvider;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.internal.Factory;
import org.gradle.internal.MutableBoolean;
import org.gradle.internal.deprecation.DocumentedFailure;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.util.internal.GUtil;

public abstract class AbstractFileCollection
implements FileCollectionInternal {
    protected final TaskDependencyFactory taskDependencyFactory;
    protected final Factory<PatternSet> patternSetFactory;

    protected AbstractFileCollection(TaskDependencyFactory taskDependencyFactory, Factory<PatternSet> patternSetFactory) {
        this.taskDependencyFactory = taskDependencyFactory;
        this.patternSetFactory = patternSetFactory;
    }

    protected AbstractFileCollection(TaskDependencyFactory taskDependencyFactory) {
        this(taskDependencyFactory, PatternSets.getNonCachingPatternSetFactory());
    }

    public AbstractFileCollection() {
        this(DefaultTaskDependencyFactory.withNoAssociatedProject());
    }

    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public final TreeFormatter describeContents(TreeFormatter formatter) {
        formatter.node("collection type: ").appendType(this.getClass()).append(" (id: ").append(String.valueOf(System.identityHashCode(this))).append(")");
        formatter.startChildren();
        this.appendContents(formatter);
        formatter.endChildren();
        return formatter;
    }

    protected void appendContents(TreeFormatter formatter) {
    }

    @Override
    public final TaskDependency getBuildDependencies() {
        this.assertCanCarryBuildDependencies();
        DefaultTaskDependency result2 = this.taskDependencyFactory.visitingDependencies(context -> context.add(this));
        result2.setToStringProvider(() -> "Dependencies of " + this.getDisplayName());
        return result2;
    }

    protected void assertCanCarryBuildDependencies() {
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
    }

    @Override
    public FileCollectionInternal replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
        if (original == this) {
            return supplier.get();
        }
        return this;
    }

    @Override
    public Set<File> getFiles() {
        final LinkedHashSet<File> files = new LinkedHashSet<File>();
        this.visitContents(new FileCollectionStructureVisitor(){

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                for (File content : contents) {
                    files.add(content);
                }
            }

            private void addTreeContents(FileTreeInternal fileTree) {
                files.addAll(fileTree.getFiles());
            }

            @Override
            public void visitFileTree(File root, PatternSet patterns, FileTreeInternal fileTree) {
                this.addTreeContents(fileTree);
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                this.addTreeContents(fileTree);
            }
        });
        return files;
    }

    @Override
    public File getSingleFile() throws IllegalStateException {
        Iterator<File> iterator = this.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains no files.", this.getDisplayName()));
        }
        File singleFile = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains more than one file.", this.getDisplayName()));
        }
        return singleFile;
    }

    @Override
    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    @Override
    public String getAsPath() {
        this.showGetAsPathDeprecationWarning();
        return GUtil.asPath(this);
    }

    private void showGetAsPathDeprecationWarning() {
        List filesAsPaths = this.getFiles().stream().map(File::getPath).filter((? super T path) -> path.contains(File.pathSeparator)).collect(Collectors.toList());
        if (!filesAsPaths.isEmpty()) {
            String displayedFilePaths = filesAsPaths.stream().map(path -> "'" + path + "'").collect(Collectors.joining(","));
            throw ((DocumentedFailure.Builder)DocumentedFailure.builder().withSummary(String.format("Converting files to a classpath string when their paths contain the path separator '%s' is not supported. The path separator is not a valid element of a file path.", File.pathSeparator)).withContext(String.format("Problematic paths in '%s' are: %s.", this.getDisplayName(), displayedFilePaths)).withAdvice("Add the individual files to the file collection instead.").withUpgradeGuideSection(7, "file_collection_to_classpath")).build();
        }
    }

    @Override
    public boolean contains(File file) {
        return this.getFiles().contains(file);
    }

    @Override
    public FileCollection plus(FileCollection collection) {
        return new UnionFileCollection(this.taskDependencyFactory, this, (FileCollectionInternal)collection);
    }

    @Override
    public Provider<Set<FileSystemLocation>> getElements() {
        return new BuildableBackedSetProvider<AbstractFileCollection, FileSystemLocation>(this, new FileCollectionElementsFactory(this));
    }

    @Override
    public FileCollection minus(FileCollection collection) {
        return new SubtractingFileCollection(this, collection);
    }

    @Override
    public void addToAntBuilder(Object builder, String nodeName, FileCollection.AntType type) {
        if (type == FileCollection.AntType.ResourceCollection) {
            this.addAsResourceCollection(builder, nodeName);
        } else if (type == FileCollection.AntType.FileSet) {
            this.addAsFileSet(builder, nodeName);
        } else {
            this.addAsMatchingTask(builder, nodeName);
        }
    }

    protected void addAsMatchingTask(Object builder, String nodeName) {
        new AntFileCollectionMatchingTaskBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsFileSet(Object builder, String nodeName) {
        new AntFileSetBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileCollectionBuilder(this).addToAntBuilder(builder, nodeName);
    }

    protected Collection<DirectoryTree> getAsFileTrees() {
        final ArrayList<DirectoryTree> fileTrees = new ArrayList<DirectoryTree>();
        this.visitStructure(new FileCollectionStructureVisitor(){

            @Override
            public void visitCollection(FileCollectionInternal.Source source, Iterable<File> contents) {
                for (File file : contents) {
                    if (!file.isFile()) continue;
                    fileTrees.add(new FileBackedDirectoryFileTree(file));
                }
            }

            @Override
            public void visitFileTree(final File root, final PatternSet patterns, FileTreeInternal fileTree) {
                if (root.isFile()) {
                    fileTrees.add(new FileBackedDirectoryFileTree(root));
                } else if (root.isDirectory()) {
                    fileTrees.add(new DirectoryTree(){

                        @Override
                        public File getDir() {
                            return root;
                        }

                        @Override
                        public PatternSet getPatterns() {
                            return patterns;
                        }
                    });
                }
            }

            @Override
            public void visitFileTreeBackedByFile(File file, FileTreeInternal fileTree, FileSystemMirroringFileTree sourceTree) {
                if (AbstractFileCollection.visitAll(sourceTree)) {
                    fileTrees.add(sourceTree.getMirror());
                }
            }
        });
        return fileTrees;
    }

    protected static boolean visitAll(FileSystemMirroringFileTree tree) {
        final MutableBoolean hasContent = new MutableBoolean();
        tree.visit(new FileVisitor(){

            @Override
            public void visitDir(FileVisitDetails dirDetails) {
                dirDetails.getFile();
                hasContent.set(true);
            }

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                fileDetails.getFile();
                hasContent.set(true);
            }
        });
        return hasContent.get();
    }

    @Override
    public Object addToAntBuilder(Object node, String childNodeName) {
        this.addToAntBuilder(node, childNodeName, FileCollection.AntType.ResourceCollection);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    @Override
    public FileTreeInternal getAsFileTree() {
        return new FileCollectionBackedFileTree(this.taskDependencyFactory, this.patternSetFactory, this);
    }

    @Override
    public FileCollection filter(Closure filterClosure) {
        return this.filter(Specs.convertClosureToSpec(filterClosure));
    }

    @Override
    public FileCollectionInternal filter(Spec<? super File> filterSpec) {
        return new FilteredFileCollection(this, filterSpec);
    }

    @Override
    public final void visitStructure(FileCollectionStructureVisitor visitor) {
        if (visitor.startVisit(OTHER, this)) {
            this.visitContents(visitor);
        }
    }

    protected void visitContents(FileCollectionStructureVisitor visitor) {
        visitor.visitCollection(OTHER, this);
    }

    private static class FileCollectionElementsFactory
    implements Factory<Set<FileSystemLocation>> {
        private final FileCollection fileCollection;

        private FileCollectionElementsFactory(FileCollection fileCollection) {
            this.fileCollection = fileCollection;
        }

        @Override
        public Set<FileSystemLocation> create() {
            Set<File> files = this.fileCollection.getFiles();
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)files.size());
            for (File file : files) {
                builder.add((Object)new DefaultFileSystemLocation(file));
            }
            return builder.build();
        }
    }
}

