/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContext;
import org.gradle.internal.fingerprint.hashing.RegularFileSnapshotContextHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class SplitResourceSnapshotterCacheService
implements ResourceSnapshotterCacheService {
    private final ResourceSnapshotterCacheService globalCache;
    private final ResourceSnapshotterCacheService localCache;
    private final GlobalCacheLocations globalCacheLocations;

    public SplitResourceSnapshotterCacheService(ResourceSnapshotterCacheService globalCache, ResourceSnapshotterCacheService localCache, GlobalCacheLocations globalCacheLocations) {
        this.globalCache = globalCache;
        this.localCache = localCache;
        this.globalCacheLocations = globalCacheLocations;
    }

    @Override
    @Nullable
    public HashCode hashFile(FileSystemLocationSnapshot snapshot, FileSystemLocationSnapshotHasher hasher, HashCode configurationHash) throws IOException {
        if (this.globalCacheLocations.isInsideGlobalCache(snapshot.getAbsolutePath())) {
            return this.globalCache.hashFile(snapshot, hasher, configurationHash);
        }
        return this.localCache.hashFile(snapshot, hasher, configurationHash);
    }

    @Override
    public HashCode hashFile(RegularFileSnapshotContext fileSnapshotContext, RegularFileSnapshotContextHasher hasher, HashCode configurationHash) throws IOException {
        if (this.globalCacheLocations.isInsideGlobalCache(fileSnapshotContext.getSnapshot().getAbsolutePath())) {
            return this.globalCache.hashFile(fileSnapshotContext, hasher, configurationHash);
        }
        return this.localCache.hashFile(fileSnapshotContext, hasher, configurationHash);
    }
}

