/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AbstractAttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

class DefaultMutableAttributeContainer
extends AbstractAttributeContainer
implements AttributeContainerInternal {
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private ImmutableAttributes state = ImmutableAttributes.EMPTY;
    private Map<Attribute<?>, Provider<?>> lazyAttributes = (Map)Cast.uncheckedCast(Collections.EMPTY_MAP);
    private boolean realizingAttributes = false;

    public DefaultMutableAttributeContainer(ImmutableAttributesFactory immutableAttributesFactory) {
        this.immutableAttributesFactory = immutableAttributesFactory;
    }

    public String toString() {
        TreeMap sorted = new TreeMap(Comparator.comparing(Attribute::getName));
        this.lazyAttributes.keySet().forEach(key -> sorted.put((Attribute)key, this.lazyAttributes.get(key).toString()));
        this.state.keySet().forEach(key -> sorted.put((Attribute)key, this.state.getAttribute(key)));
        return ((Object)sorted).toString();
    }

    @Override
    public Set<Attribute<?>> keySet() {
        return ImmutableSet.copyOf((Collection)Sets.union(this.state.keySet(), this.lazyAttributes.keySet()));
    }

    @Override
    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        this.checkInsertionAllowed(key);
        this.doInsertion(key, value);
        return this;
    }

    private <T> void doInsertion(Attribute<T> key, T value) {
        this.assertAttributeValueIsNotNull(value);
        this.assertAttributeTypeIsValid(value.getClass(), key);
        this.state = this.immutableAttributesFactory.concat(this.state, key, value);
        this.removeLazyAttributeIfPresent(key);
    }

    private <T> void removeLazyAttributeIfPresent(Attribute<T> key) {
        if (this.lazyAttributes.containsKey(key)) {
            this.lazyAttributes.remove(key);
        }
    }

    @Override
    public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
        Class valueType;
        this.checkInsertionAllowed(key);
        this.assertAttributeValueIsNotNull(provider);
        if (provider instanceof ProviderInternal && (valueType = ((ProviderInternal)Cast.uncheckedCast(provider)).getType()) != null) {
            this.assertAttributeTypeIsValid(valueType, key);
        }
        this.doInsertionLazy(key, provider);
        return this;
    }

    private <T> void checkInsertionAllowed(Attribute<T> key) {
        if (this.realizingAttributes) {
            throw new IllegalStateException("Cannot add new attribute '" + key.getName() + "' while realizing all attributes of the container.");
        }
        for (Attribute<?> attribute : this.keySet()) {
            String name = key.getName();
            if (!attribute.getName().equals(name) || attribute.getType() == key.getType()) continue;
            throw new IllegalArgumentException("Cannot have two attributes with the same name but different types. This container already has an attribute named '" + name + "' of type '" + attribute.getType().getName() + "' and you are trying to store another one of type '" + key.getType().getName() + "'");
        }
    }

    private <T> void assertAttributeTypeIsValid(Class<?> valueType, Attribute<T> attribute) {
        if (!attribute.getType().isAssignableFrom(valueType)) {
            throw new IllegalArgumentException(String.format("Unexpected type for attribute '%s' provided. Expected a value of type %s but found a value of type %s.", attribute.getName(), attribute.getType().getName(), valueType.getName()));
        }
    }

    private void assertAttributeValueIsNotNull(@Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Setting null as an attribute value is not allowed");
        }
    }

    @Override
    public <T> T getAttribute(Attribute<T> key) {
        T attribute = this.state.getAttribute(key);
        if (attribute == null && this.lazyAttributes.containsKey(key)) {
            attribute = this.realizeLazyAttribute(key);
        }
        return attribute;
    }

    @Override
    public ImmutableAttributes asImmutable() {
        this.realizeAllLazyAttributes();
        return this.state;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMutableAttributeContainer that = (DefaultMutableAttributeContainer)o;
        return Objects.equals(this.asImmutable(), that.asImmutable());
    }

    @Override
    public int hashCode() {
        return this.asImmutable().hashCode();
    }

    private <T> void doInsertionLazy(Attribute<T> key, Provider<? extends T> provider) {
        if (this.lazyAttributes == Collections.EMPTY_MAP) {
            this.lazyAttributes = new LinkedHashMap(1);
        }
        this.lazyAttributes.put(key, provider);
        this.removeAttributeIfPresent(key);
    }

    private <T> void removeAttributeIfPresent(Attribute<T> key) {
        if (this.state.contains(key)) {
            DefaultMutableAttributeContainer newState = new DefaultMutableAttributeContainer(this.immutableAttributesFactory);
            this.state.keySet().stream().filter(k -> !k.equals(key)).forEach(k -> {
                Attribute objectKey = k;
                newState.attribute(objectKey, Objects.requireNonNull(this.state.getAttribute(k)));
            });
            this.state = newState.asImmutable();
        }
    }

    private <T> T realizeLazyAttribute(Attribute<T> key) {
        Object value = this.lazyAttributes.get(key).get();
        this.doInsertion(key, value);
        return (T)value;
    }

    private void realizeAllLazyAttributes() {
        if (!this.lazyAttributes.isEmpty()) {
            LinkedHashSet savedKeys = new LinkedHashSet(this.lazyAttributes.keySet());
            try {
                this.realizingAttributes = true;
                savedKeys.forEach(key -> {
                    Provider<?> value = this.lazyAttributes.get(key);
                    if (value != null) {
                        this.doInsertion((Attribute)Cast.uncheckedNonnullCast(key), value.get());
                    }
                });
            }
            finally {
                this.realizingAttributes = false;
            }
        }
    }
}

