/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ComponentMetadataListerDetails;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.descriptor.UrlRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataSource;
import org.gradle.api.internal.artifacts.repositories.resolver.DefaultExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourceVersionLister;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultModuleDescriptorArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleDescriptorArtifactMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactFileResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.BuildableTypedResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.local.ByteArrayReadableContent;
import org.gradle.internal.resource.local.FileReadableContent;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.util.internal.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalResourceResolver<T extends ModuleComponentResolveMetadata>
implements ConfiguredModuleComponentRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalResourceResolver.class);
    private final String name;
    private final ImmutableList<ResourcePattern> ivyPatterns;
    private final ImmutableList<ResourcePattern> artifactPatterns;
    private ComponentResolvers componentResolvers;
    private final ExternalResourceRepository repository;
    private final boolean local;
    private final CacheAwareExternalResourceAccessor cachingResourceAccessor;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final ImmutableMetadataSources metadataSources;
    private final MetadataArtifactProvider metadataArtifactProvider;
    private final InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplierFactory;
    private final InstantiatingAction<ComponentMetadataListerDetails> providedVersionLister;
    private final Instantiator injector;
    private final ChecksumService checksumService;
    private final String id;
    private ExternalResourceArtifactResolver cachedArtifactResolver;

    protected ExternalResourceResolver(UrlRepositoryDescriptor descriptor, boolean local, ExternalResourceRepository repository, CacheAwareExternalResourceAccessor cachingResourceAccessor, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, ImmutableMetadataSources metadataSources, MetadataArtifactProvider metadataArtifactProvider, @Nullable InstantiatingAction<ComponentMetadataSupplierDetails> componentMetadataSupplierFactory, @Nullable InstantiatingAction<ComponentMetadataListerDetails> providedVersionLister, Instantiator injector, ChecksumService checksumService) {
        this.id = descriptor.getId();
        this.name = descriptor.getName();
        this.ivyPatterns = descriptor.getMetadataResources();
        this.artifactPatterns = descriptor.getArtifactResources();
        this.local = local;
        this.cachingResourceAccessor = cachingResourceAccessor;
        this.repository = repository;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.metadataSources = metadataSources;
        this.metadataArtifactProvider = metadataArtifactProvider;
        this.componentMetadataSupplierFactory = componentMetadataSupplierFactory;
        this.providedVersionLister = providedVersionLister;
        this.injector = injector;
        this.checksumService = checksumService;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected abstract Class<T> getSupportedMetadataType();

    @Override
    public boolean isDynamicResolveMode() {
        return false;
    }

    @Override
    public void setComponentResolvers(ComponentResolvers resolver) {
        this.componentResolvers = resolver;
    }

    protected ExternalResourceRepository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public Instantiator getComponentMetadataInstantiator() {
        return this.injector;
    }

    @Override
    public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
        return this.componentMetadataSupplierFactory;
    }

    @VisibleForTesting
    public InstantiatingAction<ComponentMetadataListerDetails> getProvidedVersionLister() {
        return this.providedVersionLister;
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        throw new UnsupportedOperationException();
    }

    private void doListModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result2) {
        ModuleIdentifier module = dependency.getSelector().getModuleIdentifier();
        this.tryListingViaRule(module, result2);
        if (result2.hasResult() && result2.isAuthoritative()) {
            return;
        }
        ResourceVersionLister versionLister = new ResourceVersionLister(this.repository);
        List<ResourcePattern> completeIvyPatterns = this.filterComplete((List<ResourcePattern>)this.ivyPatterns, module);
        List<ResourcePattern> completeArtifactPatterns = this.filterComplete((List<ResourcePattern>)this.artifactPatterns, module);
        for (MetadataSource metadataSource : this.metadataSources.sources()) {
            metadataSource.listModuleVersions(dependency, module, completeIvyPatterns, completeArtifactPatterns, versionLister, result2);
            if (!result2.hasResult() || !result2.isAuthoritative()) continue;
            return;
        }
        result2.listed((Collection<String>)ImmutableSet.of());
    }

    private void tryListingViaRule(ModuleIdentifier module, BuildableModuleVersionListingResolveResult result2) {
        if (this.providedVersionLister != null) {
            this.providedVersionLister.execute(new DefaultComponentVersionsLister(module, result2));
        }
    }

    private List<ResourcePattern> filterComplete(List<ResourcePattern> ivyPatterns, ModuleIdentifier module) {
        return CollectionUtils.filter(ivyPatterns, element -> element.isComplete(module));
    }

    protected void doResolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata prescribedMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result2) {
        this.resolveStaticDependency(moduleComponentIdentifier, prescribedMetaData, result2, this.createArtifactResolver());
    }

    protected final void resolveStaticDependency(ModuleComponentIdentifier moduleVersionIdentifier, ComponentOverrideMetadata prescribedMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result2, ExternalResourceArtifactResolver artifactResolver) {
        for (MetadataSource source : this.metadataSources.sources()) {
            Object value = source.create(this.name, this.componentResolvers, moduleVersionIdentifier, prescribedMetaData, artifactResolver, result2);
            if (value == null) continue;
            this.maybeDisableComponentMetadataRuleCaching((MutableModuleComponentResolveMetadata)value);
            result2.resolved(value.asImmutable());
            return;
        }
        LOGGER.debug("No meta-data file or artifact found for module '{}' in repository '{}'.", (Object)moduleVersionIdentifier, (Object)this.getName());
        result2.missing();
    }

    private void maybeDisableComponentMetadataRuleCaching(MutableModuleComponentResolveMetadata value) {
        if (this.isLocal()) {
            value.setComponentMetadataRuleCachingEnabled(false);
        }
    }

    protected abstract boolean isMetaDataArtifact(ArtifactType var1);

    protected Set<ModuleComponentArtifactMetadata> findOptionalArtifacts(ModuleComponentResolveMetadata module, String type, String classifier) {
        ModuleComponentArtifactMetadata artifact = module.artifact(type, "jar", classifier);
        if (this.createArtifactResolver(module.getSources()).artifactExists(artifact, new DefaultResourceAwareResolveResult())) {
            return ImmutableSet.of((Object)artifact);
        }
        return Collections.emptySet();
    }

    private ModuleDescriptorArtifactMetadata getMetaDataArtifactFor(ModuleComponentIdentifier moduleComponentIdentifier) {
        IvyArtifactName ivyArtifactName = this.metadataArtifactProvider.getMetaDataArtifactName(moduleComponentIdentifier.getModule());
        return new DefaultModuleDescriptorArtifactMetadata(moduleComponentIdentifier, ivyArtifactName);
    }

    protected ExternalResourceArtifactResolver createArtifactResolver() {
        ExternalResourceArtifactResolver artifactResolver;
        if (this.cachedArtifactResolver != null) {
            return this.cachedArtifactResolver;
        }
        this.cachedArtifactResolver = artifactResolver = this.createArtifactResolver((List<ResourcePattern>)this.ivyPatterns, (List<ResourcePattern>)this.artifactPatterns);
        return artifactResolver;
    }

    private ExternalResourceArtifactResolver createArtifactResolver(List<ResourcePattern> ivyPatterns, List<ResourcePattern> artifactPatterns) {
        return new DefaultExternalResourceArtifactResolver(this.repository, this.locallyAvailableResourceFinder, ivyPatterns, artifactPatterns, this.artifactFileStore, this.cachingResourceAccessor);
    }

    protected ExternalResourceArtifactResolver createArtifactResolver(ModuleSources moduleSources) {
        return this.createArtifactResolver();
    }

    public void publish(ModuleComponentArtifactMetadata artifact, File src) {
        ResourcePattern destinationPattern;
        if ("ivy".equals(artifact.getName().getType()) && !this.ivyPatterns.isEmpty()) {
            destinationPattern = (ResourcePattern)this.ivyPatterns.get(0);
        } else if (!this.artifactPatterns.isEmpty()) {
            destinationPattern = (ResourcePattern)this.artifactPatterns.get(0);
        } else {
            throw new IllegalStateException("impossible to publish " + artifact + " using " + this + ": no artifact pattern defined");
        }
        ExternalResourceName destination = destinationPattern.getLocation(artifact);
        this.put(src, destination);
        LOGGER.info("Published {} to {}", (Object)artifact, (Object)destination);
    }

    private void put(File src, ExternalResourceName destination) {
        this.repository.withProgressLogging().resource(destination).put(new FileReadableContent(src));
        this.publishChecksums(destination, src);
    }

    private void publishChecksums(ExternalResourceName destination, File content) {
        this.publishChecksum(destination, content, "sha1", 40);
        if (!ExternalResourceResolver.disableExtraChecksums()) {
            this.publishPossiblyUnsupportedChecksum(destination, content, "sha-256", 64);
            this.publishPossiblyUnsupportedChecksum(destination, content, "sha-512", 128);
        }
    }

    private void publishPossiblyUnsupportedChecksum(ExternalResourceName destination, File content, String algorithm, int length) {
        try {
            this.publishChecksum(destination, content, algorithm, length);
        }
        catch (Exception ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("Cannot upload checksum for " + content.getName() + " because the remote repository doesn't support " + algorithm + ". This will not fail the build.", (Throwable)ex);
            }
            LOGGER.warn("Cannot upload checksum for " + content.getName() + " because the remote repository doesn't support " + algorithm + ". This will not fail the build.");
        }
    }

    private void publishChecksum(ExternalResourceName destination, File content, String algorithm, int length) {
        byte[] checksum = this.createChecksumFile(content, algorithm.toUpperCase(), length);
        ExternalResourceName checksumDestination = destination.append("." + algorithm.replaceAll("-", ""));
        this.repository.resource(checksumDestination).put(new ByteArrayReadableContent(checksum));
    }

    private byte[] createChecksumFile(File src, String algorithm, int checksumLength) {
        HashCode hash = this.checksumService.hash(src, algorithm);
        String formattedHashString = hash.toString();
        try {
            return formattedHashString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public List<String> getIvyPatterns() {
        return CollectionUtils.collect(this.ivyPatterns, ResourcePattern::getPattern);
    }

    public List<String> getArtifactPatterns() {
        return CollectionUtils.collect(this.artifactPatterns, ResourcePattern::getPattern);
    }

    public static boolean disableExtraChecksums() {
        return Boolean.getBoolean("org.gradle.internal.publish.checksums.insecure");
    }

    private static class DefaultComponentVersionsLister
    implements ComponentMetadataListerDetails {
        private final ModuleIdentifier id;
        private final BuildableModuleVersionListingResolveResult result;

        private DefaultComponentVersionsLister(ModuleIdentifier id, BuildableModuleVersionListingResolveResult result2) {
            this.id = id;
            this.result = result2;
        }

        @Override
        public ModuleIdentifier getModuleIdentifier() {
            return this.id;
        }

        @Override
        public void listed(List<String> versions) {
            this.result.listed(versions);
        }
    }

    private static class NoOpResourceAwareResolveResult
    implements ResourceAwareResolveResult {
        private static final NoOpResourceAwareResolveResult INSTANCE = new NoOpResourceAwareResolveResult();

        private NoOpResourceAwareResolveResult() {
        }

        @Override
        public List<String> getAttempted() {
            return Collections.emptyList();
        }

        @Override
        public void attempted(String locationDescription) {
        }

        @Override
        public void attempted(ExternalResourceName location) {
        }

        @Override
        public void applyTo(ResourceAwareResolveResult target) {
            throw new UnsupportedOperationException();
        }
    }

    protected abstract class RemoteRepositoryAccess
    extends AbstractRepositoryAccess {
        protected RemoteRepositoryAccess() {
        }

        public String toString() {
            return "remote > " + ExternalResourceResolver.this;
        }

        @Override
        public final void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result2) {
            ExternalResourceResolver.this.doListModuleVersions(dependency, result2);
        }

        @Override
        public final void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result2) {
            ExternalResourceResolver.this.doResolveComponentMetaData(moduleComponentIdentifier, requestMetaData, result2);
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result2) {
            super.resolveArtifactsWithType(component, artifactType, result2);
            this.checkArtifactsResolved(component, (Object)artifactType, result2);
        }

        private void checkArtifactsResolved(ComponentResolveMetadata component, Object context, BuildableTypedResolveResult<?, ? super ArtifactResolveException> result2) {
            if (!result2.hasResult()) {
                result2.failed(new ArtifactResolveException(component.getId(), String.format("Cannot locate %s for '%s' in repository '%s'", context, component, ExternalResourceResolver.this.name)));
            }
        }

        @Override
        protected final void resolveMetaDataArtifacts(T module, BuildableArtifactSetResolveResult result2) {
        }

        @Override
        protected void resolveJavadocArtifacts(T module, BuildableArtifactSetResolveResult result2) {
            result2.resolved(ExternalResourceResolver.this.findOptionalArtifacts((ModuleComponentResolveMetadata)module, "javadoc", "javadoc"));
        }

        @Override
        protected void resolveSourceArtifacts(T module, BuildableArtifactSetResolveResult result2) {
            result2.resolved(ExternalResourceResolver.this.findOptionalArtifacts((ModuleComponentResolveMetadata)module, "source", "sources"));
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactFileResolveResult result2) {
            if (artifact.isOptionalArtifact() && artifact instanceof ModuleComponentArtifactMetadata) {
                if (!ExternalResourceResolver.this.createArtifactResolver(moduleSources).artifactExists((ModuleComponentArtifactMetadata)artifact, new DefaultResourceAwareResolveResult())) {
                    result2.notFound(artifact.getId());
                    return;
                }
            } else if (artifact.getAlternativeArtifact().isPresent()) {
                DefaultResourceAwareResolveResult checkForArtifact = new DefaultResourceAwareResolveResult();
                if (!ExternalResourceResolver.this.createArtifactResolver(moduleSources).artifactExists((ModuleComponentArtifactMetadata)artifact, checkForArtifact)) {
                    checkForArtifact.getAttempted().forEach(result2::attempted);
                    this.resolveArtifact(artifact.getAlternativeArtifact().get(), moduleSources, result2);
                    return;
                }
            }
            try {
                ExternalResourceArtifactResolver resolver = ExternalResourceResolver.this.createArtifactResolver(moduleSources);
                ModuleComponentArtifactMetadata moduleArtifact = (ModuleComponentArtifactMetadata)artifact;
                LocallyAvailableExternalResource artifactResource = resolver.resolveArtifact(moduleArtifact, result2);
                if (artifactResource == null) {
                    result2.notFound(artifact.getId());
                } else {
                    result2.resolved(artifactResource.getFile());
                }
            }
            catch (Exception e) {
                result2.failed(new ArtifactResolveException(artifact.getId(), (Throwable)e));
            }
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            if (ExternalResourceResolver.this.local) {
                ModuleDescriptorArtifactMetadata artifact = ExternalResourceResolver.this.getMetaDataArtifactFor(moduleComponentIdentifier);
                if (ExternalResourceResolver.this.createArtifactResolver().artifactExists(artifact, NoOpResourceAwareResolveResult.INSTANCE)) {
                    return MetadataFetchingCost.FAST;
                }
                return MetadataFetchingCost.CHEAP;
            }
            return MetadataFetchingCost.EXPENSIVE;
        }
    }

    protected abstract class LocalRepositoryAccess
    extends AbstractRepositoryAccess {
        protected LocalRepositoryAccess() {
        }

        public String toString() {
            return "local > " + ExternalResourceResolver.this;
        }

        @Override
        public final void listModuleVersions(ModuleDependencyMetadata dependency, BuildableModuleVersionListingResolveResult result2) {
        }

        @Override
        public final void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> result2) {
        }

        @Override
        protected final void resolveMetaDataArtifacts(T module, BuildableArtifactSetResolveResult result2) {
            ModuleDescriptorArtifactMetadata artifact = ExternalResourceResolver.this.getMetaDataArtifactFor(module.getId());
            result2.resolved(Collections.singleton(artifact));
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactFileResolveResult result2) {
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return MetadataFetchingCost.CHEAP;
        }
    }

    protected abstract class AbstractRepositoryAccess
    implements ModuleComponentRepositoryAccess<ModuleComponentResolveMetadata> {
        protected AbstractRepositoryAccess() {
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result2) {
            ModuleComponentResolveMetadata moduleMetaData = (ModuleComponentResolveMetadata)ExternalResourceResolver.this.getSupportedMetadataType().cast(component);
            if (artifactType == ArtifactType.JAVADOC) {
                this.resolveJavadocArtifacts(moduleMetaData, result2);
            } else if (artifactType == ArtifactType.SOURCES) {
                this.resolveSourceArtifacts(moduleMetaData, result2);
            } else if (ExternalResourceResolver.this.isMetaDataArtifact(artifactType)) {
                this.resolveMetaDataArtifacts(moduleMetaData, result2);
            }
        }

        protected abstract void resolveMetaDataArtifacts(T var1, BuildableArtifactSetResolveResult var2);

        protected abstract void resolveJavadocArtifacts(T var1, BuildableArtifactSetResolveResult var2);

        protected abstract void resolveSourceArtifacts(T var1, BuildableArtifactSetResolveResult var2);
    }
}

