/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;

public abstract class AbstractDependencyMetadataAdapter<T extends DependencyMetadata<T>>
implements DependencyMetadata<T> {
    private final ImmutableAttributesFactory attributesFactory;
    private ModuleDependencyMetadata metadata;

    public AbstractDependencyMetadataAdapter(ImmutableAttributesFactory attributesFactory, ModuleDependencyMetadata metadata) {
        this.attributesFactory = attributesFactory;
        this.metadata = metadata;
    }

    public ModuleDependencyMetadata getMetadata() {
        return this.metadata;
    }

    protected void updateMetadata(ModuleDependencyMetadata modifiedMetadata) {
        this.metadata = modifiedMetadata;
    }

    @Override
    public String getGroup() {
        return this.getMetadata().getSelector().getGroup();
    }

    @Override
    public String getName() {
        return this.getMetadata().getSelector().getModule();
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.getMetadata().getSelector().getVersionConstraint();
    }

    @Override
    public T version(Action<? super MutableVersionConstraint> configureAction) {
        DefaultMutableVersionConstraint mutableVersionConstraint = new DefaultMutableVersionConstraint(this.getVersionConstraint());
        configureAction.execute(mutableVersionConstraint);
        this.updateMetadata(this.getMetadata().withRequestedVersion(mutableVersionConstraint));
        return (T)((DependencyMetadata)Cast.uncheckedCast(this));
    }

    @Override
    public T because(String reason) {
        this.updateMetadata(this.getMetadata().withReason(reason));
        return (T)((DependencyMetadata)Cast.uncheckedCast(this));
    }

    @Override
    public ModuleIdentifier getModule() {
        return this.getMetadata().getSelector().getModuleIdentifier();
    }

    @Override
    public String getReason() {
        return this.getMetadata().getReason();
    }

    public String toString() {
        return this.getGroup() + ":" + this.getName() + ":" + this.getVersionConstraint();
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.getMetadata().getSelector().getAttributes();
    }

    @Override
    public T attributes(Action<? super AttributeContainer> configureAction) {
        ModuleComponentSelector selector = this.getMetadata().getSelector();
        AttributeContainerInternal attributes = this.attributesFactory.mutable((AttributeContainerInternal)selector.getAttributes());
        configureAction.execute(attributes);
        ModuleComponentSelector target = DefaultModuleComponentSelector.newSelector(selector.getModuleIdentifier(), selector.getVersionConstraint(), attributes.asImmutable(), selector.getRequestedCapabilities());
        ModuleDependencyMetadata metadata = (ModuleDependencyMetadata)this.getMetadata().withTarget(target);
        this.updateMetadata(metadata);
        return (T)((DependencyMetadata)Cast.uncheckedCast(this));
    }

    public void forced() {
        ModuleDependencyMetadata originalMetadata = this.getMetadata();
        if (originalMetadata instanceof ForcingDependencyMetadata) {
            this.updateMetadata((ModuleDependencyMetadata)((Object)((ForcingDependencyMetadata)((Object)originalMetadata)).forced()));
        }
    }
}

