/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.util.Collection;
import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.AwsCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.credentials.HttpHeaderCredentials;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.authentication.Authentication;
import org.gradle.internal.Cast;
import org.gradle.internal.authentication.AllSchemesAuthentication;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.internal.credentials.DefaultAwsCredentials;
import org.gradle.internal.credentials.DefaultHttpHeaderCredentials;
import org.gradle.internal.credentials.DefaultPasswordCredentials;
import org.gradle.internal.reflect.Instantiator;

public class AuthenticationSupporter {
    private final Instantiator instantiator;
    private final AuthenticationContainer authenticationContainer;
    private final ProviderFactory providerFactory;
    private final Property<Credentials> credentials;
    private boolean usesCredentials = false;

    public AuthenticationSupporter(Instantiator instantiator2, ObjectFactory objectFactory, AuthenticationContainer authenticationContainer, ProviderFactory providerFactory) {
        this.instantiator = instantiator2;
        this.authenticationContainer = authenticationContainer;
        this.credentials = objectFactory.property(Credentials.class);
        this.providerFactory = providerFactory;
    }

    public PasswordCredentials getCredentials() {
        if (!this.usesCredentials()) {
            return this.setCredentials(PasswordCredentials.class);
        }
        if (this.credentials.get() instanceof PasswordCredentials) {
            return (PasswordCredentials)Cast.uncheckedCast(this.credentials.get());
        }
        throw new IllegalStateException("Can not use getCredentials() method when not using PasswordCredentials; please use getCredentials(Class)");
    }

    public <T extends Credentials> T getCredentials(Class<T> credentialsType) {
        if (!this.usesCredentials()) {
            return this.setCredentials(credentialsType);
        }
        if (credentialsType.isInstance(this.credentials.get())) {
            return (T)((Credentials)Cast.uncheckedCast(this.credentials.get()));
        }
        throw new IllegalArgumentException(String.format("Given credentials type '%s' does not match actual type '%s'", credentialsType.getName(), AuthenticationSupporter.getCredentialsPublicType(((Credentials)this.credentials.get()).getClass()).getName()));
    }

    public void credentials(Action<? super PasswordCredentials> action) {
        if (this.usesCredentials() && !(this.credentials.get() instanceof PasswordCredentials)) {
            throw new IllegalStateException("Can not use credentials(Action) method when not using PasswordCredentials; please use credentials(Class, Action)");
        }
        this.credentials(PasswordCredentials.class, action);
    }

    public <T extends Credentials> void credentials(Class<T> credentialsType, Action<? super T> action) throws IllegalStateException {
        action.execute(this.getCredentials(credentialsType));
    }

    public void credentials(Class<? extends Credentials> credentialsType, Provider<String> identity) {
        this.usesCredentials = true;
        this.credentials.set(this.providerFactory.credentials(credentialsType, identity));
    }

    public void setConfiguredCredentials(Credentials credentials) {
        this.usesCredentials = true;
        this.credentials.set(credentials);
    }

    private <T extends Credentials> T setCredentials(Class<T> clazz) {
        this.usesCredentials = true;
        T t = this.newCredentials(clazz);
        this.credentials.set((Credentials)t);
        return t;
    }

    private <T extends Credentials> T newCredentials(Class<T> clazz) {
        return (T)((Credentials)this.instantiator.newInstance(AuthenticationSupporter.getCredentialsImplType(clazz), new Object[0]));
    }

    public Property<Credentials> getConfiguredCredentials() {
        return this.credentials;
    }

    public void authentication(Action<? super AuthenticationContainer> action) {
        action.execute(this.getAuthentication());
    }

    public AuthenticationContainer getAuthentication() {
        return this.authenticationContainer;
    }

    public Collection<Authentication> getConfiguredAuthentication() {
        this.populateAuthenticationCredentials();
        if (this.usesCredentials() && this.authenticationContainer.size() == 0) {
            return Collections.singleton(new AllSchemesAuthentication((Credentials)this.credentials.get()));
        }
        return this.getAuthentication();
    }

    boolean usesCredentials() {
        return this.usesCredentials;
    }

    private void populateAuthenticationCredentials() {
        for (Authentication authentication : this.authenticationContainer) {
            ((AuthenticationInternal)authentication).setCredentials((Credentials)this.credentials.getOrNull());
        }
    }

    private static <T extends Credentials> Class<? extends T> getCredentialsImplType(Class<T> publicType) {
        if (publicType == PasswordCredentials.class) {
            return (Class)Cast.uncheckedCast(DefaultPasswordCredentials.class);
        }
        if (publicType == AwsCredentials.class) {
            return (Class)Cast.uncheckedCast(DefaultAwsCredentials.class);
        }
        if (publicType == HttpHeaderCredentials.class) {
            return (Class)Cast.uncheckedCast(DefaultHttpHeaderCredentials.class);
        }
        throw new IllegalArgumentException(String.format("Unknown credentials type: '%s' (supported types: %s, %s and %s).", publicType.getName(), PasswordCredentials.class.getName(), AwsCredentials.class.getName(), HttpHeaderCredentials.class.getName()));
    }

    private static <T extends Credentials> Class<? super T> getCredentialsPublicType(Class<T> implType) {
        if (PasswordCredentials.class.isAssignableFrom(implType)) {
            return (Class)Cast.uncheckedCast(PasswordCredentials.class);
        }
        if (AwsCredentials.class.isAssignableFrom(implType)) {
            return (Class)Cast.uncheckedCast(AwsCredentials.class);
        }
        if (HttpHeaderCredentials.class.isAssignableFrom(implType)) {
            return (Class)Cast.uncheckedCast(HttpHeaderCredentials.class);
        }
        throw new IllegalArgumentException(String.format("Unknown credentials implementation type: '%s' (supported types: %s, %s and %s).", implType.getName(), DefaultPasswordCredentials.class.getName(), DefaultAwsCredentials.class.getName(), DefaultHttpHeaderCredentials.class.getName()));
    }
}

