/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.BuildIdentifierSerializer;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.local.model.DefaultLibraryBinaryIdentifier;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.Path;

public class ComponentIdentifierSerializer
extends AbstractSerializer<ComponentIdentifier> {
    private final BuildIdentifierSerializer buildIdentifierSerializer = new BuildIdentifierSerializer();

    @Override
    public ComponentIdentifier read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        Implementation implementation = Implementation.valueOf(id);
        if (implementation == null) {
            throw new IllegalArgumentException("Unable to find component identifier type with id: " + id);
        }
        switch (implementation) {
            case ROOT_PROJECT: {
                BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
                String projectName = decoder.readString();
                return new DefaultProjectComponentIdentifier(buildIdentifier, Path.ROOT, Path.ROOT, projectName);
            }
            case ROOT_BUILD_PROJECT: {
                BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
                Path projectPath = Path.path(decoder.readString());
                return new DefaultProjectComponentIdentifier(buildIdentifier, projectPath, projectPath, projectPath.getName());
            }
            case OTHER_BUILD_ROOT_PROJECT: {
                BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
                Path identityPath = Path.path(decoder.readString());
                return new DefaultProjectComponentIdentifier(buildIdentifier, identityPath, Path.ROOT, identityPath.getName());
            }
            case OTHER_BUILD_PROJECT: {
                BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
                Path identityPath = Path.path(decoder.readString());
                Path projectPath = Path.path(decoder.readString());
                return new DefaultProjectComponentIdentifier(buildIdentifier, identityPath, projectPath, identityPath.getName());
            }
            case MODULE: {
                return new DefaultModuleComponentIdentifier(DefaultModuleIdentifier.newId(decoder.readString(), decoder.readString()), decoder.readString());
            }
            case SNAPSHOT: {
                return new MavenUniqueSnapshotComponentIdentifier(DefaultModuleIdentifier.newId(decoder.readString(), decoder.readString()), decoder.readString(), decoder.readString());
            }
            case LIBRARY: {
                return new DefaultLibraryBinaryIdentifier(decoder.readString(), decoder.readString(), decoder.readString());
            }
            case OPAQUE: {
                return new OpaqueComponentArtifactIdentifier(new File(decoder.readString()));
            }
            case OPAQUE_NOTATION: {
                return new OpaqueComponentIdentifier(ComponentIdentifierSerializer.readClassPathNotation(decoder));
            }
        }
        throw new IllegalArgumentException("Unsupported component identifier implementation: " + (Object)((Object)implementation));
    }

    @Override
    public void write(Encoder encoder, ComponentIdentifier value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component identifier may not be null");
        }
        Implementation implementation = this.resolveImplementation(value);
        encoder.writeByte(implementation.id);
        switch (implementation) {
            case MODULE: {
                ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)value;
                encoder.writeString(moduleComponentIdentifier.getGroup());
                encoder.writeString(moduleComponentIdentifier.getModule());
                encoder.writeString(moduleComponentIdentifier.getVersion());
                break;
            }
            case SNAPSHOT: {
                MavenUniqueSnapshotComponentIdentifier snapshotIdentifier = (MavenUniqueSnapshotComponentIdentifier)value;
                encoder.writeString(snapshotIdentifier.getGroup());
                encoder.writeString(snapshotIdentifier.getModule());
                encoder.writeString(snapshotIdentifier.getVersion());
                encoder.writeString(snapshotIdentifier.getTimestamp());
                break;
            }
            case ROOT_PROJECT: {
                ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)value;
                this.writeBuildIdentifierOf(projectComponentIdentifier, encoder);
                encoder.writeString(projectComponentIdentifier.getProjectName());
                break;
            }
            case ROOT_BUILD_PROJECT: {
                ProjectComponentIdentifier projectComponentIdentifier = (ProjectComponentIdentifier)value;
                this.writeBuildIdentifierOf(projectComponentIdentifier, encoder);
                encoder.writeString(projectComponentIdentifier.getProjectPath());
                break;
            }
            case OTHER_BUILD_ROOT_PROJECT: {
                DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)value;
                this.writeBuildIdentifierOf(projectComponentIdentifier, encoder);
                encoder.writeString(projectComponentIdentifier.getIdentityPath().getPath());
                break;
            }
            case OTHER_BUILD_PROJECT: {
                DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)value;
                this.writeBuildIdentifierOf(projectComponentIdentifier, encoder);
                encoder.writeString(projectComponentIdentifier.getIdentityPath().getPath());
                encoder.writeString(projectComponentIdentifier.getProjectPath());
                break;
            }
            case LIBRARY: {
                LibraryBinaryIdentifier libraryIdentifier = (LibraryBinaryIdentifier)value;
                encoder.writeString(libraryIdentifier.getProjectPath());
                encoder.writeString(libraryIdentifier.getLibraryName());
                encoder.writeString(libraryIdentifier.getVariant());
                break;
            }
            case OPAQUE: {
                OpaqueComponentArtifactIdentifier opaqueIdentifier = (OpaqueComponentArtifactIdentifier)value;
                encoder.writeString(opaqueIdentifier.getFile().getPath());
                break;
            }
            case OPAQUE_NOTATION: {
                OpaqueComponentIdentifier opaqueIdentifier = (OpaqueComponentIdentifier)value;
                ComponentIdentifierSerializer.writeClassPathNotation(encoder, opaqueIdentifier.getClassPathNotation());
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported implementation type: " + (Object)((Object)implementation));
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ComponentIdentifierSerializer rhs = (ComponentIdentifierSerializer)obj;
        return Objects.equal((Object)this.buildIdentifierSerializer, (Object)rhs.buildIdentifierSerializer);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.buildIdentifierSerializer});
    }

    private static void writeClassPathNotation(Encoder encoder, DependencyFactoryInternal.ClassPathNotation classPathNotation) throws IOException {
        encoder.writeSmallInt(classPathNotation.ordinal());
    }

    private static DependencyFactoryInternal.ClassPathNotation readClassPathNotation(Decoder decoder) throws IOException {
        int ordinal = decoder.readSmallInt();
        return DependencyFactoryInternal.ClassPathNotation.values()[ordinal];
    }

    private void writeBuildIdentifierOf(ProjectComponentIdentifier projectComponentIdentifier, Encoder encoder) throws IOException {
        this.buildIdentifierSerializer.write(encoder, projectComponentIdentifier.getBuild());
    }

    private Implementation resolveImplementation(ComponentIdentifier value) {
        if (value instanceof MavenUniqueSnapshotComponentIdentifier) {
            return Implementation.SNAPSHOT;
        }
        if (value instanceof ModuleComponentIdentifier) {
            return Implementation.MODULE;
        }
        if (value instanceof DefaultProjectComponentIdentifier) {
            DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)value;
            boolean isARootProject = projectComponentIdentifier.projectPath().equals(Path.ROOT);
            if (projectComponentIdentifier.getIdentityPath().equals(Path.ROOT) && isARootProject) {
                return Implementation.ROOT_PROJECT;
            }
            if (projectComponentIdentifier.getIdentityPath().equals(projectComponentIdentifier.projectPath()) && projectComponentIdentifier.projectPath().getName().equals(projectComponentIdentifier.getProjectName())) {
                return Implementation.ROOT_BUILD_PROJECT;
            }
            if (isARootProject && projectComponentIdentifier.getProjectName().equals(projectComponentIdentifier.getIdentityPath().getName())) {
                return Implementation.OTHER_BUILD_ROOT_PROJECT;
            }
            return Implementation.OTHER_BUILD_PROJECT;
        }
        if (value instanceof LibraryBinaryIdentifier) {
            return Implementation.LIBRARY;
        }
        if (value instanceof OpaqueComponentArtifactIdentifier) {
            return Implementation.OPAQUE;
        }
        if (value instanceof OpaqueComponentIdentifier) {
            return Implementation.OPAQUE_NOTATION;
        }
        throw new IllegalArgumentException("Unsupported component identifier class: " + value.getClass());
    }

    private static enum Implementation {
        MODULE(1),
        ROOT_PROJECT(2),
        ROOT_BUILD_PROJECT(3),
        OTHER_BUILD_ROOT_PROJECT(4),
        OTHER_BUILD_PROJECT(5),
        LIBRARY(6),
        SNAPSHOT(7),
        OPAQUE(8),
        OPAQUE_NOTATION(9);

        private final byte id;

        @Nullable
        public static Implementation valueOf(int id) {
            Implementation[] values = Implementation.values();
            if (id >= values[0].id && id <= values[values.length - 1].id) {
                return values[id - 1];
            }
            return null;
        }

        private Implementation(int id) {
            this.id = (byte)id;
        }
    }
}

