/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ComponentStateFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;

class SelectorStateResolverResults {
    private final Comparator<Version> versionComparator;
    private final VersionParser versionParser;
    private final List<Registration> results;

    public SelectorStateResolverResults(Comparator<Version> versionComparator, VersionParser versionParser, int size) {
        this.versionParser = versionParser;
        this.results = Lists.newArrayListWithCapacity((int)size);
        this.versionComparator = versionComparator;
    }

    public <T extends ComponentResolutionState> List<T> getResolved(ComponentStateFactory<T> componentFactory) {
        ModuleVersionResolveException failure = null;
        ArrayList resolved = null;
        boolean hasSoftForce = this.hasSoftForce();
        int size = this.results.size();
        for (int i = 0; i < size; ++i) {
            Registration entry = this.results.get(i);
            ResolvableSelectorState selectorState = entry.selector;
            ComponentIdResolveResult idResolveResult = entry.result;
            if (selectorState.isForce() && !hasSoftForce) {
                T forcedComponent = SelectorStateResolverResults.componentForIdResolveResult(componentFactory, idResolveResult, selectorState);
                return Collections.singletonList(forcedComponent);
            }
            if (!idResolveResult.mark(this)) continue;
            if (idResolveResult.getFailure() == null) {
                T componentState = SelectorStateResolverResults.componentForIdResolveResult(componentFactory, idResolveResult, selectorState);
                if (resolved == null) {
                    resolved = Lists.newArrayList();
                }
                resolved.add(componentState);
                continue;
            }
            if (failure != null) continue;
            failure = idResolveResult.getFailure();
        }
        if (resolved == null && failure != null) {
            throw failure;
        }
        return resolved == null ? Collections.emptyList() : resolved;
    }

    static <T extends ComponentResolutionState> boolean isVersionAllowedByPlatform(T componentState) {
        Set<VirtualPlatformState> platformOwners = componentState.getPlatformOwners();
        if (!platformOwners.isEmpty()) {
            for (VirtualPlatformState platformOwner : platformOwners) {
                if (!platformOwner.isGreaterThanForcedVersion(componentState.getVersion())) continue;
                return false;
            }
        } else {
            VirtualPlatformState platform = componentState.getPlatformState();
            return platform == null || !platform.isGreaterThanForcedVersion(componentState.getVersion());
        }
        return true;
    }

    private boolean hasSoftForce() {
        int size = this.results.size();
        for (int i = 0; i < size; ++i) {
            Registration entry = this.results.get(i);
            ResolvableSelectorState selectorState = entry.selector;
            if (!selectorState.isSoftForce()) continue;
            return true;
        }
        return false;
    }

    public static <T extends ComponentResolutionState> T componentForIdResolveResult(ComponentStateFactory<T> componentFactory, ComponentIdResolveResult idResolveResult, ResolvableSelectorState selector) {
        T component = componentFactory.getRevision(idResolveResult.getId(), idResolveResult.getModuleVersionId(), idResolveResult.getState(), idResolveResult.getGraphState());
        if (idResolveResult.isRejected()) {
            component.reject();
        }
        return component;
    }

    boolean alreadyHaveResolutionForSelector(ResolvableSelectorState selector) {
        int size = this.results.size();
        ComponentIdResolveResult found = null;
        for (int i = 0; i < size; ++i) {
            Registration registration = this.results.get(i);
            ComponentIdResolveResult discovered = registration.result;
            if (!SelectorStateResolverResults.selectorAcceptsCandidate(selector, discovered, registration.selector.isFromLock())) continue;
            found = discovered;
            selector.markResolved();
            break;
        }
        if (found != null) {
            this.register(selector, found);
            return true;
        }
        return false;
    }

    boolean replaceExistingResolutionsWithBetterResult(ComponentIdResolveResult candidate, boolean isFromLock) {
        boolean replaces = false;
        int size = this.results.size();
        for (int i = 0; i < size; ++i) {
            Registration registration = this.results.get(i);
            ComponentIdResolveResult previous = registration.result;
            ResolvableSelectorState previousSelector = registration.selector;
            if (!SelectorStateResolverResults.emptyVersion(previous) && !SelectorStateResolverResults.sameVersion(previous, candidate) && (!SelectorStateResolverResults.selectorAcceptsCandidate(previousSelector, candidate, isFromLock) || !this.lowerVersion(previous, candidate))) continue;
            registration.result = candidate;
            replaces = true;
        }
        return replaces;
    }

    void register(ResolvableSelectorState selector, ComponentIdResolveResult resolveResult) {
        this.results.add(new Registration(selector, resolveResult));
    }

    private static boolean emptyVersion(ComponentIdResolveResult existing) {
        if (existing.getFailure() == null) {
            return existing.getModuleVersionId().getVersion().isEmpty();
        }
        return false;
    }

    private static boolean sameVersion(ComponentIdResolveResult existing, ComponentIdResolveResult resolveResult) {
        if (existing.getFailure() == null && resolveResult.getFailure() == null) {
            return existing.getId().equals(resolveResult.getId());
        }
        return false;
    }

    private boolean lowerVersion(ComponentIdResolveResult existing, ComponentIdResolveResult resolveResult) {
        if (existing.getFailure() == null && resolveResult.getFailure() == null) {
            Version existingVersion = this.versionParser.transform(existing.getModuleVersionId().getVersion());
            Version candidateVersion = this.versionParser.transform(resolveResult.getModuleVersionId().getVersion());
            int comparison = this.versionComparator.compare(candidateVersion, existingVersion);
            return comparison < 0;
        }
        return false;
    }

    private static boolean selectorAcceptsCandidate(ResolvableSelectorState dep, ComponentIdResolveResult candidate, boolean candidateIsFromLock) {
        if (SelectorStateResolverResults.hasFailure(candidate)) {
            return false;
        }
        ResolvedVersionConstraint versionConstraint = dep.getVersionConstraint();
        if (versionConstraint == null) {
            return dep.getSelector().matchesStrictly(candidate.getId());
        }
        VersionSelector versionSelector = versionConstraint.getRequiredSelector();
        if (versionSelector != null && (candidateIsFromLock || versionSelector.canShortCircuitWhenVersionAlreadyPreselected())) {
            if (candidateIsFromLock && versionSelector instanceof LatestVersionSelector) {
                return true;
            }
            String version = candidate.getModuleVersionId().getVersion();
            if (StringUtils.isEmpty((String)version)) {
                return false;
            }
            return versionSelector.accept(version);
        }
        return false;
    }

    private static boolean hasFailure(ComponentIdResolveResult candidate) {
        return candidate.getFailure() != null;
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    private static class Registration {
        private final ResolvableSelectorState selector;
        private ComponentIdResolveResult result;

        private Registration(ResolvableSelectorState selector, ComponentIdResolveResult result2) {
            this.selector = selector;
            this.result = result2;
        }

        public String toString() {
            return this.selector.toString() + " -> " + this.result.getModuleVersionId();
        }
    }
}

