/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BrokenResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedVariantSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.specs.Spec;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class VariantResolvingArtifactSet
implements ArtifactSet,
VariantSelector.Factory {
    private final VariantArtifactResolver variantResolver;
    private final ComponentGraphResolveState component;
    private final VariantGraphResolveState variant;
    private final ComponentIdentifier componentId;
    private final AttributesSchemaInternal schema;
    private final ImmutableAttributes overriddenAttributes;
    private final List<IvyArtifactName> artifacts;
    private final ExcludeSpec exclusions;
    private final Lazy<ImmutableSet<ResolvedVariant>> ownArtifacts = Lazy.locking().of(this::calculateOwnArtifacts);

    public VariantResolvingArtifactSet(VariantArtifactResolver variantResolver, ComponentGraphResolveState component, VariantGraphResolveState variant, DependencyGraphEdge dependency) {
        this.variantResolver = variantResolver;
        this.component = component;
        this.variant = variant;
        this.componentId = component.getId();
        this.schema = component.getMetadata().getAttributesSchema();
        this.overriddenAttributes = dependency.getAttributes();
        this.artifacts = dependency.getDependencyMetadata().getArtifacts();
        this.exclusions = dependency.getExclusions();
    }

    @Override
    public ResolvedArtifactSet select(Spec<? super ComponentIdentifier> componentFilter, VariantSelector selector, boolean selectFromAllVariants) {
        ResolvedVariantSet variants;
        if (!componentFilter.isSatisfiedBy(this.componentId)) {
            return ResolvedArtifactSet.EMPTY;
        }
        if (selectFromAllVariants && !this.artifacts.isEmpty()) {
            return ResolvedArtifactSet.EMPTY;
        }
        try {
            variants = this.getVariants(selectFromAllVariants);
        }
        catch (Exception e) {
            return new BrokenResolvedArtifactSet(e);
        }
        return selector.select(variants, this);
    }

    @Override
    public ResolvedArtifactSet asTransformed(ResolvedVariant sourceVariant, VariantDefinition variantDefinition, TransformUpstreamDependenciesResolverFactory dependenciesResolverFactory, TransformedVariantFactory transformedVariantFactory) {
        if (this.componentId instanceof ProjectComponentIdentifier) {
            return transformedVariantFactory.transformedProjectArtifacts(this.componentId, sourceVariant, variantDefinition, dependenciesResolverFactory);
        }
        return transformedVariantFactory.transformedExternalArtifacts(this.componentId, sourceVariant, variantDefinition, dependenciesResolverFactory);
    }

    public ResolvedVariantSet getVariants(boolean selectFromAllVariants) {
        ImmutableSet variants = !selectFromAllVariants ? (ImmutableSet)this.ownArtifacts.get() : this.getComponentVariants();
        return new DefaultResolvedVariantSet(this.componentId, this.schema, this.overriddenAttributes, (ImmutableSet<ResolvedVariant>)variants);
    }

    public ImmutableSet<ResolvedVariant> calculateOwnArtifacts() {
        VariantArtifactResolveState variantState = this.variant.prepareForArtifactResolution();
        if (this.artifacts.isEmpty()) {
            ComponentArtifactResolveMetadata componentMetadata = this.component.prepareForArtifactResolution().getResolveMetadata();
            ImmutableSet.Builder ownArtifacts = ImmutableSet.builder();
            this.visitResolvedArtifacts(componentMetadata, variantState, arg_0 -> ((ImmutableSet.Builder)ownArtifacts).add(arg_0), this.exclusions.mayExcludeArtifacts());
            return ownArtifacts.build();
        }
        return ImmutableSet.of((Object)variantState.resolveAdhocVariant(this.variantResolver, this.artifacts));
    }

    private ImmutableSet<ResolvedVariant> getComponentVariants() {
        ComponentArtifactResolveState componentState = this.component.prepareForArtifactResolution();
        List componentVariants = componentState.getVariantsForArtifactSelection().orElse(null);
        if (componentVariants == null) {
            return (ImmutableSet)this.ownArtifacts.get();
        }
        boolean applyExclusions = this.exclusions.mayExcludeArtifacts();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ComponentArtifactResolveMetadata componentMetadata = componentState.getResolveMetadata();
        for (VariantArtifactResolveState componentVariant : componentVariants) {
            this.visitResolvedArtifacts(componentMetadata, componentVariant, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0), applyExclusions);
        }
        return builder.build();
    }

    private void visitResolvedArtifacts(ComponentArtifactResolveMetadata component, VariantArtifactResolveState variant, Consumer<ResolvedVariant> visitor, boolean applyExclusions) {
        if (applyExclusions) {
            for (VariantResolveMetadata variantResolveMetadata : variant.getArtifactVariants()) {
                visitor.accept(this.variantResolver.resolveVariant(component, variantResolveMetadata, this.exclusions));
            }
        } else {
            for (VariantResolveMetadata variantResolveMetadata : variant.getArtifactVariants()) {
                visitor.accept(this.variantResolver.resolveVariant(component, variantResolveMetadata));
            }
        }
    }
}

