/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.transformer;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.EvaluatedConstTracker;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterChecker;
import org.jetbrains.kotlin.ir.interpreter.checker.IrInterpreterCheckerData;
import org.jetbrains.kotlin.ir.interpreter.transformer.IrConstTransformerKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u0081\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u0012\u001e\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u001a\u001a\u00020\u0016*\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0004J\u0014\u0010\u001e\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0016H\u0004J\u0014\u0010 \u001a\u00020\u001b*\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u0013*\u00020\u001b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0014\u0010%\u001a\u00020\u001b*\u00020\u001b2\u0006\u0010!\u001a\u00020\u001bH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer$Data;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "mode", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "checker", "Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;", "evaluatedConstTracker", "Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "onWarning", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Lorg/jetbrains/kotlin/ir/expressions/IrErrorExpression;", "", "onError", "suppressExceptions", "", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;Lorg/jetbrains/kotlin/ir/interpreter/checker/IrInterpreterChecker;Lorg/jetbrains/kotlin/constant/EvaluatedConstTracker;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function3;Z)V", "getInterpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "canBeInterpreted", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "configuration", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "interpret", "failAsError", "reportIfError", "original", "reportInlinedJavaConst", "result", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "warningIfError", "Data", "ir.interpreter"})
public abstract class IrConstTransformer
implements IrElementTransformer<Data> {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final EvaluationMode mode;
    @NotNull
    private final IrInterpreterChecker checker;
    @Nullable
    private final EvaluatedConstTracker evaluatedConstTracker;
    @Nullable
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onWarning;
    @NotNull
    private final Function3<IrFile, IrElement, IrErrorExpression, Unit> onError;
    private final boolean suppressExceptions;

    public IrConstTransformer(@NotNull IrInterpreter interpreter, @NotNull IrFile irFile, @NotNull EvaluationMode mode, @NotNull IrInterpreterChecker checker, @Nullable EvaluatedConstTracker evaluatedConstTracker, @Nullable InlineConstTracker inlineConstTracker, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onWarning, @NotNull Function3<? super IrFile, ? super IrElement, ? super IrErrorExpression, Unit> onError, boolean suppressExceptions) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        Intrinsics.checkNotNullParameter(onWarning, (String)"onWarning");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.interpreter = interpreter;
        this.irFile = irFile;
        this.mode = mode;
        this.checker = checker;
        this.evaluatedConstTracker = evaluatedConstTracker;
        this.inlineConstTracker = inlineConstTracker;
        this.onWarning = onWarning;
        this.onError = onError;
        this.suppressExceptions = suppressExceptions;
    }

    @NotNull
    protected final IrInterpreter getInterpreter() {
        return this.interpreter;
    }

    private final IrExpression warningIfError(IrExpression $this$warningIfError, IrExpression original) {
        if ($this$warningIfError instanceof IrErrorExpression) {
            this.onWarning.invoke((Object)this.irFile, (Object)original, (Object)$this$warningIfError);
            return original;
        }
        return $this$warningIfError;
    }

    private final IrExpression reportIfError(IrExpression $this$reportIfError, IrExpression original) {
        if ($this$reportIfError instanceof IrErrorExpression) {
            this.onError.invoke((Object)this.irFile, (Object)original, (Object)$this$reportIfError);
            return WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()] == 1 ? (IrExpression)IrConstImpl.Companion.constNull($this$reportIfError.getStartOffset(), $this$reportIfError.getEndOffset(), $this$reportIfError.getType()) : original;
        }
        return $this$reportIfError;
    }

    protected final boolean canBeInterpreted(@NotNull IrExpression $this$canBeInterpreted, @NotNull IrInterpreterConfiguration configuration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$canBeInterpreted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        try {
            bl = (Boolean)$this$canBeInterpreted.accept(this.checker, new IrInterpreterCheckerData(this.irFile, this.mode, this.interpreter.getIrBuiltIns(), configuration));
        }
        catch (Throwable e) {
            if (this.suppressExceptions) {
                return false;
            }
            throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default($this$canBeInterpreted, null, 1, null), e);
        }
        return bl;
    }

    public static /* synthetic */ boolean canBeInterpreted$default(IrConstTransformer irConstTransformer, IrExpression irExpression, IrInterpreterConfiguration irInterpreterConfiguration, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: canBeInterpreted");
        }
        if ((n & 1) != 0) {
            irInterpreterConfiguration = irConstTransformer.interpreter.getEnvironment$ir_interpreter().getConfiguration();
        }
        return irConstTransformer.canBeInterpreted(irExpression, irInterpreterConfiguration);
    }

    @NotNull
    protected final IrExpression interpret(@NotNull IrExpression $this$interpret, boolean failAsError) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$interpret, (String)"<this>");
        try {
            irExpression = this.interpreter.interpret($this$interpret, this.irFile);
        }
        catch (Throwable e) {
            if (this.suppressExceptions) {
                return $this$interpret;
            }
            throw new AssertionError("Error occurred while optimizing an expression:\n" + DumpIrTreeKt.dump$default($this$interpret, null, 1, null), e);
        }
        IrExpression result2 = irExpression;
        EvaluatedConstTracker evaluatedConstTracker = this.evaluatedConstTracker;
        if (evaluatedConstTracker != null) {
            ConstantValue<?> constantValue;
            int n = result2.getStartOffset();
            int n2 = result2.getEndOffset();
            String string = IrDeclarationsKt.getNameWithPackage(this.irFile);
            if (result2 instanceof IrErrorExpression) {
                constantValue = (ConstantValue<?>)ErrorValue.Companion.create(((IrErrorExpression)result2).getDescription());
            } else {
                Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
                constantValue = IrTreeBuildUtilsKt.toConstantValue((IrConst)result2);
            }
            evaluatedConstTracker.save(n, n2, string, constantValue);
        }
        if (result2 instanceof IrConst) {
            this.reportInlinedJavaConst($this$interpret, (IrConst)result2);
        }
        return failAsError ? this.reportIfError(result2, $this$interpret) : this.warningIfError(result2, $this$interpret);
    }

    private final void reportInlinedJavaConst(IrExpression $this$reportInlinedJavaConst, IrConst<?> result2) {
        IrVisitorsKt.acceptVoid($this$reportInlinedJavaConst, new IrElementVisitorVoid(this, result2){
            final /* synthetic */ IrConstTransformer this$0;
            final /* synthetic */ IrConst<?> $result;
            {
                this.this$0 = $receiver;
                this.$result = $result;
            }

            public void visitElement(@NotNull IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            private final void report(IrField field2) {
                block0: {
                    InlineConstTracker inlineConstTracker = IrConstTransformer.access$getInlineConstTracker$p(this.this$0);
                    if (inlineConstTracker == null) break block0;
                    IrConstTransformerKt.reportOnIr(inlineConstTracker, IrConstTransformer.access$getIrFile$p(this.this$0), field2, this.$result);
                }
            }

            public void visitGetField(@NotNull IrGetField expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                this.report((IrField)expression.getSymbol().getOwner());
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression);
            }

            public void visitCall(@NotNull IrCall expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                IrDeclarationBase irDeclarationBase = UtilsKt.getProperty(expression.getSymbol().getOwner());
                if (irDeclarationBase != null && (irDeclarationBase = irDeclarationBase.getBackingField()) != null) {
                    IrDeclarationBase backingField2 = irDeclarationBase;
                    boolean bl = false;
                    this.report((IrField)backingField2);
                }
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression);
            }

            public void visitElement(@NotNull IrElement element, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data);
            }

            public void visitGetField(@NotNull IrGetField expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression, data);
            }

            public void visitCall(@NotNull IrCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression, data);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
            }

            public void visitBlock(@NotNull IrBlock expression) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression);
            }

            public void visitBlock(@NotNull IrBlock expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression, data);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitBody(@NotNull IrBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression);
            }

            public void visitCallableReference(@NotNull IrCallableReference<?> expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression, data);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitClass(@NotNull IrClass declaration) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration);
            }

            public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data);
            }

            public void visitClassReference(@NotNull IrClassReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression);
            }

            public void visitClassReference(@NotNull IrClassReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression, data);
            }

            public void visitComposite(@NotNull IrComposite expression) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression);
            }

            public void visitComposite(@NotNull IrComposite expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression, data);
            }

            public void visitConst(@NotNull IrConst<?> expression) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression);
            }

            public void visitConst(@NotNull IrConst<?> expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression, data);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression);
            }

            public void visitConstantArray(@NotNull IrConstantArray expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantArray(this, expression, data);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression);
            }

            public void visitConstantObject(@NotNull IrConstantObject expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantObject(this, expression, data);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression);
            }

            public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive(this, expression, data);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression);
            }

            public void visitConstantValue(@NotNull IrConstantValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstantValue(this, expression, data);
            }

            public void visitConstructor(@NotNull IrConstructor declaration) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
            }

            public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression);
            }

            public void visitConstructorCall(@NotNull IrConstructorCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitConstructorCall(this, expression, data);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression, data);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
            }

            public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression, data);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression, data);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop2, data);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression);
            }

            public void visitDynamicExpression(@NotNull IrDynamicExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicExpression(this, expression, data);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression);
            }

            public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression(this, expression, data);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression);
            }

            public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression(this, expression, data);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression, data);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression, data);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression, data);
            }

            public void visitExpression(@NotNull IrExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression);
            }

            public void visitExpression(@NotNull IrExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression, data);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
            }

            public void visitField(@NotNull IrField declaration) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
            }

            public void visitField(@NotNull IrField declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression, data);
            }

            public void visitFile(@NotNull IrFile declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
            }

            public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data);
            }

            public void visitFunction(@NotNull IrFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration);
            }

            public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression, data);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression);
            }

            public void visitFunctionExpression(@NotNull IrFunctionExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionExpression(this, expression, data);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression, data);
            }

            public void visitGetClass(@NotNull IrGetClass expression) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression);
            }

            public void visitGetClass(@NotNull IrGetClass expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression, data);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression, data);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression, data);
            }

            public void visitGetValue(@NotNull IrGetValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression);
            }

            public void visitGetValue(@NotNull IrGetValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression, data);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression, data);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression, data);
            }

            public void visitLoop(@NotNull IrLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2);
            }

            public void visitLoop(@NotNull IrLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop2, data);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression, data);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data);
            }

            public void visitProperty(@NotNull IrProperty declaration) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
            }

            public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression, data);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression);
            }

            public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference(this, expression, data);
            }

            public void visitReturn(@NotNull IrReturn expression) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression);
            }

            public void visitReturn(@NotNull IrReturn expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression, data);
            }

            public void visitScript(@NotNull IrScript declaration) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration);
            }

            public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitScript(this, declaration, data);
            }

            public void visitSetField(@NotNull IrSetField expression) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression);
            }

            public void visitSetField(@NotNull IrSetField expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression, data);
            }

            public void visitSetValue(@NotNull IrSetValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression);
            }

            public void visitSetValue(@NotNull IrSetValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSetValue(this, expression, data);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression, data);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression, data);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression, data);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression, data);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitThrow(@NotNull IrThrow expression) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression);
            }

            public void visitThrow(@NotNull IrThrow expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression, data);
            }

            public void visitTry(@NotNull IrTry aTry) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression, data);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression, data);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data);
            }

            public void visitVararg(@NotNull IrVararg expression) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression);
            }

            public void visitVararg(@NotNull IrVararg expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression, data);
            }

            public void visitVariable(@NotNull IrVariable declaration) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
            }

            public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data);
            }

            public void visitWhen(@NotNull IrWhen expression) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression);
            }

            public void visitWhen(@NotNull IrWhen expression, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression, data);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop2, @Nullable Void data) {
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop2, data);
            }
        });
    }

    @Override
    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBlock(this, expression, data);
    }

    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
    }

    @Override
    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
    }

    @Override
    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCall(this, expression, data);
    }

    @Override
    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClass(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClassReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitComposite(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConst(this, expression, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression, data);
    }

    @Override
    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
    }

    @Override
    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
    }

    @Override
    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitField(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression, data);
    }

    @Override
    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetClass(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetField(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetValue(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLoop(this, loop2, data);
    }

    @Override
    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression, data);
    }

    @Override
    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data);
    }

    @Override
    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitReturn(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitScript(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetField(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetValue(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression, data);
    }

    @Override
    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
    }

    @Override
    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression, data);
    }

    @Override
    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
    }

    @Override
    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitThrow(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
    }

    @Override
    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVararg(this, expression, data);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data);
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhen(this, expression, data);
    }

    @Override
    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop2, data);
    }

    public static final /* synthetic */ InlineConstTracker access$getInlineConstTracker$p(IrConstTransformer $this) {
        return $this.inlineConstTracker;
    }

    public static final /* synthetic */ IrFile access$getIrFile$p(IrConstTransformer $this) {
        return $this.irFile;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/transformer/IrConstTransformer$Data;", "", "inAnnotation", "", "(Z)V", "getInAnnotation", "()Z", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "ir.interpreter"})
    public static final class Data {
        private final boolean inAnnotation;

        public Data(boolean inAnnotation) {
            this.inAnnotation = inAnnotation;
        }

        public /* synthetic */ Data(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getInAnnotation() {
            return this.inAnnotation;
        }

        public final boolean component1() {
            return this.inAnnotation;
        }

        @NotNull
        public final Data copy(boolean inAnnotation) {
            return new Data(inAnnotation);
        }

        public static /* synthetic */ Data copy$default(Data data, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = data.inAnnotation;
            }
            return data.copy(bl);
        }

        @NotNull
        public String toString() {
            return "Data(inAnnotation=" + this.inAnnotation + ')';
        }

        public int hashCode() {
            return Boolean.hashCode(this.inAnnotation);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            return this.inAnnotation == data.inAnnotation;
        }

        public Data() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EvaluationMode.values().length];
            try {
                nArray[EvaluationMode.ONLY_INTRINSIC_CONST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

