/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibDeclarationsChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.JsKlibExportingDeclaration;
import org.jetbrains.kotlin.ir.backend.js.checkers.declarations.JsKlibEsModuleExportsChecker;
import org.jetbrains.kotlin.ir.backend.js.checkers.declarations.JsKlibOtherModuleExportsChecker;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.library.SerializedIrFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JR\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u001e\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibCheckers;", "", "()V", "exportedDeclarationsCheckers", "", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibDeclarationsChecker;", "Lorg/jetbrains/kotlin/ir/backend/js/checkers/JsKlibExportingDeclaration;", "check", "", "cleanFiles", "Lorg/jetbrains/kotlin/library/SerializedIrFile;", "dirtyFiles", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "exportedNames", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "", "diagnosticReporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "ir.serialization.js"})
public final class JsKlibCheckers {
    @NotNull
    public static final JsKlibCheckers INSTANCE = new JsKlibCheckers();
    @NotNull
    private static final List<JsKlibDeclarationsChecker<JsKlibExportingDeclaration>> exportedDeclarationsCheckers;

    private JsKlibCheckers() {
    }

    public final void check(@NotNull List<SerializedIrFile> cleanFiles, @NotNull List<? extends IrFile> dirtyFiles, @NotNull Map<IrFile, ? extends Map<IrDeclarationWithName, String>> exportedNames, @NotNull DiagnosticReporter diagnosticReporter, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter(cleanFiles, (String)"cleanFiles");
        Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
        Intrinsics.checkNotNullParameter(exportedNames, (String)"exportedNames");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        KtDiagnosticReporterWithImplicitIrBasedContext reporter = new KtDiagnosticReporterWithImplicitIrBasedContext(diagnosticReporter, CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)configuration));
        List<JsKlibExportingDeclaration> exportedDeclarations2 = JsKlibExportingDeclaration.Companion.collectDeclarations(cleanFiles, dirtyFiles, exportedNames);
        for (JsKlibDeclarationsChecker<JsKlibExportingDeclaration> checker : exportedDeclarationsCheckers) {
            checker.check(exportedDeclarations2, reporter);
        }
    }

    static {
        Object[] objectArray = new JsKlibDeclarationsChecker[]{JsKlibEsModuleExportsChecker.INSTANCE, JsKlibOtherModuleExportsChecker.INSTANCE};
        exportedDeclarationsCheckers = CollectionsKt.listOf((Object[])objectArray);
    }
}

