/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.signature;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureComputer;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.overrides.IrFakeOverrideBuilderKt;
import org.jetbrains.kotlin.ir.symbols.IrFileSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001fH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureComputer;", "publicSignatureBuilder", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "table", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "(Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;)V", "startIndex", "", "(Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;I)V", "localIndex", "", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "scopeIndex", "composeContainerIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "compatibleMode", "", "composeFileLocalIdSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "composeSignatureForDeclaration", "computeSignature", "inFile", "", "file", "Lorg/jetbrains/kotlin/ir/symbols/IrFileSymbol;", "block", "Lkotlin/Function0;", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIdSignatureFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdSignatureFactory.kt\norg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n1#2:282\n*E\n"})
public final class IdSignatureFactory
implements IdSignatureComputer {
    @NotNull
    private final PublicIdSignatureComputer publicSignatureBuilder;
    @NotNull
    private final DeclarationTable table;
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    private long localIndex;
    private int scopeIndex;

    public IdSignatureFactory(@NotNull PublicIdSignatureComputer publicSignatureBuilder, @NotNull DeclarationTable table, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)publicSignatureBuilder, (String)"publicSignatureBuilder");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this.publicSignatureBuilder = publicSignatureBuilder;
        this.table = table;
        this.mangler = this.publicSignatureBuilder.getMangler();
        this.localIndex = startIndex;
        this.scopeIndex = startIndex;
    }

    public IdSignatureFactory(@NotNull PublicIdSignatureComputer publicSignatureBuilder, @NotNull DeclarationTable table) {
        Intrinsics.checkNotNullParameter((Object)publicSignatureBuilder, (String)"publicSignatureBuilder");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        this(publicSignatureBuilder, table, 0);
    }

    @Override
    @NotNull
    public IdSignature computeSignature(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.publicSignatureBuilder.computeSignature(declaration);
    }

    @NotNull
    public final IdSignature composeSignatureForDeclaration(@NotNull IrDeclaration declaration, boolean compatibleMode) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KotlinMangler.IrMangler $this$composeSignatureForDeclaration_u24lambda_u240 = this.mangler;
        boolean bl = false;
        return $this$composeSignatureForDeclaration_u24lambda_u240.isExported(declaration, compatibleMode) ? this.publicSignatureBuilder.composePublicIdSignature(declaration, compatibleMode) : this.composeFileLocalIdSignature(declaration, compatibleMode);
    }

    @Override
    public void inFile(@Nullable IrFileSymbol file, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.publicSignatureBuilder.inFile(file, block);
    }

    private final IdSignature composeContainerIdSignature(IrDeclarationParent container, boolean compatibleMode) {
        IdSignature idSignature;
        IrDeclarationParent irDeclarationParent = container;
        if (irDeclarationParent instanceof IrPackageFragment) {
            String string = ((IrPackageFragment)container).getPackageFqName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            idSignature = new IdSignature.CommonSignature(string, "", null, 0L, null);
        } else if (irDeclarationParent instanceof IrDeclaration) {
            idSignature = this.table.signatureByDeclaration((IrDeclaration)((Object)container), compatibleMode);
        } else {
            throw new IllegalStateException(("Unexpected container " + RenderIrElementKt.render$default(container, null, 1, null)).toString());
        }
        return idSignature;
    }

    @NotNull
    public final IdSignature composeFileLocalIdSignature(@NotNull IrDeclaration declaration, boolean compatibleMode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KotlinMangler.IrMangler $this$composeFileLocalIdSignature_u24lambda_u241 = this.mangler;
        boolean bl2 = false;
        boolean bl3 = bl = !$this$composeFileLocalIdSignature_u24lambda_u241.isExported(declaration, compatibleMode);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return this.table.privateDeclarationSignature(declaration, compatibleMode, (Function0<? extends IdSignature>)((Function0)new Function0<IdSignature>(declaration, this, compatibleMode){
            final /* synthetic */ IrDeclaration $declaration;
            final /* synthetic */ IdSignatureFactory this$0;
            final /* synthetic */ boolean $compatibleMode;
            {
                this.$declaration = $declaration;
                this.this$0 = $receiver;
                this.$compatibleMode = $compatibleMode;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IdSignature invoke() {
                IdSignature idSignature;
                block13: {
                    IrDeclaration irDeclaration;
                    block19: {
                        long l;
                        Object p;
                        Object object;
                        Object object2;
                        block21: {
                            IrDeclarationParent parent2;
                            block20: {
                                block16: {
                                    Object object3;
                                    block18: {
                                        block17: {
                                            block15: {
                                                block14: {
                                                    block12: {
                                                        irDeclaration = this.$declaration;
                                                        if (!(irDeclaration instanceof IrValueDeclaration)) break block12;
                                                        IdSignatureFactory idSignatureFactory = this.this$0;
                                                        int n = IdSignatureFactory.access$getScopeIndex$p(idSignatureFactory);
                                                        IdSignatureFactory.access$setScopeIndex$p(idSignatureFactory, n + 1);
                                                        idSignature = new IdSignature.ScopeLocalDeclaration(n, ((IrValueDeclaration)this.$declaration).getName().asString());
                                                        break block13;
                                                    }
                                                    if (!(irDeclaration instanceof IrAnonymousInitializer)) break block14;
                                                    IdSignatureFactory idSignatureFactory = this.this$0;
                                                    int n = IdSignatureFactory.access$getScopeIndex$p(idSignatureFactory);
                                                    IdSignatureFactory.access$setScopeIndex$p(idSignatureFactory, n + 1);
                                                    idSignature = new IdSignature.ScopeLocalDeclaration(n, "ANON INIT");
                                                    break block13;
                                                }
                                                if (!(irDeclaration instanceof IrLocalDelegatedProperty)) break block15;
                                                IdSignatureFactory idSignatureFactory = this.this$0;
                                                int n = IdSignatureFactory.access$getScopeIndex$p(idSignatureFactory);
                                                IdSignatureFactory.access$setScopeIndex$p(idSignatureFactory, n + 1);
                                                idSignature = new IdSignature.ScopeLocalDeclaration(n, ((IrLocalDelegatedProperty)this.$declaration).getName().asString());
                                                break block13;
                                            }
                                            if (!(irDeclaration instanceof IrField)) break block16;
                                            object3 = ((IrField)this.$declaration).getCorrespondingPropertySymbol();
                                            if (object3 == null) break block17;
                                            IrPropertySymbol irPropertySymbol = object3;
                                            IdSignatureFactory idSignatureFactory = this.this$0;
                                            boolean bl = this.$compatibleMode;
                                            IrPropertySymbol it = irPropertySymbol;
                                            boolean bl2 = false;
                                            IdSignature idSignature2 = idSignatureFactory.composeSignatureForDeclaration((IrDeclaration)it.getOwner(), bl);
                                            object3 = idSignature2;
                                            if (idSignature2 != null) break block18;
                                        }
                                        object3 = IdSignatureFactory.access$composeContainerIdSignature(this.this$0, this.$declaration.getParent(), this.$compatibleMode);
                                    }
                                    Object p2 = object3;
                                    IdSignatureFactory idSignatureFactory = this.this$0;
                                    IdSignatureFactory.access$setLocalIndex$p(idSignatureFactory, IdSignatureFactory.access$getLocalIndex$p(idSignatureFactory) + 1L);
                                    idSignature = new IdSignature.FileLocalSignature((IdSignature)p2, IdSignatureFactory.access$getLocalIndex$p(idSignatureFactory), null, 4, null);
                                    break block13;
                                }
                                if (!(irDeclaration instanceof IrSimpleFunction)) break block19;
                                parent2 = this.$declaration.getParent();
                                object2 = ((IrSimpleFunction)this.$declaration).getCorrespondingPropertySymbol();
                                if (object2 == null) break block20;
                                IrPropertySymbol irPropertySymbol = object2;
                                object = this.this$0;
                                boolean it = this.$compatibleMode;
                                IrPropertySymbol it2 = irPropertySymbol;
                                boolean bl = false;
                                IdSignature idSignature3 = ((IdSignatureFactory)object).composeSignatureForDeclaration((IrDeclaration)it2.getOwner(), it);
                                object2 = idSignature3;
                                if (idSignature3 != null) break block21;
                            }
                            object2 = IdSignatureFactory.access$composeContainerIdSignature(this.this$0, parent2, this.$compatibleMode);
                        }
                        Object object4 = p = object2;
                        if (IrFakeOverrideBuilderKt.isOverridableFunction((IrSimpleFunction)this.$declaration)) {
                            void $this$invoke_u24lambda_u242;
                            KotlinMangler.IrMangler irMangler = IdSignatureFactory.access$getMangler$p(this.this$0);
                            IrDeclaration irDeclaration2 = this.$declaration;
                            boolean bl = this.$compatibleMode;
                            object = irMangler;
                            Object object5 = object4;
                            boolean bl3 = false;
                            long l2 = $this$invoke_u24lambda_u242.signatureMangle(irDeclaration2, bl);
                            object4 = object5;
                            l = l2;
                        } else {
                            IdSignatureFactory idSignatureFactory = this.this$0;
                            IdSignatureFactory.access$setLocalIndex$p(idSignatureFactory, IdSignatureFactory.access$getLocalIndex$p(idSignatureFactory) + 1L);
                            l = IdSignatureFactory.access$getLocalIndex$p(idSignatureFactory);
                        }
                        String string = RenderIrElementKt.render$default(this.$declaration, null, 1, null);
                        long l3 = l;
                        Object object6 = object4;
                        idSignature = new IdSignature.FileLocalSignature((IdSignature)object6, l3, string);
                        break block13;
                    }
                    if (irDeclaration instanceof IrProperty) {
                        long l;
                        IrDeclarationParent parent3 = this.$declaration.getParent();
                        IdSignature idSignature4 = IdSignatureFactory.access$composeContainerIdSignature(this.this$0, parent3, this.$compatibleMode);
                        if (IrFakeOverrideBuilderKt.isOverridableProperty((IrProperty)this.$declaration)) {
                            void $this$invoke_u24lambda_u243;
                            KotlinMangler.IrMangler irMangler = IdSignatureFactory.access$getMangler$p(this.this$0);
                            IrDeclaration irDeclaration3 = this.$declaration;
                            boolean bl = this.$compatibleMode;
                            KotlinMangler.IrMangler irMangler2 = irMangler;
                            IdSignature idSignature5 = idSignature4;
                            boolean bl4 = false;
                            long l4 = $this$invoke_u24lambda_u243.signatureMangle(irDeclaration3, bl);
                            idSignature4 = idSignature5;
                            l = l4;
                        } else {
                            IdSignatureFactory idSignatureFactory = this.this$0;
                            IdSignatureFactory.access$setLocalIndex$p(idSignatureFactory, IdSignatureFactory.access$getLocalIndex$p(idSignatureFactory) + 1L);
                            l = IdSignatureFactory.access$getLocalIndex$p(idSignatureFactory);
                        }
                        String string = RenderIrElementKt.render$default(this.$declaration, null, 1, null);
                        long l5 = l;
                        IdSignature idSignature6 = idSignature4;
                        idSignature = new IdSignature.FileLocalSignature(idSignature6, l5, string);
                    } else {
                        IdSignature idSignature7 = IdSignatureFactory.access$composeContainerIdSignature(this.this$0, this.$declaration.getParent(), this.$compatibleMode);
                        IdSignatureFactory idSignatureFactory = this.this$0;
                        IdSignatureFactory.access$setLocalIndex$p(idSignatureFactory, IdSignatureFactory.access$getLocalIndex$p(idSignatureFactory) + 1L);
                        idSignature = new IdSignature.FileLocalSignature(idSignature7, IdSignatureFactory.access$getLocalIndex$p(idSignatureFactory), RenderIrElementKt.render$default(this.$declaration, null, 1, null));
                    }
                }
                return idSignature;
            }
        }));
    }

    public static final /* synthetic */ int access$getScopeIndex$p(IdSignatureFactory $this) {
        return $this.scopeIndex;
    }

    public static final /* synthetic */ void access$setScopeIndex$p(IdSignatureFactory $this, int n) {
        $this.scopeIndex = n;
    }

    public static final /* synthetic */ IdSignature access$composeContainerIdSignature(IdSignatureFactory $this, IrDeclarationParent container, boolean compatibleMode) {
        return $this.composeContainerIdSignature(container, compatibleMode);
    }

    public static final /* synthetic */ void access$setLocalIndex$p(IdSignatureFactory $this, long l) {
        $this.localIndex = l;
    }

    public static final /* synthetic */ long access$getLocalIndex$p(IdSignatureFactory $this) {
        return $this.localIndex;
    }

    public static final /* synthetic */ KotlinMangler.IrMangler access$getMangler$p(IdSignatureFactory $this) {
        return $this.mangler;
    }
}

