/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.IntEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIntProperty<T extends RadComponent>
extends Property<T, Integer> {
    private final int myDefaultValue;
    private final LabelPropertyRenderer<Integer> myRenderer;
    private final IntEditor myEditor;

    protected AbstractIntProperty(Property parent, @NotNull @NonNls String name, int defaultValue) {
        if (name == null) {
            AbstractIntProperty.$$$reportNull$$$0(0);
        }
        super(parent, name);
        this.myRenderer = new LabelPropertyRenderer();
        this.myDefaultValue = defaultValue;
        this.myEditor = new IntEditor(defaultValue);
    }

    @Override
    @NotNull
    public PropertyRenderer<Integer> getRenderer() {
        LabelPropertyRenderer<Integer> labelPropertyRenderer = this.myRenderer;
        if (labelPropertyRenderer == null) {
            AbstractIntProperty.$$$reportNull$$$0(1);
        }
        return labelPropertyRenderer;
    }

    @Override
    @Nullable
    public PropertyEditor<Integer> getEditor() {
        return this.myEditor;
    }

    @Override
    public boolean isModified(T component) {
        Integer intValue = (Integer)this.getValue(component);
        return intValue != null && intValue.intValue() != this.getDefaultValue(component);
    }

    @Override
    public void resetValue(T component) throws Exception {
        this.setValue(component, this.getDefaultValue(component));
    }

    protected int getDefaultValue(T component) {
        return this.myDefaultValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/propertyInspector/properties/AbstractIntProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/properties/AbstractIntProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

