/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Property<T extends RadComponent, V>
implements IProperty {
    public static final Property[] EMPTY_ARRAY = new Property[0];
    private static final Logger LOG = Logger.getInstance(Property.class);
    private final Property myParent;
    private final String myName;

    public Property(Property parent, @NotNull @NonNls String name) {
        if (name == null) {
            Property.$$$reportNull$$$0(0);
        }
        this.myParent = parent;
        this.myName = name;
    }

    @NotNull
    @NlsSafe
    public final String getName() {
        String string = this.myName;
        if (string == null) {
            Property.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Object getPropertyValue(IComponent component) {
        return this.getValue((RadComponent)component);
    }

    public abstract V getValue(T var1);

    protected abstract void setValueImpl(T var1, V var2) throws Exception;

    public final void setValue(T component, V value) throws Exception {
        this.setValueImpl(component, value);
        this.markTopmostModified(component, true);
        ((RadComponent)component).getDelegee().invalidate();
    }

    public final void setValueEx(T component, V value) {
        try {
            this.setValue(component, value);
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
        }
    }

    protected void markTopmostModified(T component, boolean modified) {
        Property topmostParent = this;
        while (topmostParent.getParent() != null) {
            topmostParent = topmostParent.getParent();
        }
        if (modified) {
            ((RadComponent)component).markPropertyAsModified(topmostParent);
        } else {
            ((RadComponent)component).removeModifiedProperty(topmostParent);
        }
    }

    @Nullable
    public final Property getParent() {
        return this.myParent;
    }

    public Property @NotNull [] getChildren(RadComponent component) {
        if (EMPTY_ARRAY == null) {
            Property.$$$reportNull$$$0(2);
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public abstract PropertyRenderer<V> getRenderer();

    @Nullable
    public abstract PropertyEditor<V> getEditor();

    public boolean appliesTo(T component) {
        return true;
    }

    public boolean isModified(T component) {
        return false;
    }

    public void resetValue(T component) throws Exception {
    }

    public boolean appliesToSelection(List<RadComponent> selection) {
        return true;
    }

    public boolean needRefreshPropertyList() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/propertyInspector/Property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/propertyInspector/Property";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

