/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.DragLayer;
import com.intellij.uiDesigner.designSurface.EventProcessor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class GroupSelectionProcessor
extends EventProcessor {
    private final GuiEditor myEditor;
    private final RadComponent myComponent;
    private Point myStartPoint;
    private final MyRectanglePainter myRectangePainter;

    public GroupSelectionProcessor(GuiEditor editor, RadComponent component) {
        this.myEditor = editor;
        this.myComponent = component;
        this.myRectangePainter = new MyRectanglePainter();
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 501) {
            this.myStartPoint = e.getPoint();
            this.myEditor.getDragLayer().add(this.myRectangePainter);
        } else if (e.getID() == 506) {
            Rectangle rectangle = this.getRectangle(e);
            this.myRectangePainter.setBounds(rectangle);
            this.myEditor.getDragLayer().repaint();
        } else if (e.getID() == 502) {
            RadComponent component;
            Rectangle rectangle = this.getRectangle(e);
            if (e.isShiftDown() && rectangle.width <= 3 && rectangle.height <= 3 && (component = FormEditingUtil.getRadComponentAt(this.myEditor.getRootContainer(), e.getX(), e.getY())) != null) {
                RadComponent anchor = this.myEditor.getSelectionAnchor();
                if (anchor == null || anchor.getParent() != component.getParent() || anchor.getParent() == null || !anchor.getParent().getLayoutManager().isGrid()) {
                    component.setSelected(!component.isSelected());
                } else {
                    GroupSelectionProcessor.selectComponentsInRange(component, anchor);
                    this.myEditor.setSelectionLead(component);
                }
            }
            this.markRectangle(this.myEditor.getRootContainer(), rectangle, e.getComponent());
            DragLayer dragLayer = this.myEditor.getDragLayer();
            dragLayer.remove(this.myRectangePainter);
            dragLayer.repaint();
            this.myStartPoint = null;
        }
    }

    private static void selectComponentsInRange(RadComponent component, RadComponent anchor) {
        GridConstraints c1 = component.getConstraints();
        GridConstraints c2 = anchor.getConstraints();
        int startRow = Math.min(c1.getRow(), c2.getRow());
        int startCol = Math.min(c1.getColumn(), c2.getColumn());
        int endRow = Math.max(c1.getRow() + c1.getRowSpan(), c2.getRow() + c2.getRowSpan());
        int endCol = Math.max(c1.getColumn() + c1.getColSpan(), c2.getColumn() + c2.getColSpan());
        for (int row = startRow; row < endRow; ++row) {
            for (int col = startCol; col < endCol; ++col) {
                RadComponent c = anchor.getParent().getComponentAtGrid(row, col);
                if (c == null) continue;
                c.setSelected(true);
            }
        }
    }

    @Override
    protected boolean cancelOperation() {
        DragLayer dragLayer = this.myEditor.getDragLayer();
        dragLayer.remove(this.myRectangePainter);
        dragLayer.repaint();
        return true;
    }

    private Rectangle getRectangle(MouseEvent e) {
        int x = Math.min(this.myStartPoint.x, e.getX());
        int y = Math.min(this.myStartPoint.y, e.getY());
        int width = Math.abs(this.myStartPoint.x - e.getX());
        int height = Math.abs(this.myStartPoint.y - e.getY());
        return new Rectangle(x, y, width, height);
    }

    private void markRectangle(RadComponent component, Rectangle rectangle, Component coordinateOriginComponent) {
        if (!(component instanceof RadRootContainer) && !component.equals(this.myComponent)) {
            Rectangle bounds = component.getBounds();
            Point point = SwingUtilities.convertPoint(component.getDelegee().getParent(), bounds.x, bounds.y, coordinateOriginComponent);
            bounds.setLocation(point);
            if (rectangle.intersects(bounds)) {
                component.setSelected(true);
                return;
            }
        }
        if (component instanceof RadContainer) {
            RadComponent[] components;
            RadContainer container = (RadContainer)component;
            for (RadComponent component1 : components = container.getComponents()) {
                this.markRectangle(component1, rectangle, coordinateOriginComponent);
            }
        }
    }

    private static final class MyRectanglePainter
    extends JComponent {
        private final AlphaComposite myComposite1 = AlphaComposite.getInstance(10, 0.3f);
        private final AlphaComposite myComposite2 = AlphaComposite.getInstance(10, 0.6f);
        private final Color myColor = new Color(47, 67, 96);

        MyRectanglePainter() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            super.paintComponent(g);
            Composite oldComposite = g2d.getComposite();
            Color oldColor = g2d.getColor();
            g2d.setColor(this.myColor);
            g2d.setComposite(this.myComposite1);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setComposite(this.myComposite2);
            g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g2d.setColor(oldColor);
            g2d.setComposite(oldComposite);
        }
    }
}

