/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DraggedComponentList
implements Transferable,
ComponentDragObject {
    private static final Logger LOG = Logger.getInstance(DraggedComponentList.class);
    private static DataFlavor ourDataFlavor;
    private final ArrayList<RadComponent> mySelection;
    private GridConstraints[] myOriginalConstraints;
    private Rectangle[] myOriginalBounds;
    private RadContainer[] myOriginalParents;
    private int myDragRelativeColumn = 0;
    private int myComponentUnderMouseColumn;
    private int myComponentUnderMouseRow;
    private int myDragDeltaX = 0;
    private int myDragDeltaY = 0;
    private boolean myHasDragDelta = false;

    private DraggedComponentList(Collection<? extends RadComponent> selection) {
        this.mySelection = new ArrayList<RadComponent>(selection);
        this.fillOriginalConstraints();
    }

    private DraggedComponentList(GuiEditor editor, Point pnt) {
        int componentUnderMouseIndex;
        this.mySelection = FormEditingUtil.getSelectedComponents(editor);
        this.mySelection.sort((o1, o2) -> {
            if (o1.getParent() == o2.getParent()) {
                int result = o1.getConstraints().getRow() - o2.getConstraints().getRow();
                if (result == 0) {
                    result = o1.getConstraints().getColumn() - o2.getConstraints().getColumn();
                }
                return result;
            }
            return 0;
        });
        RadComponent componentUnderMouse = null;
        int n = componentUnderMouseIndex = this.mySelection.size() == 0 ? -1 : 0;
        if (pnt != null) {
            for (int i = 0; i < this.mySelection.size(); ++i) {
                RadComponent c = this.mySelection.get(i);
                Point aPoint = SwingUtilities.convertPoint(editor.getRootContainer().getDelegee(), pnt, c.getParent().getDelegee());
                if (!c.getBounds().contains(aPoint)) continue;
                aPoint = SwingUtilities.convertPoint(editor.getRootContainer().getDelegee(), pnt, c.getDelegee());
                this.mySelection.set(i, c.getComponentToDrag(aPoint));
                componentUnderMouseIndex = i;
            }
        }
        this.fillOriginalConstraints();
        if (componentUnderMouseIndex >= 0) {
            componentUnderMouse = this.mySelection.get(componentUnderMouseIndex);
            this.myComponentUnderMouseColumn = this.myOriginalConstraints[componentUnderMouseIndex].getColumn();
            this.myComponentUnderMouseRow = this.myOriginalConstraints[componentUnderMouseIndex].getRow();
        }
        LOG.debug("myComponentUnderMouseColumn=" + this.myComponentUnderMouseColumn + ", myComponentUnderMouseRow=" + this.myComponentUnderMouseRow);
        if (this.mySelection.size() > 1 && componentUnderMouse != null) {
            for (GridConstraints constraints : this.myOriginalConstraints) {
                this.myDragRelativeColumn = Math.max(this.myDragRelativeColumn, componentUnderMouse.getConstraints().getColumn() - constraints.getColumn());
            }
        }
        for (RadComponent c : this.mySelection) {
            JComponent delegee = c.getDelegee();
            if (c != componentUnderMouse || pnt == null) continue;
            if (delegee.getX() > pnt.x && delegee.getX() + delegee.getWidth() < pnt.x) {
                this.myDragDeltaX = pnt.x - (delegee.getX() + delegee.getWidth() / 2);
            }
            if (delegee.getY() > pnt.y && delegee.getY() + delegee.getHeight() < pnt.y) {
                this.myDragDeltaY = pnt.y - (delegee.getY() + delegee.getHeight() / 2);
            }
            this.myHasDragDelta = true;
        }
    }

    private void fillOriginalConstraints() {
        this.myOriginalConstraints = new GridConstraints[this.mySelection.size()];
        this.myOriginalBounds = new Rectangle[this.mySelection.size()];
        this.myOriginalParents = new RadContainer[this.mySelection.size()];
        for (int i1 = 0; i1 < this.mySelection.size(); ++i1) {
            RadComponent component = this.mySelection.get(i1);
            this.myOriginalConstraints[i1] = component.getConstraints().store();
            this.myOriginalBounds[i1] = component.getBounds();
            this.myOriginalParents[i1] = component.getParent();
        }
    }

    public static DraggedComponentList pickupSelection(GuiEditor editor, @Nullable Point pnt) {
        return new DraggedComponentList(editor, pnt);
    }

    public static DraggedComponentList withComponents(RadComponent ... c) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, c);
        return new DraggedComponentList(list);
    }

    @Nullable
    public static DraggedComponentList fromTransferable(Transferable transferable) {
        if (transferable.isDataFlavorSupported(ourDataFlavor)) {
            Object data;
            try {
                data = transferable.getTransferData(ourDataFlavor);
            }
            catch (Exception e) {
                return null;
            }
            if (data instanceof DraggedComponentList) {
                return (DraggedComponentList)data;
            }
        }
        return null;
    }

    public int getDragDeltaX() {
        return this.myDragDeltaX;
    }

    public int getDragDeltaY() {
        return this.myDragDeltaY;
    }

    public ArrayList<RadComponent> getComponents() {
        return this.mySelection;
    }

    @Override
    public int getComponentCount() {
        return this.mySelection.size();
    }

    public RadContainer getOriginalParent(RadComponent c) {
        return this.myOriginalParents[this.mySelection.indexOf(c)];
    }

    public GridConstraints[] getOriginalConstraints() {
        GridConstraints[] result = new GridConstraints[this.myOriginalConstraints.length];
        for (int i = 0; i < this.myOriginalConstraints.length; ++i) {
            result[i] = this.myOriginalConstraints[i].store();
        }
        return result;
    }

    public Rectangle[] getOriginalBounds() {
        return this.myOriginalBounds;
    }

    public Rectangle getOriginalBounds(RadComponent c) {
        return this.myOriginalBounds[this.mySelection.indexOf(c)];
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{ourDataFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(ourDataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this;
    }

    @Override
    public boolean isHGrow() {
        for (GridConstraints c : this.myOriginalConstraints) {
            if ((c.getHSizePolicy() & 4) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVGrow() {
        for (GridConstraints c : this.myOriginalConstraints) {
            if ((c.getVSizePolicy() & 4) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRelativeRow(int componentIndex) {
        return this.myOriginalConstraints[componentIndex].getRow() - this.myComponentUnderMouseRow;
    }

    @Override
    public int getRelativeCol(int componentIndex) {
        return this.myOriginalConstraints[componentIndex].getColumn() - this.myComponentUnderMouseColumn;
    }

    @Override
    public int getRowSpan(int componentIndex) {
        return this.myOriginalConstraints[componentIndex].getRowSpan();
    }

    @Override
    public int getColSpan(int componentIndex) {
        return this.myOriginalConstraints[componentIndex].getColSpan();
    }

    @Override
    public Point getDelta(int componentIndex) {
        return null;
    }

    @Override
    @NotNull
    public Dimension getInitialSize(RadContainer targetContainer) {
        if (this.myOriginalBounds.length == 1) {
            Dimension dimension = this.myOriginalBounds[0].getSize();
            if (dimension == null) {
                DraggedComponentList.$$$reportNull$$$0(0);
            }
            return dimension;
        }
        return new Dimension(-1, -1);
    }

    public RadContainer[] getOriginalParents() {
        return this.myOriginalParents;
    }

    public boolean hasDragDelta() {
        return this.myHasDragDelta;
    }

    static {
        try {
            ourDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/designSurface/DraggedComponentList", "getInitialSize"));
    }
}

