/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.palette.impl;

import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.LightToolWindow;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.palette.impl.PaletteWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.uiDesigner.AbstractToolWindowManager;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaletteToolWindowManager
extends AbstractToolWindowManager {
    private PaletteWindow myToolWindowPanel;

    public PaletteToolWindowManager(Project project) {
        super(project);
    }

    public static PaletteWindow getInstance(GuiEditor designer) {
        PaletteToolWindowManager manager = PaletteToolWindowManager.getInstance(designer.getProject());
        if (manager.isEditorMode()) {
            return (PaletteWindow)manager.getContent(designer);
        }
        if (manager.myToolWindowPanel == null) {
            manager.initToolWindow();
        }
        return manager.myToolWindowPanel;
    }

    public static PaletteToolWindowManager getInstance(Project project) {
        return (PaletteToolWindowManager)((Object)project.getService(PaletteToolWindowManager.class));
    }

    protected void initToolWindow() {
        this.myToolWindowPanel = new PaletteWindow(this.myProject);
        Disposer.register((Disposable)this, () -> this.myToolWindowPanel.dispose());
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(IdeBundle.message((String)"toolwindow.palette", (Object[])new Object[0]), false, this.getAnchor(), (Disposable)this, true);
        this.myToolWindow.setIcon(AllIcons.Toolwindows.ToolWindowPalette);
        this.initGearActions();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)this.myToolWindowPanel, null, false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent((JComponent)this.myToolWindowPanel);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindow.setAvailable(false);
    }

    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myToolWindowPanel.refreshPaletteIfChanged((GuiEditor)designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false);
        } else {
            this.myToolWindow.setAvailable(true);
            this.myToolWindow.show(null);
        }
    }

    protected ToolWindowAnchor getAnchor() {
        return ToolWindowAnchor.RIGHT;
    }

    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            PaletteToolWindowManager.$$$reportNull$$$0(0);
        }
        PaletteWindow palettePanel = new PaletteWindow(this.myProject);
        palettePanel.refreshPaletteIfChanged((GuiEditor)designer);
        return this.createContent(designer, palettePanel, IdeBundle.message((String)"toolwindow.palette", (Object[])new Object[0]), AllIcons.Toolwindows.ToolWindowPalette, palettePanel, palettePanel, 180, null);
    }

    @NotNull
    public String getComponentName() {
        return "PaletteManager";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/ide/palette/impl/PaletteToolWindowManager", "createContent"));
    }
}

