/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.linux;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.linux.AllVariablesAreOK;
import com.intellij.profiler.linux.KernelVariable;
import com.intellij.profiler.linux.KernelVariablesValidatorKt;
import com.intellij.profiler.linux.OK;
import com.intellij.profiler.linux.ValidationResult;
import com.intellij.profiler.linux.VariableValidationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Jr\u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2(\u0010\u000e\u001a$\u0012\u001a\u0012\u0018\u0018\u00010\u000b\u00a2\u0006\u0002\b\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00040\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002Jp\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000b2\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2(\u0010\u001a\u001a$\u0012\u001a\u0012\u0018\u0018\u00010\u000b\u00a2\u0006\u0002\b\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00040\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017Jh\u0010\u001b\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2(\u0010\u001a\u001a$\u0012\u001a\u0012\u0018\u0018\u00010\u000b\u00a2\u0006\u0002\b\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00040\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0014J(\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0014J \u0010#\u001a\u00020\u000b2\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\tH\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/linux/KernelVariablesFixer;", "", "()V", "changeVars", "", "validationResult", "", "Lcom/intellij/profiler/linux/KernelVariable;", "Lcom/intellij/profiler/linux/VariableValidationResult;", "Lcom/intellij/profiler/linux/AllVariablesValidationResult;", "scriptPath", "", "onSuccess", "Lkotlin/Function0;", "onErrorCallback", "Lkotlin/Function1;", "Lorg/jetbrains/annotations/Nls;", "Lkotlin/ParameterName;", "name", "message", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "project", "Lcom/intellij/openapi/project/Project;", "changeVarsPermanently", "sysctlPath", "onError", "changeVarsUntilRestart", "executeScript", "Lcom/intellij/execution/process/ProcessOutput;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "timeout", "", "getChangeVarsPermanentlyScript", "getChangeVarsUntilRestartScriptPath", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nKernelVariablesFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelVariablesFixer.kt\ncom/intellij/profiler/linux/KernelVariablesFixer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n494#2,7:82\n494#2,7:93\n1549#3:89\n1620#3,3:90\n1549#3:100\n1620#3,3:101\n*S KotlinDebug\n*F\n+ 1 KernelVariablesFixer.kt\ncom/intellij/profiler/linux/KernelVariablesFixer\n*L\n31#1:82,7\n37#1:93,7\n31#1:89\n31#1:90,3\n37#1:100\n37#1:101,3\n*E\n"})
public class KernelVariablesFixer {
    public final void changeVarsUntilRestart(@NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super String, Unit> onError, @Nullable Logger logger, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.changeVars(validationResult, this.getChangeVarsUntilRestartScriptPath(validationResult), onSuccess, onError, logger, project);
    }

    public final void changeVarsPermanently(@NotNull String sysctlPath, @NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super String, Unit> onError, @Nullable Logger logger, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sysctlPath, (String)"sysctlPath");
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.changeVars(validationResult, this.getChangeVarsPermanentlyScript(sysctlPath, validationResult), onSuccess, onError, logger, project);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String getChangeVarsUntilRestartScriptPath(@NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Map<KernelVariable, ? extends VariableValidationResult> $this$filterValues$iv = validationResult;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry<KernelVariable, ? extends VariableValidationResult> entry$iv : $this$filterValues$iv.entrySet()) {
            VariableValidationResult it = entry$iv.getValue();
            boolean bl = false;
            if (!(!(it instanceof OK))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$map$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KernelVariable kernelVariable = (KernelVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("echo " + it.getRequiredValue() + " > " + it.getPath());
        }
        List echoLines = (List)destination$iv$iv;
        String script = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"#!/bin/sh"), (Iterable)echoLines), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        String string = ExecUtil.createTempExecutableScript((String)"change_kernel_variables_until_restart", (String)".sh", (String)script).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String getChangeVarsPermanentlyScript(@NotNull String sysctlPath, @NotNull Map<KernelVariable, ? extends VariableValidationResult> validationResult) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sysctlPath, (String)"sysctlPath");
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Map<KernelVariable, ? extends VariableValidationResult> $this$filterValues$iv = validationResult;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry<KernelVariable, ? extends VariableValidationResult> entry$iv : $this$filterValues$iv.entrySet()) {
            VariableValidationResult it = entry$iv.getValue();
            boolean bl = false;
            if (!(!(it instanceof OK))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$map$iv = ((Map)result$iv).keySet();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KernelVariable kernelVariable = (KernelVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("echo kernel." + it.getName() + "=" + it.getRequiredValue() + " >> " + sysctlPath);
        }
        List sysctlLines = (List)destination$iv$iv;
        Object[] objectArray = new String[]{"#!/bin/sh", "set -e"};
        String script = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)sysctlLines), (Object)"sysctl --system"), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        String string = ExecUtil.createTempExecutableScript((String)"change_kernel_variables_permanently", (String)".sh", (String)script).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @NotNull
    protected ProcessOutput executeScript(@NotNull String scriptPath, @NotNull ProgressIndicator indicator, int timeout) {
        Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String[] stringArray = new String[]{scriptPath};
        GeneralCommandLine generalCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)new GeneralCommandLine(stringArray), (String)CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.prompt.password", new Object[0])).withRedirectErrorStream(true);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withRedirectErrorStream(...)");
        GeneralCommandLine cmd = generalCommandLine;
        ProcessOutput processOutput = new CapturingProcessHandler(cmd).runProcessWithProgressIndicator(indicator, timeout, true);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcessWithProgressIndicator(...)");
        return processOutput;
    }

    private final void changeVars(Map<KernelVariable, ? extends VariableValidationResult> validationResult, String scriptPath, Function0<Unit> onSuccess, Function1<? super String, Unit> onErrorCallback, Logger logger, Project project) {
        String errorMsg = CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.error", new Object[0]);
        Logger logger2 = logger;
        if (logger2 != null) {
            logger2.info("Kernel variables changer script: " + scriptPath);
        }
        String string = CommonProfilerBundleKt.profilerMessage("profiler.kernel.vars.writing", new Object[0]);
        new Task.Modal(project, this, scriptPath, onErrorCallback, logger, errorMsg, validationResult, onSuccess, string){
            final /* synthetic */ KernelVariablesFixer this$0;
            final /* synthetic */ String $scriptPath;
            final /* synthetic */ Function1<String, Unit> $onErrorCallback;
            final /* synthetic */ Logger $logger;
            final /* synthetic */ String $errorMsg;
            final /* synthetic */ Map<KernelVariable, VariableValidationResult> $validationResult;
            final /* synthetic */ Function0<Unit> $onSuccess;
            {
                this.this$0 = $receiver;
                this.$scriptPath = $scriptPath;
                this.$onErrorCallback = $onErrorCallback;
                this.$logger = $logger;
                this.$errorMsg = $errorMsg;
                this.$validationResult = $validationResult;
                this.$onSuccess = $onSuccess;
                super($project, $super_call_param$1, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProcessOutput result2 = this.this$0.executeScript(this.$scriptPath, indicator, 10000);
                if (result2.getExitCode() != 0) {
                    if (result2.isCancelled()) {
                        this.$onErrorCallback.invoke(null);
                        return;
                    }
                    Logger logger = this.$logger;
                    if (logger != null) {
                        logger.info("can't change variables: exit code:" + result2.getExitCode() + ", output:" + result2.getStdout());
                    }
                    this.$onErrorCallback.invoke((Object)this.$errorMsg);
                    return;
                }
                ValidationResult postExecutionValidationResult = KernelVariablesValidatorKt.checkKernelVariables(CollectionsKt.toList((Iterable)this.$validationResult.keySet()));
                if (!(postExecutionValidationResult instanceof AllVariablesAreOK)) {
                    Logger logger = this.$logger;
                    if (logger != null) {
                        logger.info("Not all variables are valid after success write: " + postExecutionValidationResult);
                    }
                    this.$onErrorCallback.invoke((Object)this.$errorMsg);
                    return;
                }
                this.$onSuccess.invoke();
            }
        }.queue();
    }
}

