/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.linux;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.linux.CantReadVariable;
import com.intellij.profiler.linux.CantValidateVariable;
import com.intellij.profiler.linux.InvalidValue;
import com.intellij.profiler.linux.NoSuchVariable;
import com.intellij.profiler.linux.OK;
import com.intellij.profiler.linux.VariableValidationResult;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fH\u0014J\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/linux/KernelVariable;", "", "name", "", "requiredValue", "validator", "Lkotlin/Function1;", "", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getName", "()Ljava/lang/String;", "getRequiredValue", "getPath", "isFileExist", "readLines", "", "validate", "Lcom/intellij/profiler/linux/VariableValidationResult;", "intellij.profiler.common"})
public class KernelVariable {
    @NotNull
    private final String name;
    @NotNull
    private final String requiredValue;
    @NotNull
    private final Function1<String, Boolean> validator;

    public KernelVariable(@NotNull String name, @NotNull String requiredValue, @NotNull Function1<? super String, Boolean> validator) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)requiredValue, (String)"requiredValue");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        this.name = name;
        this.requiredValue = requiredValue;
        this.validator = validator;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getRequiredValue() {
        return this.requiredValue;
    }

    @NotNull
    public final VariableValidationResult validate() {
        if (!this.isFileExist()) {
            return NoSuchVariable.INSTANCE;
        }
        try {
            VariableValidationResult variableValidationResult;
            List<String> content = this.readLines();
            if (content.isEmpty()) {
                return NoSuchVariable.INSTANCE;
            }
            String value = (String)CollectionsKt.first(content);
            try {
                variableValidationResult = (Boolean)this.validator.invoke((Object)value) != false ? (VariableValidationResult)new OK(value) : (VariableValidationResult)new InvalidValue(value);
            }
            catch (Exception e) {
                variableValidationResult = new CantValidateVariable(e);
            }
            return variableValidationResult;
        }
        catch (Exception e) {
            return new CantReadVariable(e);
        }
    }

    @NotNull
    public String getPath() {
        String[] stringArray = new String[]{"/proc/sys/kernel", this.name};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        return string;
    }

    protected boolean isFileExist() {
        return new File(this.getPath()).exists();
    }

    @NotNull
    protected List<String> readLines() {
        return FilesKt.readLines$default((File)new File(this.getPath()), null, (int)1, null);
    }
}

