/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XTestValueNode;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class XDebuggerAssertions
extends XDebuggerTestUtil {
    XDebuggerAssertions() {
    }

    public static <B extends XBreakpoint<?>> void assertBreakpointValidity(@NotNull Project project2, @NotNull VirtualFile file2, int line, boolean validity, boolean pending, String errorMessage, @NotNull Class<? extends XBreakpointType<B, ?>> breakpointType) {
        if (project2 == null) {
            XDebuggerAssertions.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            XDebuggerAssertions.$$$reportNull$$$0(1);
        }
        if (breakpointType == null) {
            XDebuggerAssertions.$$$reportNull$$$0(2);
        }
        XLineBreakpointType type = (XLineBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(breakpointType);
        XBreakpointManager manager = XDebuggerManager.getInstance((Project)project2).getBreakpointManager();
        XLineBreakpointImpl breakpoint = (XLineBreakpointImpl)ReadAction.compute(() -> (XLineBreakpointImpl)manager.findBreakpointAtLine(type, file2, line));
        Assert.assertNotNull((Object)breakpoint);
        Icon expectedIcon = validity ? (pending ? AllIcons.Debugger.Db_invalid_breakpoint : XDebuggerUtilImpl.getVerifiedIcon((XBreakpoint)breakpoint)) : AllIcons.Debugger.Db_invalid_breakpoint;
        Assert.assertEquals((Object)expectedIcon, (Object)breakpoint.getIcon());
        Assert.assertEquals((Object)errorMessage, (Object)breakpoint.getErrorMessage());
    }

    public static void assertPosition(XSourcePosition pos, @NotNull VirtualFile file2, int line) throws IOException {
        if (file2 == null) {
            XDebuggerAssertions.$$$reportNull$$$0(3);
        }
        Assert.assertNotNull((String)"No current position", (Object)pos);
        Assert.assertEquals((Object)new File(file2.getPath()).getCanonicalPath(), (Object)new File(pos.getFile().getPath()).getCanonicalPath());
        if (line != -1) {
            Assert.assertEquals((long)line, (long)pos.getLine());
        }
    }

    public static void assertCurrentPosition(@NotNull XDebugSession session, @NotNull VirtualFile file2, int line) throws IOException {
        if (session == null) {
            XDebuggerAssertions.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            XDebuggerAssertions.$$$reportNull$$$0(5);
        }
        XDebuggerAssertions.assertPosition(session.getCurrentPosition(), file2, line);
    }

    public static void assertVariable(@NotNull Collection<? extends XValue> vars, @Nullable String name, @Nullable String type, @Nullable String value) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(6);
        }
        XDebuggerAssertions.assertVariable(vars, name, type, value, null, null);
    }

    public static void assertVariable(@NotNull Collection<? extends XValue> vars, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean hasChildren) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(7);
        }
        XDebuggerAssertions.assertVariable(vars, name, type, value, hasChildren, null);
    }

    public static void assertVariable(@NotNull Collection<? extends XValue> vars, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean hasChildren, @Nullable Icon icon) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(8);
        }
        XDebuggerAssertions.assertVariable(XDebuggerAssertions.findVar(vars, name), name, type, value, hasChildren, icon);
    }

    public static void assertVariable(@NotNull Pair<XValue, String> varAndErrorMessage, @Nullable String name, @Nullable String type) {
        if (varAndErrorMessage == null) {
            XDebuggerAssertions.$$$reportNull$$$0(9);
        }
        XDebuggerAssertions.assertVariable(varAndErrorMessage, name, type, null);
    }

    public static void assertVariable(@NotNull Pair<XValue, String> varAndErrorMessage, @Nullable String name, @Nullable String type, @Nullable String value) {
        if (varAndErrorMessage == null) {
            XDebuggerAssertions.$$$reportNull$$$0(10);
        }
        XDebuggerAssertions.assertVariable(varAndErrorMessage, name, type, value, null);
    }

    public static void assertVariable(@NotNull Pair<XValue, String> varAndErrorMessage, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean hasChildren) {
        if (varAndErrorMessage == null) {
            XDebuggerAssertions.$$$reportNull$$$0(11);
        }
        XDebuggerAssertions.assertVariable(varAndErrorMessage, name, type, value, hasChildren, null);
    }

    public static void assertVariable(@NotNull Pair<XValue, String> varAndErrorMessage, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean hasChildren, @Nullable Icon icon) {
        if (varAndErrorMessage == null) {
            XDebuggerAssertions.$$$reportNull$$$0(12);
        }
        Assert.assertNull((Object)varAndErrorMessage.second);
        XDebuggerAssertions.assertVariable((XValue)varAndErrorMessage.first, name, type, value, hasChildren, icon);
    }

    public static void assertVariable(@NotNull XValue var, @Nullable String name) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(13);
        }
        XDebuggerAssertions.assertVariable(var, name, null);
    }

    public static void assertVariable(@NotNull XValue var, @Nullable String name, @Nullable String type) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(14);
        }
        XDebuggerAssertions.assertVariable(var, name, type, null);
    }

    public static void assertVariable(@NotNull XValue var, @Nullable String name, @Nullable String type, @Nullable String value) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(15);
        }
        XDebuggerAssertions.assertVariable(var, name, type, value, null);
    }

    public static void assertVariable(@NotNull XValue var, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean hasChildren) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(16);
        }
        XDebuggerAssertions.assertVariable(var, name, type, value, hasChildren, null);
    }

    public static void assertVariable(@NotNull XValue var, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean hasChildren, @Nullable Icon icon) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(17);
        }
        XTestValueNode node2 = XDebuggerAssertions.computePresentation(var);
        XDebuggerAssertions.assertVariable(node2, name, type, value, hasChildren, icon);
    }

    public static void assertVariable(@NotNull XTestValueNode node2, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean hasChildren) {
        if (node2 == null) {
            XDebuggerAssertions.$$$reportNull$$$0(18);
        }
        XDebuggerAssertions.assertVariable(node2, name, type, value, hasChildren, null);
    }

    public static void assertVariable(@NotNull XTestValueNode node2, @Nullable String name, @Nullable String type, @Nullable String value, @Nullable Boolean hasChildren, @Nullable Icon icon) {
        if (node2 == null) {
            XDebuggerAssertions.$$$reportNull$$$0(19);
        }
        String message = node2.toString();
        if (name != null) {
            Assert.assertEquals((String)message, (Object)name, (Object)node2.myName);
        }
        if (type != null) {
            Assert.assertEquals((String)message, (Object)type, (Object)node2.myType);
        }
        if (value != null) {
            Assert.assertEquals((String)message, (Object)value, (Object)node2.myValue);
        }
        if (hasChildren != null) {
            Assert.assertEquals((String)message, (Object)hasChildren, (Object)node2.myHasChildren);
        }
        if (icon != null) {
            Assert.assertEquals((String)message, (Object)icon, (Object)node2.myIcon);
        }
    }

    public static void assertVariableValue(@NotNull XValue var, @Nullable String name, @Nullable String value) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(20);
        }
        XDebuggerAssertions.assertVariable(var, name, null, value, null, null);
    }

    public static void assertVariableValue(@NotNull Collection<? extends XValue> vars, @Nullable String name, @Nullable String value) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(21);
        }
        XDebuggerAssertions.assertVariableValue(XDebuggerAssertions.findVar(vars, name), name, value);
    }

    public static void assertVariableValueMatches(@NotNull Collection<? extends XValue> vars, @Nullable String name, @Nullable @RegExp String valuePattern) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(22);
        }
        XDebuggerAssertions.assertVariableValueMatches(XDebuggerAssertions.findVar(vars, name), name, valuePattern);
    }

    public static void assertVariableValueMatches(@NotNull Collection<? extends XValue> vars, @Nullable String name, @Nullable String type, @Nullable @RegExp String valuePattern) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(23);
        }
        XDebuggerAssertions.assertVariableValueMatches(XDebuggerAssertions.findVar(vars, name), name, type, valuePattern);
    }

    public static void assertVariableValueMatches(@NotNull Collection<? extends XValue> vars, @Nullable String name, @Nullable String type, @Nullable @RegExp String valuePattern, @Nullable Boolean hasChildren) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(24);
        }
        XDebuggerAssertions.assertVariableValueMatches(XDebuggerAssertions.findVar(vars, name), name, type, valuePattern, hasChildren);
    }

    public static void assertVariableValueMatches(@NotNull Collection<? extends XValue> vars, @Nullable String name, @Nullable String type, @Nullable @RegExp String valuePattern, @Nullable Boolean hasChildren, @Nullable Icon icon) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(25);
        }
        XDebuggerAssertions.assertVariableValueMatches(XDebuggerAssertions.findVar(vars, name), name, type, valuePattern, hasChildren, icon);
    }

    public static void assertVariableValueMatches(@NotNull XValue var, @Nullable String name, @Nullable @RegExp String valuePattern) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(26);
        }
        XDebuggerAssertions.assertVariableValueMatches(var, name, null, valuePattern);
    }

    public static void assertVariableValueMatches(@NotNull XValue var, @Nullable String name, @Nullable String type, @Nullable @RegExp String valuePattern) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(27);
        }
        XDebuggerAssertions.assertVariableValueMatches(var, name, type, valuePattern, null);
    }

    public static void assertVariableValueMatches(@NotNull XValue var, @Nullable String name, @Nullable String type, @Nullable @RegExp String valuePattern, @Nullable Boolean hasChildren) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(28);
        }
        XDebuggerAssertions.assertVariableValueMatches(var, name, type, valuePattern, hasChildren, null);
    }

    public static void assertVariableValueMatches(@NotNull XValue var, @Nullable String name, @Nullable String type, @Nullable @RegExp String valuePattern, @Nullable Boolean hasChildren, @Nullable Icon icon) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(29);
        }
        XTestValueNode node2 = XDebuggerAssertions.computePresentation(var);
        XDebuggerAssertions.assertVariable(node2, name, type, null, hasChildren, icon);
        if (valuePattern != null) {
            Assert.assertTrue((String)("Expected value: " + valuePattern + " Actual value: " + node2.myValue), (boolean)node2.myValue.matches(valuePattern));
        }
    }

    public static void assertVariableTypeMatches(@NotNull Collection<? extends XValue> vars, @Nullable String name, @Nullable @RegExp String typePattern) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(30);
        }
        XDebuggerAssertions.assertVariableTypeMatches(XDebuggerAssertions.findVar(vars, name), name, typePattern);
    }

    public static void assertVariableTypeMatches(@NotNull XValue var, @Nullable String name, @Nullable @RegExp String typePattern) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(31);
        }
        XDebuggerAssertions.assertVariableTypeMatches(var, name, typePattern, null);
    }

    public static void assertVariableTypeMatches(@NotNull XValue var, @Nullable String name, @Nullable @RegExp String typePattern, @Nullable String value) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(32);
        }
        XDebuggerAssertions.assertVariableTypeMatches(var, name, typePattern, value, null);
    }

    public static void assertVariableTypeMatches(@NotNull XValue var, @Nullable String name, @Nullable @RegExp String typePattern, @Nullable String value, @Nullable Boolean hasChildren) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(33);
        }
        XDebuggerAssertions.assertVariableTypeMatches(var, name, typePattern, value, hasChildren, null);
    }

    public static void assertVariableTypeMatches(@NotNull XValue var, @Nullable String name, @Nullable @RegExp String typePattern, @Nullable String value, @Nullable Boolean hasChildren, @Nullable Icon icon) {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(34);
        }
        XTestValueNode node2 = XDebuggerAssertions.computePresentation(var);
        XDebuggerAssertions.assertVariable(node2, name, null, value, hasChildren, icon);
        if (typePattern != null) {
            Assert.assertTrue((String)("Expected type: " + typePattern + " Actual type: " + node2.myType), (node2.myType != null && node2.myType.matches(typePattern) ? 1 : 0) != 0);
        }
    }

    public static void assertVariableFullValue(@NotNull XValue var, @Nullable String value) throws Exception {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(35);
        }
        XTestValueNode node2 = XDebuggerAssertions.computePresentation(var);
        if (value == null) {
            Assert.assertNull((String)"full value evaluator should be null", (Object)node2.myFullValueEvaluator);
        } else {
            String actualValue = XDebuggerAssertions.computeFullValue(node2);
            Assert.assertEquals((Object)value, (Object)actualValue);
        }
    }

    public static void assertVariableFullValueMatches(@NotNull XValue var, @RegExp @Nullable String valueRegexp) throws Exception {
        if (var == null) {
            XDebuggerAssertions.$$$reportNull$$$0(36);
        }
        XTestValueNode node2 = XDebuggerAssertions.computePresentation(var);
        if (valueRegexp == null) {
            Assert.assertNull((String)"full value evaluator should be null", (Object)node2.myFullValueEvaluator);
        } else {
            String value = XDebuggerAssertions.computeFullValue(node2);
            Assert.assertTrue((String)(value + " is not matched by " + valueRegexp), (boolean)value.matches(valueRegexp));
        }
    }

    private static String computeFullValue(@NotNull XTestValueNode node2) throws Exception {
        if (node2 == null) {
            XDebuggerAssertions.$$$reportNull$$$0(37);
        }
        Assert.assertNotNull((String)"full value evaluator should be not null", (Object)node2.myFullValueEvaluator);
        final CompletableFuture result2 = new CompletableFuture();
        node2.myFullValueEvaluator.startEvaluation(new XFullValueEvaluator.XFullValueEvaluationCallback(){

            public void evaluated(@NotNull String fullValue) {
                if (fullValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                result2.complete(fullValue);
            }

            public void evaluated(@NotNull String fullValue, @Nullable Font font) {
                if (fullValue == null) {
                    1.$$$reportNull$$$0(1);
                }
                result2.complete(fullValue);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(2);
                }
                result2.complete(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fullValue";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xdebugger/XDebuggerAssertions$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (String)result2.get(25000L, TimeUnit.MILLISECONDS);
    }

    public static void assertVariableFullValue(@NotNull Collection<? extends XValue> vars, @Nullable String name, @Nullable String value) throws Exception {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(38);
        }
        XDebuggerAssertions.assertVariableFullValue(XDebuggerAssertions.findVar(vars, name), value);
    }

    public static void assertVariables(@NotNull List<? extends XValue> vars, String ... names) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(39);
        }
        ArrayList<String> actualNames = new ArrayList<String>();
        for (XValue xValue : vars) {
            actualNames.add(XDebuggerAssertions.computePresentation((XValue)xValue).myName);
        }
        Collections.sort(actualNames);
        List expectedNames = ContainerUtil.sorted(Arrays.asList(names));
        UsefulTestCase.assertOrderedEquals(actualNames, expectedNames);
    }

    public static void assertVariablesContain(@NotNull List<? extends XValue> vars, String ... names) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(40);
        }
        ArrayList<String> expectedNames = new ArrayList<String>(Arrays.asList(names));
        ArrayList<String> actualNames = new ArrayList<String>();
        for (XValue xValue : vars) {
            actualNames.add(XDebuggerAssertions.computePresentation((XValue)xValue).myName);
        }
        expectedNames.removeAll(actualNames);
        Assert.assertTrue((String)("Missing variables:" + StringUtil.join(expectedNames, (String)", ") + "\nAll Variables: " + StringUtil.join(actualNames, (String)", ")), (boolean)expectedNames.isEmpty());
    }

    public static void assertVariablesDontContain(@NotNull List<? extends XValue> vars, String ... notExpected) {
        if (vars == null) {
            XDebuggerAssertions.$$$reportNull$$$0(41);
        }
        ArrayList<String> actualNames = new ArrayList<String>();
        for (XValue xValue : vars) {
            actualNames.add(XDebuggerAssertions.computePresentation((XValue)xValue).myName);
        }
        String allVariablesNames = StringUtil.join(actualNames, (String)", ");
        actualNames.retainAll(List.of(notExpected));
        Assert.assertTrue((String)("Present variables: " + StringUtil.join(actualNames, (String)", ") + "\nAll Variables: " + allVariablesNames), (boolean)actualNames.isEmpty());
    }

    public static void assertSourcePosition(@NotNull XValue value, @NotNull VirtualFile file2, int offset) {
        if (value == null) {
            XDebuggerAssertions.$$$reportNull$$$0(42);
        }
        if (file2 == null) {
            XDebuggerAssertions.$$$reportNull$$$0(43);
        }
        XDebuggerTestUtil.XTestNavigatable n = new XDebuggerTestUtil.XTestNavigatable();
        ApplicationManager.getApplication().invokeAndWait(() -> value.computeSourcePosition((XNavigatable)n));
        Assert.assertNotNull((Object)n.getPosition());
        Assert.assertEquals((Object)file2, (Object)n.getPosition().getFile());
        Assert.assertEquals((long)offset, (long)n.getPosition().getOffset());
    }

    public static void assertSourcePosition(@NotNull XStackFrame frame, @NotNull VirtualFile file2, int line) {
        if (frame == null) {
            XDebuggerAssertions.$$$reportNull$$$0(44);
        }
        if (file2 == null) {
            XDebuggerAssertions.$$$reportNull$$$0(45);
        }
        XSourcePosition position = frame.getSourcePosition();
        Assert.assertNotNull((Object)position);
        Assert.assertEquals((Object)file2, (Object)position.getFile());
        Assert.assertEquals((long)line, (long)position.getLine());
    }

    public static String assertVariableExpression(@NotNull XValue desc, String expectedExpression) {
        if (desc == null) {
            XDebuggerAssertions.$$$reportNull$$$0(46);
        }
        String expression = desc.getEvaluationExpression();
        Assert.assertEquals((Object)expectedExpression, (Object)expression);
        return expression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varAndErrorMessage";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 18: 
            case 19: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/XDebuggerAssertions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "assertBreakpointValidity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "assertPosition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "assertCurrentPosition";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "assertVariable";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "assertVariableValue";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "assertVariableValueMatches";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "assertVariableTypeMatches";
                break;
            }
            case 35: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "assertVariableFullValue";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "assertVariableFullValueMatches";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "computeFullValue";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "assertVariables";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "assertVariablesContain";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "assertVariablesDontContain";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "assertSourcePosition";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "assertVariableExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

