/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.builders.JavaModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.MavenDependencyUtil;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.testFramework.fixtures.impl.ModuleFixtureBuilderImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaModuleFixtureBuilderImpl<T extends ModuleFixture>
extends ModuleFixtureBuilderImpl<T>
implements JavaModuleFixtureBuilder<T> {
    private final List<Lib> myLibraries;
    private final List<JavaModuleFixtureBuilder.MavenLib> myMavenLibraries;
    private String myJdk;
    private JavaModuleFixtureBuilder.MockJdkLevel myMockJdkLevel;
    private LanguageLevel myLanguageLevel;

    public JavaModuleFixtureBuilderImpl(@NotNull TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        if (fixtureBuilder == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(0);
        }
        super(StdModuleTypes.JAVA, fixtureBuilder);
        this.myLibraries = new ArrayList<Lib>();
        this.myMavenLibraries = new ArrayList<JavaModuleFixtureBuilder.MavenLib>();
        this.myMockJdkLevel = JavaModuleFixtureBuilder.MockJdkLevel.jdk14;
    }

    public JavaModuleFixtureBuilderImpl(ModuleType moduleType, TestFixtureBuilder<? extends IdeaProjectTestFixture> fixtureBuilder) {
        super(moduleType, fixtureBuilder);
        this.myLibraries = new ArrayList<Lib>();
        this.myMavenLibraries = new ArrayList<JavaModuleFixtureBuilder.MavenLib>();
        this.myMockJdkLevel = JavaModuleFixtureBuilder.MockJdkLevel.jdk14;
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder setLanguageLevel(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(1);
        }
        this.myLanguageLevel = languageLevel;
        JavaModuleFixtureBuilderImpl javaModuleFixtureBuilderImpl = this;
        if (javaModuleFixtureBuilderImpl == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(2);
        }
        return javaModuleFixtureBuilderImpl;
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder addLibrary(String libraryName, String ... classPath) {
        if (classPath == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(3);
        }
        for (String path : classPath) {
            if (new File(path).exists()) continue;
            System.out.println(path + " does not exist");
        }
        Map<OrderRootType, String[]> map = Collections.singletonMap(OrderRootType.CLASSES, classPath);
        this.myLibraries.add(new Lib(libraryName, map));
        JavaModuleFixtureBuilderImpl javaModuleFixtureBuilderImpl = this;
        if (javaModuleFixtureBuilderImpl == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(4);
        }
        return javaModuleFixtureBuilderImpl;
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder addLibrary(@NonNls String libraryName, @NotNull Map<OrderRootType, String[]> roots) {
        if (roots == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(5);
        }
        this.myLibraries.add(new Lib(libraryName, roots));
        JavaModuleFixtureBuilderImpl javaModuleFixtureBuilderImpl = this;
        if (javaModuleFixtureBuilderImpl == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(6);
        }
        return javaModuleFixtureBuilderImpl;
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder addMavenLibrary(@NotNull JavaModuleFixtureBuilder.MavenLib lib) {
        if (lib == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(7);
        }
        this.myMavenLibraries.add(lib);
        JavaModuleFixtureBuilderImpl javaModuleFixtureBuilderImpl = this;
        if (javaModuleFixtureBuilderImpl == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(8);
        }
        return javaModuleFixtureBuilderImpl;
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder addLibraryJars(String libraryName, @NotNull String basePath, String ... jars) {
        if (basePath == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(9);
        }
        if (jars == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(10);
        }
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        String[] classPath = ArrayUtil.newStringArray((int)jars.length);
        for (int i2 = 0; i2 < jars.length; ++i2) {
            classPath[i2] = (String)basePath + jars[i2];
        }
        JavaModuleFixtureBuilder javaModuleFixtureBuilder = this.addLibrary(libraryName, classPath);
        if (javaModuleFixtureBuilder == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(11);
        }
        return javaModuleFixtureBuilder;
    }

    @Override
    @NotNull
    public JavaModuleFixtureBuilder addJdk(@NotNull String jdkPath) {
        if (jdkPath == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(12);
        }
        this.myJdk = jdkPath;
        JavaModuleFixtureBuilderImpl javaModuleFixtureBuilderImpl = this;
        if (javaModuleFixtureBuilderImpl == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(13);
        }
        return javaModuleFixtureBuilderImpl;
    }

    @Override
    public void setMockJdkLevel(@NotNull JavaModuleFixtureBuilder.MockJdkLevel level) {
        if (level == null) {
            JavaModuleFixtureBuilderImpl.$$$reportNull$$$0(14);
        }
        this.myMockJdkLevel = level;
    }

    @Override
    protected void initModule(Module module2) {
        super.initModule(module2);
        ModuleRootModificationUtil.updateModel((Module)module2, model2 -> {
            Sdk jdk;
            LibraryTable libraryTable = model2.getModuleLibraryTable();
            for (Lib lib : this.myLibraries) {
                Library library = libraryTable.createLibrary(lib.getName());
                Library.ModifiableModel libraryModel = library.getModifiableModel();
                boolean success = false;
                try {
                    for (OrderRootType rootType : OrderRootType.getAllTypes()) {
                        for (String root : lib.getRoots(rootType)) {
                            VirtualFile jar;
                            VirtualFile vRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                            if (vRoot != null && OrderRootType.CLASSES.equals((Object)rootType) && !vRoot.isDirectory() && (jar = JarFileSystem.getInstance().refreshAndFindFileByPath(root + "!/")) != null) {
                                vRoot = jar;
                            }
                            if (vRoot == null) continue;
                            libraryModel.addRoot(vRoot, rootType);
                        }
                    }
                    success = true;
                }
                finally {
                    if (!success) {
                        Disposer.dispose((Disposable)libraryModel);
                    }
                }
                libraryModel.commit();
            }
            for (JavaModuleFixtureBuilder.MavenLib mavenLib : this.myMavenLibraries) {
                MavenDependencyUtil.addFromMaven(model2, mavenLib.getCoordinates(), mavenLib.isIncludeTransitiveDependencies(), mavenLib.getDependencyScope());
            }
            if (this.myJdk != null) {
                jdk = IdeaTestUtil.createMockJdkFromLegacyPath(this.myJdk);
                if (jdk == null) {
                    VfsRootAccess.allowRootAccess((Disposable)module2, (String[])new String[]{this.myJdk});
                    jdk = JavaSdk.getInstance().createJdk(module2.getName() + "_jdk", this.myJdk, false);
                    ((ProjectJdkImpl)jdk).setVersionString(StringUtil.notNullize((String)IdeaTestUtil.getMockJdkVersion(this.myJdk), (String)"java 1.5"));
                }
            } else {
                jdk = IdeaTestUtil.getMockJdk17();
            }
            JavaModuleFixtureBuilderImpl.registerJdk(jdk, module2.getProject());
            model2.setSdk(jdk);
            if (this.myLanguageLevel != null) {
                ((LanguageLevelModuleExtension)model2.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(this.myLanguageLevel);
            } else if (this.myMockJdkLevel == JavaModuleFixtureBuilder.MockJdkLevel.jdk15) {
                ((LanguageLevelModuleExtension)model2.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(LanguageLevel.JDK_1_5);
            }
        });
        for (OrderEntry entry : ModuleRootManager.getInstance((Module)module2).getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            Library library = ((LibraryOrderEntry)entry).getLibrary();
            this.libraryCreated(library, module2);
        }
    }

    private static void registerJdk(Sdk jdk, Project project2) {
        Sdk byName;
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        while ((byName = jdkTable.findJdk(jdk.getName())) != null) {
            jdkTable.removeJdk(byName);
        }
        WriteAction.runAndWait(() -> jdkTable.addJdk(jdk, (Disposable)project2));
    }

    @Override
    protected void setupRootModel(ModifiableRootModel rootModel) {
        if (this.myOutputPath != null) {
            File pathFile = new File(this.myOutputPath);
            if (!pathFile.mkdirs()) assert (pathFile.exists()) : "unable to create: " + this.myOutputPath;
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myOutputPath);
            assert (virtualFile != null) : "cannot find output path: " + this.myOutputPath;
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).setCompilerOutputPath(virtualFile);
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).inheritCompilerOutputPath(false);
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(false);
        }
        if (this.myTestOutputPath != null) {
            assert (new File(this.myTestOutputPath).mkdirs()) : this.myTestOutputPath;
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myTestOutputPath);
            assert (virtualFile != null) : "cannot find test output path: " + this.myTestOutputPath;
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).setCompilerOutputPathForTests(virtualFile);
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).inheritCompilerOutputPath(false);
            ((CompilerModuleExtension)rootModel.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(false);
        }
    }

    protected void libraryCreated(Library library, Module module2) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixtureBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/JavaModuleFixtureBuilderImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jars";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/JavaModuleFixtureBuilderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setLanguageLevel";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addLibrary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addMavenLibrary";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addLibraryJars";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addJdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setLanguageLevel";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addMavenLibrary";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryJars";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addJdk";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setMockJdkLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 11, 13 -> new IllegalStateException(string);
        };
    }

    private static class Lib {
        private final String myName;
        private final Map<OrderRootType, String[]> myRoots;

        Lib(String name, Map<OrderRootType, String[]> roots) {
            this.myName = name;
            this.myRoots = roots;
        }

        public String getName() {
            return this.myName;
        }

        public String[] getRoots(OrderRootType rootType) {
            String[] roots = this.myRoots.get(rootType);
            return roots != null ? roots : ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
    }
}

