/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.values;

import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.members.MockField;
import com.intellij.debugger.mockJDI.members.MockMethod;
import com.intellij.debugger.mockJDI.types.MockClassType;
import com.intellij.debugger.mockJDI.values.MockArrayReference;
import com.intellij.debugger.mockJDI.values.MockClassLoaderReference;
import com.intellij.debugger.mockJDI.values.MockStringReference;
import com.intellij.debugger.mockJDI.values.MockThreadReference;
import com.intellij.debugger.mockJDI.values.MockValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

public class MockObjectReference
extends MockValue
implements ObjectReference {
    private final Object myObject;

    protected MockObjectReference(MockVirtualMachine virtualMachine, Object object) {
        super(virtualMachine);
        this.myObject = object;
    }

    @Override
    public ReferenceType referenceType() {
        return this.myVirtualMachine.createReferenceType(this.myObject.getClass());
    }

    @Override
    public Type type() {
        return this.referenceType();
    }

    @Override
    public Value getValue(com.sun.jdi.Field field) {
        try {
            Field refField = ((MockField)field).getField();
            refField.setAccessible(true);
            Object value = refField.get(this.myObject);
            return value == null ? null : MockValue.createValue(value, refField.getType(), this.myVirtualMachine);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<com.sun.jdi.Field, Value> getValues(List<? extends com.sun.jdi.Field> list) {
        throw new UnsupportedOperationException("Not implemented: \"getValues\" in " + this.getClass().getName());
    }

    @Override
    public void setValue(com.sun.jdi.Field field, Value value) {
        throw new UnsupportedOperationException("Not implemented: \"setValue\" in " + this.getClass().getName());
    }

    @Override
    public Value invokeMethod(ThreadReference threadReference, Method method, List<? extends Value> list, int i2) {
        Object[] argsArray = MockClassType.values2Objects(list);
        try {
            java.lang.reflect.Method refMethod = ((MockMethod)method).getMethod();
            refMethod.setAccessible(true);
            return MockValue.createValue(refMethod.invoke(this.myObject, argsArray), refMethod.getReturnType(), this.myVirtualMachine);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void disableCollection() {
    }

    @Override
    public void enableCollection() {
    }

    @Override
    public boolean isCollected() {
        return false;
    }

    @Override
    public long uniqueID() {
        throw new UnsupportedOperationException("Not implemented: \"uniqueID\" in " + this.getClass().getName());
    }

    @Override
    public List<ThreadReference> waitingThreads() {
        throw new UnsupportedOperationException("Not implemented: \"waitingThreads\" in " + this.getClass().getName());
    }

    @Override
    public ThreadReference owningThread() {
        throw new UnsupportedOperationException("Not implemented: \"owningThread\" in " + this.getClass().getName());
    }

    @Override
    public int entryCount() {
        throw new UnsupportedOperationException("Not implemented: \"entryCount\" in " + this.getClass().getName());
    }

    @Override
    public List<ObjectReference> referringObjects(long l) {
        throw new UnsupportedOperationException("Not implemented: \"referringObjects\" in " + this.getClass().getName());
    }

    @Override
    public Object getValue() {
        return this.myObject;
    }

    public static MockObjectReference createObjectReference(Object o, Class<?> type, MockVirtualMachine virtualMachine) {
        if (o instanceof String || type != null && String.class.isAssignableFrom(type)) {
            return new MockStringReference(virtualMachine, (String)o);
        }
        if (o instanceof Thread || type != null && Thread.class.isAssignableFrom(type)) {
            return new MockThreadReference(virtualMachine, (Thread)o);
        }
        if (o instanceof ClassLoader || type != null && ClassLoader.class.isAssignableFrom(type)) {
            return new MockClassLoaderReference(virtualMachine, (ClassLoader)o);
        }
        if (o instanceof Object[] || type != null && type.isArray()) {
            return new MockArrayReference(virtualMachine, o, type == null ? o.getClass() : type);
        }
        return new MockObjectReference(virtualMachine, o);
    }
}

