/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.values;

import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.types.MockType;
import com.intellij.debugger.mockJDI.values.MockPrimitiveValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Type;

public class MockDoubleValue
extends MockPrimitiveValue
implements DoubleValue {
    private final double myValue;

    public MockDoubleValue(MockVirtualMachine virtualMachine, double value) {
        super(virtualMachine);
        this.myValue = value;
    }

    @Override
    public Object getValue() {
        return this.value();
    }

    @Override
    public double doubleValue() {
        return this.myValue;
    }

    @Override
    public Type type() {
        return MockType.createType(this.myVirtualMachine, Double.TYPE);
    }

    @Override
    public double value() {
        return this.myValue;
    }

    @Override
    public int compareTo(DoubleValue o) {
        return Double.compare(this.value(), o.value());
    }
}

