/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.TestClassesFilter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class GroupBasedTestClassFilter
extends TestClassesFilter {
    public static final String ALL_EXCLUDE_DEFINED = "ALL_EXCLUDE_DEFINED";
    private final Set<String> myGroupNames;
    private final boolean myMatchUnlisted;
    private final List<Group> myGroups;

    public GroupBasedTestClassFilter(MultiMap<String, String> filters, List<String> groupNames) {
        this.myGroupNames = new HashSet<String>(groupNames);
        this.myMatchUnlisted = this.myGroupNames.isEmpty() || this.myGroupNames.contains(ALL_EXCLUDE_DEFINED);
        this.myGroups = new ArrayList<Group>(filters.size());
        for (String groupName : filters.keySet()) {
            Collection groupFilters = filters.get((Object)groupName);
            List<Pattern> includePatterns = groupFilters.stream().filter(s -> !s.startsWith("-")).map(TestClassesFilter::compilePattern).collect(Collectors.toList());
            List<Pattern> excludedPatterns = groupFilters.stream().filter(s -> s.startsWith("-")).map(s -> TestClassesFilter.compilePattern(s.substring(1))).collect(Collectors.toList());
            this.myGroups.add(new Group(groupName, includePatterns, excludedPatterns));
        }
    }

    public List<Group> getGroups() {
        return this.myGroups;
    }

    public Set<String> getGroupNames() {
        return this.myGroupNames;
    }

    @NotNull
    public static TestClassesFilter createOn(@NotNull Reader reader, @NotNull List<String> testGroupNames) throws IOException {
        if (reader == null) {
            GroupBasedTestClassFilter.$$$reportNull$$$0(0);
        }
        if (testGroupNames == null) {
            GroupBasedTestClassFilter.$$$reportNull$$$0(1);
        }
        MultiMap groups = MultiMap.createLinked();
        GroupBasedTestClassFilter.readGroups(reader, (MultiMap<String, String>)groups);
        return new GroupBasedTestClassFilter((MultiMap<String, String>)groups, testGroupNames);
    }

    public static void readGroups(@NotNull Reader reader, @NotNull MultiMap<String, String> groupNameToPatternsMap) throws IOException {
        String line;
        if (reader == null) {
            GroupBasedTestClassFilter.$$$reportNull$$$0(2);
        }
        if (groupNameToPatternsMap == null) {
            GroupBasedTestClassFilter.$$$reportNull$$$0(3);
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        String currentGroupName = "";
        while ((line = bufferedReader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                currentGroupName = line.substring(1, line.length() - 1);
                continue;
            }
            groupNameToPatternsMap.putValue((Object)currentGroupName, (Object)line);
        }
    }

    @Override
    public boolean matches(String className, String moduleName) {
        return this.myGroups.stream().filter(g -> this.myGroupNames.contains(g.name)).anyMatch(g -> g.matches(className)) || this.myMatchUnlisted && !ContainerUtil.exists(this.myGroups, g -> g.matches(className));
    }

    public static boolean containsAllExcludeDefinedGroup(Set<String> groupNames) {
        return groupNames.isEmpty() || groupNames.contains(ALL_EXCLUDE_DEFINED);
    }

    public String toString() {
        return "GroupBasedTestClassFilter{names=" + this.myGroupNames + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testGroupNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNameToPatternsMap";
                break;
            }
        }
        objectArray2[1] = "com/intellij/GroupBasedTestClassFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createOn";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readGroups";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Group {
        public final String name;
        private final List<Pattern> included;
        private final List<Pattern> excluded;

        private Group(String name, List<Pattern> included, List<Pattern> excluded) {
            this.name = name;
            this.excluded = excluded;
            this.included = included;
        }

        public boolean matches(String className) {
            return !TestClassesFilter.matchesAnyPattern(this.excluded, className) && TestClassesFilter.matchesAnyPattern(this.included, className);
        }
    }
}

