/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher.confined;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.ForkDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.JUnitLauncherTask;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.ListenerDefinition;

public abstract class TestDefinition {
    protected String ifProperty;
    protected String unlessProperty;
    protected Boolean haltOnFailure;
    protected String failureProperty;
    protected String outputDir;
    protected String includeEngines;
    protected String excludeEngines;
    protected ForkDefinition forkDefinition;
    protected List<ListenerDefinition> listeners = new ArrayList<ListenerDefinition>();

    String getIfProperty() {
        return this.ifProperty;
    }

    public void setIf(String ifProperty) {
        this.ifProperty = ifProperty;
    }

    String getUnlessProperty() {
        return this.unlessProperty;
    }

    public void setUnless(String unlessProperty) {
        this.unlessProperty = unlessProperty;
    }

    public boolean isHaltOnFailure() {
        return this.haltOnFailure != null && this.haltOnFailure != false;
    }

    Boolean getHaltOnFailure() {
        return this.haltOnFailure;
    }

    public void setHaltOnFailure(boolean haltonfailure) {
        this.haltOnFailure = haltonfailure;
    }

    public String getFailureProperty() {
        return this.failureProperty;
    }

    public void setFailureProperty(String failureProperty) {
        this.failureProperty = failureProperty;
    }

    public void addConfiguredListener(ListenerDefinition listener) {
        this.listeners.add(listener);
    }

    public List<ListenerDefinition> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void setOutputDir(String dir) {
        this.outputDir = dir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public ForkDefinition createFork() {
        if (this.forkDefinition != null) {
            throw new BuildException("Test definition cannot have more than one fork elements");
        }
        this.forkDefinition = new ForkDefinition();
        return this.forkDefinition;
    }

    ForkDefinition getForkDefinition() {
        return this.forkDefinition;
    }

    protected boolean shouldRun(Project project) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(project);
        return propertyHelper.testIfCondition(this.ifProperty) && propertyHelper.testUnlessCondition(this.unlessProperty);
    }

    public String[] getIncludeEngines() {
        return this.includeEngines == null ? new String[]{} : TestDefinition.split(this.includeEngines, ",");
    }

    public void setIncludeEngines(String includeEngines) {
        this.includeEngines = includeEngines;
    }

    public String[] getExcludeEngines() {
        return this.excludeEngines == null ? new String[]{} : TestDefinition.split(this.excludeEngines, ",");
    }

    public void setExcludeEngines(String excludeEngines) {
        this.excludeEngines = excludeEngines;
    }

    private static String[] split(String value, String delimiter) {
        if (value == null) {
            return new String[0];
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (String part : value.split(delimiter)) {
            if (part.trim().isEmpty()) continue;
            parts.add(part);
        }
        return parts.toArray(new String[0]);
    }

    protected abstract void toForkedRepresentation(JUnitLauncherTask var1, XMLStreamWriter var2) throws XMLStreamException;
}

