/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher.confined;

import java.io.File;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.launch.AntMain;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.LoaderUtils;

final class JUnitLauncherClassPathUtil {
    private static final String RESOURCE_IN_PLATFORM_ENGINE = "org/junit/platform/engine/TestEngine.class";
    private static final String RESOURCE_IN_PLATFORM_LAUNCHER = "org/junit/platform/launcher/core/LauncherFactory.class";
    private static final String RESOURCE_IN_PLATFORM_COMMON = "org/junit/platform/commons/annotation/Testable.class";
    private static final String RESOURCE_NAME_LAUNCHER_SUPPORT = "org/apache/tools/ant/taskdefs/optional/junitlauncher/LauncherSupport.class";

    JUnitLauncherClassPathUtil() {
    }

    static void addAntRuntimeResourceLocations(Path path, ClassLoader classLoader) {
        JUnitLauncherClassPathUtil.addResourceLocationToPath(path, classLoader, JUnitLauncherClassPathUtil.toResourceName(AntMain.class));
        JUnitLauncherClassPathUtil.addResourceLocationToPath(path, classLoader, JUnitLauncherClassPathUtil.toResourceName(Task.class));
        JUnitLauncherClassPathUtil.addResourceLocationToPath(path, classLoader, RESOURCE_NAME_LAUNCHER_SUPPORT);
    }

    static void addLauncherSupportResourceLocation(Path path, ClassLoader classLoader) {
        JUnitLauncherClassPathUtil.addResourceLocationToPath(path, classLoader, RESOURCE_NAME_LAUNCHER_SUPPORT);
    }

    static void addJUnitPlatformResourceLocations(Path path, ClassLoader classLoader) {
        JUnitLauncherClassPathUtil.addResourceLocationToPath(path, classLoader, RESOURCE_IN_PLATFORM_ENGINE);
        JUnitLauncherClassPathUtil.addResourceLocationToPath(path, classLoader, RESOURCE_IN_PLATFORM_LAUNCHER);
        JUnitLauncherClassPathUtil.addResourceLocationToPath(path, classLoader, RESOURCE_IN_PLATFORM_COMMON);
    }

    static boolean addResourceLocationToPath(Path path, ClassLoader classLoader, String resource) {
        File f = LoaderUtils.getResourceSource(classLoader, resource);
        if (f == null) {
            return false;
        }
        path.createPath().setLocation(f);
        return true;
    }

    static boolean hasJUnitPlatformResources(ClassLoader cl) {
        File f = LoaderUtils.getResourceSource(cl, RESOURCE_IN_PLATFORM_ENGINE);
        return f != null;
    }

    private static String toResourceName(Class klass) {
        String name = klass.getName();
        return name.replaceAll("\\.", "/") + ".class";
    }
}

