/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.xml;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.analysis.AnalysisUtils;
import com.intellij.coverage.analysis.Annotator;
import com.intellij.coverage.analysis.JavaCoverageAnnotator;
import com.intellij.coverage.analysis.JavaCoverageClassesAnnotator;
import com.intellij.coverage.analysis.PackageAnnotator;
import com.intellij.coverage.view.CoverageClassStructure;
import com.intellij.coverage.xml.XMLReportAnnotatorKt;
import com.intellij.coverage.xml.XMLReportSuite;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.report.XMLProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J*\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/coverage/xml/XMLReportAnnotator;", "Lcom/intellij/coverage/analysis/JavaCoverageAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "annotate", "", "suite", "Lcom/intellij/coverage/CoverageSuitesBundle;", "dataManager", "Lcom/intellij/coverage/CoverageDataManager;", "annotator", "Lcom/intellij/coverage/analysis/Annotator;", "createRenewRequest", "Ljava/lang/Runnable;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "packageName", "", "fileName", "sourceRoots", "", "getCoverageForClass", "Lcom/intellij/coverage/analysis/PackageAnnotator$ClassCoverageInfo;", "classInfo", "Lcom/intellij/rt/coverage/report/XMLProjectData$ClassInfo;", "Companion", "intellij.java.coverage"})
@SourceDebugExtension(value={"SMAP\nXMLReportAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMLReportAnnotator.kt\ncom/intellij/coverage/xml/XMLReportAnnotator\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,114:1\n26#2:115\n9972#3:116\n10394#3,5:117\n372#4,7:122\n372#4,7:129\n372#4,7:136\n372#4,7:147\n1477#5:143\n1502#5,3:144\n1505#5,3:154\n1855#5,2:158\n215#6:157\n216#6:160\n*S KotlinDebug\n*F\n+ 1 XMLReportAnnotator.kt\ncom/intellij/coverage/xml/XMLReportAnnotator\n*L\n34#1:115\n35#1:116\n35#1:117,5\n41#1:122,7\n51#1:129,7\n53#1:136,7\n59#1:147,7\n59#1:143\n59#1:144,3\n59#1:154,3\n61#1:158,2\n59#1:157\n59#1:160\n*E\n"})
public final class XMLReportAnnotator
extends JavaCoverageAnnotator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public XMLReportAnnotator(@Nullable Project project) {
        super(project);
    }

    @Override
    @NotNull
    protected Runnable createRenewRequest(@NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager) {
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)dataManager, (String)"dataManager");
        return () -> XMLReportAnnotator.createRenewRequest$lambda$0(this, suite, dataManager);
    }

    /*
     * WARNING - void declaration
     */
    public final void annotate(@NotNull CoverageSuitesBundle suite, @NotNull CoverageDataManager dataManager, @NotNull Annotator annotator) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv22;
        CoverageSuite[] $this$flatMap$iv;
        Module[] moduleArray;
        Intrinsics.checkNotNullParameter((Object)suite, (String)"suite");
        Intrinsics.checkNotNullParameter((Object)dataManager, (String)"dataManager");
        Intrinsics.checkNotNullParameter((Object)annotator, (String)"annotator");
        HashMap classCoverage = new HashMap();
        HashMap flattenPackageCoverage = new HashMap();
        HashMap flattenDirectoryCoverage = new HashMap();
        Module[] moduleArray2 = (Module[])dataManager.doInReadActionIfProjectOpen(() -> XMLReportAnnotator.annotate$lambda$1(suite));
        if (moduleArray2 == null) {
            boolean $i$f$emptyArray = false;
            moduleArray = new Module[]{};
        } else {
            moduleArray = moduleArray2;
        }
        moduleArray2 = moduleArray;
        int $i$f$flatMap = 0;
        void var10_9 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv22).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$flatMapTo$iv$iv22[i];
            boolean bl = false;
            Set<VirtualFile> set = JavaCoverageClassesAnnotator.getSourceRoots((Module)it);
            Intrinsics.checkNotNullExpressionValue(set, (String)"getSourceRoots(...)");
            list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        HashSet sourceRoots = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        CoverageSuite[] coverageSuiteArray = suite.getSuites();
        Intrinsics.checkNotNullExpressionValue((Object)coverageSuiteArray, (String)"getSuites(...)");
        for (CoverageSuite xmlSuite : coverageSuiteArray) {
            XMLProjectData xmlReport;
            if (!(xmlSuite instanceof XMLReportSuite) || ((XMLReportSuite)xmlSuite).getReportData() == null) continue;
            for (XMLProjectData.ClassInfo classInfo : xmlReport.getClasses()) {
                Object object;
                Object object2;
                PackageAnnotator.PackageCoverageInfo answer$iv;
                String packageName2;
                Object object3;
                String key$iv;
                void $this$getOrPut$iv;
                list$iv$iv = classCoverage;
                Intrinsics.checkNotNullExpressionValue((Object)classInfo.name, (String)"name");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    PackageAnnotator.ClassCoverageInfo answer$iv2 = new PackageAnnotator.ClassCoverageInfo();
                    $this$getOrPut$iv.put(key$iv, answer$iv2);
                    object3 = answer$iv2;
                } else {
                    object3 = value$iv;
                }
                PackageAnnotator.ClassCoverageInfo currentCoverage = (PackageAnnotator.ClassCoverageInfo)object3;
                Intrinsics.checkNotNull((Object)classInfo);
                PackageAnnotator.ClassCoverageInfo thisSuiteCoverage = this.getCoverageForClass(classInfo);
                PackageAnnotator.ClassCoverageInfo coverage = XMLReportAnnotatorKt.access$minus(thisSuiteCoverage, currentCoverage);
                currentCoverage.append(coverage);
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.getPackageName((String)classInfo.name), (String)"getPackageName(...)");
                VirtualFile virtualFile2 = this.findFile(packageName2, classInfo.fileName, sourceRoots);
                Map $this$getOrPut$iv2 = flattenPackageCoverage;
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(packageName2);
                if (value$iv2 == null) {
                    boolean bl = false;
                    answer$iv = new PackageAnnotator.PackageCoverageInfo();
                    $this$getOrPut$iv2.put(packageName2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv2;
                }
                ((PackageAnnotator.PackageCoverageInfo)object2).append(coverage);
                if (virtualFile2 == null) continue;
                $this$getOrPut$iv2 = flattenDirectoryCoverage;
                $i$f$getOrPut2 = false;
                value$iv2 = $this$getOrPut$iv2.get(virtualFile2);
                if (value$iv2 == null) {
                    boolean bl = false;
                    answer$iv = new PackageAnnotator.PackageCoverageInfo();
                    $this$getOrPut$iv2.put(virtualFile2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                ((PackageAnnotator.PackageCoverageInfo)object).append(coverage);
            }
        }
        Set set = classCoverage.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        Object $this$groupBy$iv = set;
        boolean $i$f$groupBy = false;
        Iterable $this$flatMapTo$iv$iv22 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = AnalysisUtils.getSourceToplevelFQName((String)it.getKey());
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv2 = (List)object;
            list$iv$iv2.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String className2 = (String)entry.getKey();
            List classes2 = (List)entry.getValue();
            PackageAnnotator.ClassCoverageInfo coverage = new PackageAnnotator.ClassCoverageInfo();
            Iterable $this$forEach$iv2 = classes2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map.Entry it = (Map.Entry)element$iv2;
                boolean bl3 = false;
                coverage.append((PackageAnnotator.ClassCoverageInfo)it.getValue());
            }
            annotator.annotateClass(className2, coverage);
        }
        JavaCoverageClassesAnnotator.annotatePackages(flattenPackageCoverage, annotator);
        JavaCoverageClassesAnnotator.annotateDirectories(flattenDirectoryCoverage, annotator, sourceRoots);
    }

    private final VirtualFile findFile(String packageName2, String fileName, Collection<? extends VirtualFile> sourceRoots) {
        if (fileName == null) {
            return null;
        }
        String path = XMLReportSuite.Companion.getPath(packageName2, fileName);
        for (VirtualFile virtualFile2 : sourceRoots) {
            VirtualFile virtualFile3 = virtualFile2.findFileByRelativePath(path);
            if (virtualFile3 == null) continue;
            VirtualFile file = virtualFile3;
            return file.getParent();
        }
        return null;
    }

    private final PackageAnnotator.ClassCoverageInfo getCoverageForClass(XMLProjectData.ClassInfo classInfo) {
        PackageAnnotator.ClassCoverageInfo coverage = new PackageAnnotator.ClassCoverageInfo();
        coverage.totalBranchCount = classInfo.coveredBranches + classInfo.missedBranches;
        coverage.coveredBranchCount = classInfo.coveredBranches;
        coverage.totalMethodCount = classInfo.coveredMethods + classInfo.missedMethods;
        coverage.coveredMethodCount = classInfo.coveredMethods;
        coverage.totalClassCount = coverage.totalMethodCount > 0 ? 1 : 0;
        coverage.coveredClassCount = classInfo.coveredMethods > 0 ? 1 : 0;
        coverage.totalLineCount = classInfo.coveredLines + classInfo.missedLines;
        coverage.fullyCoveredLineCount = classInfo.coveredLines;
        return coverage;
    }

    private static final void createRenewRequest$lambda$0(XMLReportAnnotator this$0, CoverageSuitesBundle $suite, CoverageDataManager $dataManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$suite, (String)"$suite");
        Intrinsics.checkNotNullParameter((Object)$dataManager, (String)"$dataManager");
        this$0.annotate($suite, $dataManager, new JavaCoverageAnnotator.JavaPackageAnnotator(this$0));
        Project project = this$0.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this$0.myStructure = new CoverageClassStructure(project, this$0);
        Disposer.register((Disposable)((Disposable)this$0), (Disposable)this$0.myStructure);
        $dataManager.triggerPresentationUpdate();
    }

    private static final Module[] annotate$lambda$1(CoverageSuitesBundle $suite) {
        Intrinsics.checkNotNullParameter((Object)$suite, (String)"$suite");
        Project project = $suite.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ModuleManager.Companion.getInstance(project).getModules();
    }

    @JvmStatic
    @NotNull
    public static final XMLReportAnnotator getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/coverage/xml/XMLReportAnnotator$Companion;", "", "()V", "getInstance", "Lcom/intellij/coverage/xml/XMLReportAnnotator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.coverage"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final XMLReportAnnotator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(XMLReportAnnotator.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (XMLReportAnnotator)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

