/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableManager;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ/\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0007\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\bH\u0016R\"\u0010\u0003\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/repo/GitConfigurationCache;", "Lcom/intellij/openapi/Disposable;", "()V", "cache", "", "Lgit4idea/repo/GitConfigurationCache$ConfigKey;", "Ljava/util/concurrent/CompletableFuture;", "clearCache", "", "computeCachedValue", "T", "configKey", "computeValue", "Lkotlin/Function0;", "(Lgit4idea/repo/GitConfigurationCache$ConfigKey;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "dispose", "Companion", "ConfigKey", "intellij.vcs.git"})
@ApiStatus.Experimental
public final class GitConfigurationCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ConfigKey<?>, CompletableFuture<?>> cache;

    public GitConfigurationCache() {
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.cache = concurrentMap;
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic<GitExecutableListener> topic = GitExecutableManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, () -> GitConfigurationCache._init_$lambda$0(this));
    }

    @RequiresBackgroundThread
    public final <T> T computeCachedValue(@NotNull ConfigKey<T> configKey, @NotNull Function0<? extends T> computeValue) {
        Intrinsics.checkNotNullParameter(configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter(computeValue, (String)"computeValue");
        CompletableFuture<Object> future2 = new CompletableFuture<Object>();
        CompletableFuture oldFuture = this.cache.putIfAbsent(configKey, future2);
        if (oldFuture != null) {
            try {
                return oldFuture.get();
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                if (throwable == null) {
                    throwable = e;
                }
                throw throwable;
            }
            catch (CancellationException e) {
                if (oldFuture.isCancelled()) {
                    ProgressManager.checkCanceled();
                    return (T)computeValue.invoke();
                }
                throw e;
            }
        }
        try {
            Object result2 = computeValue.invoke();
            future2.complete(result2);
            return (T)result2;
        }
        catch (ProcessCanceledException e) {
            this.cache.remove(configKey, future2);
            future2.cancel(true);
            throw e;
        }
        catch (Throwable e) {
            future2.completeExceptionally(e);
            throw e;
        }
    }

    public final void clearCache() {
        this.cache.clear();
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(GitConfigurationCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.clearCache();
    }

    @JvmStatic
    @NotNull
    public static final GitConfigurationCache getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lgit4idea/repo/GitConfigurationCache$Companion;", "", "()V", "getInstance", "Lgit4idea/repo/GitConfigurationCache;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitConfigurationCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConfigurationCache.kt\ngit4idea/repo/GitConfigurationCache$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,85:1\n43#2,3:86\n*S KotlinDebug\n*F\n+ 1 GitConfigurationCache.kt\ngit4idea/repo/GitConfigurationCache$Companion\n*L\n25#1:86,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitConfigurationCache getInstance() {
            boolean $i$f$service = false;
            Class<GitConfigurationCache> serviceClass$iv = GitConfigurationCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (GitConfigurationCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0003\u00c0\u0006\u0001"}, d2={"Lgit4idea/repo/GitConfigurationCache$ConfigKey;", "T", "", "intellij.vcs.git"})
    public static interface ConfigKey<T> {
    }
}

