/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewNodeAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.HoverIcon;
import git4idea.conflicts.GitConflictsUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.ui.GitStagePanelKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitStagingAreaHolder;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lgit4idea/merge/GitChangesViewNodeAction;", "Lcom/intellij/openapi/vcs/changes/ChangesViewNodeAction;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createNodeHoverIcon", "Lcom/intellij/openapi/vcs/changes/ui/HoverIcon;", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "GitMergeHoverIcon", "intellij.vcs.git"})
public final class GitChangesViewNodeAction
implements ChangesViewNodeAction {
    @NotNull
    private final Project project;

    public GitChangesViewNodeAction(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public HoverIcon createNodeHoverIcon(@NotNull ChangesBrowserNode<?> node) {
        GitStagingAreaHolder stagingAreaHolder;
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Object object = node.getUserObject();
        Change change = object instanceof Change ? (Change)object : null;
        if (change == null) {
            return null;
        }
        Change change2 = change;
        if (!Intrinsics.areEqual((Object)change2.getFileStatus(), (Object)FileStatus.MERGED_WITH_CONFLICTS)) {
            return null;
        }
        FilePath filePath = ChangesUtil.getFilePath((Change)change2);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath path = filePath;
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForFileQuick(path);
        GitStagingAreaHolder gitStagingAreaHolder = stagingAreaHolder = gitRepository != null ? gitRepository.getStagingAreaHolder() : null;
        if ((gitStagingAreaHolder != null ? gitStagingAreaHolder.findConflict(path) : null) == null) {
            return null;
        }
        return new GitMergeHoverIcon(this.project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lgit4idea/merge/GitChangesViewNodeAction$GitMergeHoverIcon;", "Lcom/intellij/openapi/vcs/changes/ui/HoverIcon;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "invokeAction", "", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "toString", "", "intellij.vcs.git"})
    private static final class GitMergeHoverIcon
    extends HoverIcon {
        @NotNull
        private final Project project;

        public GitMergeHoverIcon(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Icon icon = AllIcons.Vcs.Merge;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Merge");
            super(icon, GitBundle.message("changes.view.merge.action.text", new Object[0]));
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public void invokeAction(@NotNull ChangesBrowserNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Object object = node.getUserObject();
            Change change = object instanceof Change ? (Change)object : null;
            if (change == null) {
                return;
            }
            Change change2 = change;
            FilePath filePath = ChangesUtil.getFilePath((Change)change2);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            FilePath path = filePath;
            GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForFileQuick(path);
            GitStagingAreaHolder stagingAreaHolder = gitRepository != null ? gitRepository.getStagingAreaHolder() : null;
            Object object2 = stagingAreaHolder;
            if (object2 == null || (object2 = ((GitStagingAreaHolder)object2).findConflict(path)) == null) {
                return;
            }
            Object conflict2 = object2;
            GitConflictsUtil.INSTANCE.showMergeWindow$intellij_vcs_git(this.project, GitStagePanelKt.createMergeHandler(this.project), CollectionsKt.listOf((Object)conflict2));
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final GitMergeHoverIcon copy(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new GitMergeHoverIcon(project);
        }

        public static /* synthetic */ GitMergeHoverIcon copy$default(GitMergeHoverIcon gitMergeHoverIcon, Project project, int n, Object object) {
            if ((n & 1) != 0) {
                project = gitMergeHoverIcon.project;
            }
            return gitMergeHoverIcon.copy(project);
        }

        @NotNull
        public String toString() {
            return "GitMergeHoverIcon(project=" + this.project + ")";
        }

        public int hashCode() {
            return this.project.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GitMergeHoverIcon)) {
                return false;
            }
            GitMergeHoverIcon gitMergeHoverIcon = (GitMergeHoverIcon)((Object)other);
            return Intrinsics.areEqual((Object)this.project, (Object)gitMergeHoverIcon.project);
        }
    }
}

