/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.branch;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.UtilKt;
import git4idea.GitBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u000b\u0010\u000f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0015\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00110\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0007R/\u0010\u0003\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\t\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n \u0007*\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\u0004\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgit4idea/actions/branch/GitBranchActionsUtil;", "", "()V", "BRANCHES_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "", "Lgit4idea/GitBranch;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "REPOSITORIES_KEY", "Lgit4idea/repo/GitRepository;", "SELECTED_REPO_KEY", "calculateNewBranchInitialName", "", "Lcom/intellij/openapi/util/NlsSafe;", "branchName", "isRemote", "", "branch", "getAffectedRepositories", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getRepositoriesForTopLevelActions", "isTopLevelAction", "Lkotlin/Function1;", "userWantsSyncControl", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchActionsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchActionsUtil.kt\ngit4idea/actions/branch/GitBranchActionsUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class GitBranchActionsUtil {
    @NotNull
    public static final GitBranchActionsUtil INSTANCE = new GitBranchActionsUtil();
    @JvmField
    @NotNull
    public static final DataKey<List<GitRepository>> REPOSITORIES_KEY;
    @JvmField
    @NotNull
    public static final DataKey<GitRepository> SELECTED_REPO_KEY;
    @JvmField
    @NotNull
    public static final DataKey<List<GitBranch>> BRANCHES_KEY;

    private GitBranchActionsUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String calculateNewBranchInitialName(@NotNull GitBranch branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        String string = branch.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return GitBranchActionsUtil.calculateNewBranchInitialName(string, branch.isRemote());
    }

    @JvmStatic
    @NotNull
    public static final String calculateNewBranchInitialName(@NotNull String branchName, boolean isRemote) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        if (!(((CharSequence)branchName).length() > 0)) {
            boolean bl = false;
            String string = "Given branch name cannot be empty";
            throw new IllegalArgumentException(string.toString());
        }
        if (!isRemote) {
            return branchName;
        }
        char[] cArray = new char[]{'/'};
        List split = StringsKt.split$default((CharSequence)branchName, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        return split.size() == 1 ? branchName : CollectionsKt.joinToString$default((Iterable)UtilKt.tail((List)split), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmStatic
    @NotNull
    public static final List<GitRepository> getRepositoriesForTopLevelActions(@NotNull AnActionEvent e, @NotNull Function1<? super AnActionEvent, Boolean> isTopLevelAction) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(isTopLevelAction, (String)"isTopLevelAction");
        Project project = e.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        if (((Boolean)isTopLevelAction.invoke((Object)e)).booleanValue()) {
            if (!GitBranchActionsUtil.userWantsSyncControl(project2)) {
                List list2;
                List list3;
                GitRepository gitRepository = (GitRepository)e.getData(SELECTED_REPO_KEY);
                if (gitRepository != null) {
                    GitRepository p0 = gitRepository;
                    boolean bl = false;
                    list3 = CollectionsKt.listOf((Object)p0);
                } else {
                    list3 = list2 = null;
                }
                if (list3 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                return list2;
            }
        }
        return GitBranchActionsUtil.getAffectedRepositories(e);
    }

    @JvmStatic
    @NotNull
    public static final List<GitRepository> getAffectedRepositories(@NotNull AnActionEvent e) {
        List list2;
        List list3;
        List repositoriesInContext;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        List list4 = (List)e.getData(REPOSITORIES_KEY);
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        if (!((Collection)(repositoriesInContext = list4)).isEmpty()) {
            return repositoriesInContext;
        }
        if (GitBranchActionsUtil.userWantsSyncControl(project2)) {
            List<GitRepository> list5 = GitRepositoryManager.getInstance(project2).getRepositories();
            Intrinsics.checkNotNullExpressionValue(list5, (String)"getRepositories(...)");
            return list5;
        }
        GitRepository gitRepository = GitBranchUtil.guessRepositoryForOperation(project2, e.getDataContext());
        if (gitRepository != null) {
            GitRepository p0 = gitRepository;
            boolean bl = false;
            list3 = CollectionsKt.listOf((Object)p0);
        } else {
            list3 = list2 = null;
        }
        if (list3 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @JvmStatic
    public static final boolean userWantsSyncControl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GitVcsSettings.getInstance(project).getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC;
    }

    static {
        DataKey dataKey = DataKey.create((String)"Git.Repositories");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        REPOSITORIES_KEY = dataKey;
        DataKey dataKey2 = DataKey.create((String)"Git.Selected.Repository");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"create(...)");
        SELECTED_REPO_KEY = dataKey2;
        DataKey dataKey3 = DataKey.create((String)"Git.Branches");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"create(...)");
        BRANCHES_KEY = dataKey3;
    }
}

