/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.DifferentiateContext;
import org.jetbrains.jps.dependency.Graph;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JvmClass;
import org.jetbrains.jps.dependency.java.JvmField;
import org.jetbrains.jps.dependency.java.JvmMethod;
import org.jetbrains.jps.dependency.java.JvmModule;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.ProtoMember;
import org.jetbrains.jps.dependency.java.TypeRepr;
import org.jetbrains.jps.javac.Iterators;

public final class Utils {
    public static final String OBJECT_CLASS_NAME = "java/lang/Object";
    @NotNull
    private final Graph myGraph;
    @Nullable
    private final Graph myDelta;
    @NotNull
    private final BackDependencyIndex myDirectSubclasses;

    public Utils(Graph graph, @Nullable Graph delta) {
        this.myGraph = graph;
        this.myDelta = delta;
        this.myDirectSubclasses = Objects.requireNonNull(graph.getIndex("direct-subclasses"));
    }

    public Iterable<JvmClass> getClassesByName(@NotNull String name) {
        if (name == null) {
            Utils.$$$reportNull$$$0(0);
        }
        return this.getNodes(new JvmNodeReferenceID(name), JvmClass.class);
    }

    public Iterable<JvmModule> getModulesByName(@NotNull String name) {
        if (name == null) {
            Utils.$$$reportNull$$$0(1);
        }
        return this.getNodes(new JvmNodeReferenceID(name), JvmModule.class);
    }

    @Nullable
    public String getNodeName(ReferenceID id) {
        if (id instanceof JvmNodeReferenceID) {
            return ((JvmNodeReferenceID)id).getNodeName();
        }
        Iterable<JVMClassNode> nodes = this.getNodes(id, JVMClassNode.class);
        Iterator<JVMClassNode> iterator = nodes.iterator();
        if (iterator.hasNext()) {
            JVMClassNode node = iterator.next();
            return node.getName();
        }
        return null;
    }

    public boolean isLambdaTarget(ReferenceID classId) {
        for (JvmClass cls : this.getNodes(classId, JvmClass.class)) {
            if (!cls.isInterface()) continue;
            int amFound = 0;
            for (JvmMethod method : this.allMethodsRecursively(cls)) {
                if (method.isAbstract() && ++amFound > 1) break;
            }
            if (amFound != true) continue;
            return true;
        }
        return false;
    }

    public Iterable<JvmMethod> allMethodsRecursively(JvmClass cls) {
        return Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.recurse((Object)cls, c -> Iterators.flat((Iterable)Iterators.map(c.getSuperTypes(), st -> this.getClassesByName((String)st))), (boolean)true), c -> c.getMethods()));
    }

    public <T extends JVMClassNode<T, ?>> Iterable<T> getNodes(@NotNull ReferenceID id, Class<T> selector) {
        Iterable allNodes;
        if (id == null) {
            Utils.$$$reportNull$$$0(2);
        }
        if (id instanceof JvmNodeReferenceID && "".equals(((JvmNodeReferenceID)id).getNodeName())) {
            return Collections.emptyList();
        }
        if (this.myDelta != null) {
            Set deltaSources = (Set)Iterators.collect(this.myDelta.getSources(id), new HashSet());
            allNodes = Iterators.flat((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)deltaSources, src -> this.myDelta.getNodes((NodeSource)src, selector))), (Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.filter(this.myGraph.getSources(id), src -> !deltaSources.contains(src)), src -> this.myGraph.getNodes((NodeSource)src, selector))));
        } else {
            allNodes = Iterators.flat((Iterable)Iterators.map(this.myGraph.getSources(id), src -> this.myGraph.getNodes((NodeSource)src, selector)));
        }
        return Iterators.unique((Iterable)Iterators.filter((Iterable)allNodes, n -> id.equals(n.getReferenceID())));
    }

    public Iterable<JvmNodeReferenceID> allDirectSupertypes(JvmNodeReferenceID classId) {
        return Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.map(this.getNodes(classId, JvmClass.class), cl -> Iterators.map(cl.getSuperTypes(), st -> new JvmNodeReferenceID((String)st)))));
    }

    public Iterable<JvmNodeReferenceID> allSupertypes(JvmNodeReferenceID classId) {
        return Iterators.recurse((Object)classId, s -> this.allDirectSupertypes((JvmNodeReferenceID)s), (boolean)false);
    }

    @NotNull
    public Iterable<ReferenceID> withAllSubclasses(ReferenceID from) {
        Iterable iterable = Iterators.recurse((Object)from, this.myDirectSubclasses::getDependencies, (boolean)true);
        if (iterable == null) {
            Utils.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    @NotNull
    public Iterable<ReferenceID> allSubclasses(ReferenceID from) {
        Iterable iterable = Iterators.recurse((Object)from, this.myDirectSubclasses::getDependencies, (boolean)false);
        if (iterable == null) {
            Utils.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    public Set<JvmNodeReferenceID> collectSubclassesWithoutField(JvmNodeReferenceID classId, String fieldName) {
        return this.collectSubclassesWithoutMember(classId, f -> fieldName.equals(f.getName()), cls -> cls.getFields());
    }

    public Set<JvmNodeReferenceID> collectSubclassesWithoutMethod(JvmNodeReferenceID classId, JvmMethod method) {
        return this.collectSubclassesWithoutMember(classId, m -> method.equals(m), cls -> cls.getMethods());
    }

    private <T extends ProtoMember> Set<JvmNodeReferenceID> collectSubclassesWithoutMember(JvmNodeReferenceID classId, Predicate<? super T> isSame, Function<JvmClass, Iterable<T>> membersGetter) {
        Predicate<ReferenceID> containsMember = id -> Iterators.isEmpty((Iterable)Iterators.filter(this.getNodes((ReferenceID)id, (Class)JvmClass.class), cls -> Iterators.isEmpty((Iterable)Iterators.filter((Iterable)((Iterable)membersGetter.apply((JvmClass)cls)), isSame::test))));
        Set result = Utils.collectNodeData(classId, id -> this.myDirectSubclasses.getDependencies((ReferenceID)id), id -> id instanceof JvmNodeReferenceID && !containsMember.test((ReferenceID)id) ? (JvmNodeReferenceID)id : null, Objects::nonNull, false, new HashSet());
        result.remove(null);
        return result;
    }

    public Iterable<Pair<JvmClass, JvmMethod>> getOverriddenMethods(JvmClass fromCls, Predicate<JvmMethod> searchCond) {
        Function<JvmClass, Iterable> dataGetter = cl -> Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.filter(cl.getMethods(), m -> searchCond.test((JvmMethod)m) && Utils.isVisibleIn(cl, m, fromCls)), mm -> Pair.create((Object)cl, (Object)mm)), (Collection)new SmartList());
        return Iterators.flat((Collection)Utils.collectNodeData(fromCls, cl -> Iterators.flat((Iterable)Iterators.map(cl.getSuperTypes(), st -> this.getClassesByName((String)st))), dataGetter, result -> Iterators.isEmpty((Iterable)result), false, new SmartList()));
    }

    public Iterable<Pair<JvmClass, JvmMethod>> getOverridingMethods(JvmClass fromCls, JvmMethod method, Predicate<JvmMethod> searchCond) {
        Function<JvmClass, Iterable> dataGetter = cl -> Utils.isVisibleIn(fromCls, method, cl) ? Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.filter(cl.getMethods(), searchCond::test), mm -> Pair.create((Object)cl, (Object)mm)), (Collection)new SmartList()) : Collections.emptyList();
        return Iterators.flat((Collection)Utils.collectNodeData(fromCls, cl -> Iterators.flat((Iterable)Iterators.map(this.myDirectSubclasses.getDependencies(cl.getReferenceID()), st -> this.getNodes((ReferenceID)st, (Class)JvmClass.class))), dataGetter, result -> Iterators.isEmpty((Iterable)result), false, new SmartList()));
    }

    private static <N, V, C extends Collection<? super V>> C collectNodeData(N fromNode, Function<? super N, ? extends Iterable<? extends N>> step, Function<N, V> dataGetter, Predicate<V> continuationCond, boolean includeHead, C acc) {
        Function mapper = Utils.cachingFunction(dataGetter);
        return (C)Iterators.collect((Iterable)Iterators.map((Iterable)Iterators.recurseDepth(fromNode, node -> fromNode.equals(node) || continuationCond.test(mapper.apply(node)) ? (List)step.apply((Object)node) : Collections.emptyList(), (boolean)includeHead), mapper::apply), acc);
    }

    public boolean hasOverriddenMethods(JvmClass cls, JvmMethod method) {
        return !Iterators.isEmpty(this.getOverriddenMethods(cls, method::isSameByJavaRules)) || this.inheritsFromLibraryClass(cls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isMethodVisible(JvmClass cls, JvmMethod method) {
        if (!Iterators.isEmpty((Iterable)Iterators.filter(cls.getMethods(), method::isSameByJavaRules))) return true;
        if (Iterators.isEmpty(this.getOverriddenMethods(cls, method::isSameByJavaRules))) return false;
        return true;
    }

    private static boolean isVisibleIn(JvmClass cls, ProtoMember member, JvmClass scope) {
        boolean privacy = member.isPrivate() && !Objects.equals(cls.getName(), scope.getName());
        boolean packageLocality = member.isPackageLocal() && !Objects.equals(cls.getPackageName(), scope.getPackageName());
        return !privacy && !packageLocality;
    }

    public boolean inheritsFromLibraryClass(JvmClass cls) {
        for (String st : cls.getSuperTypes()) {
            Iterator<JvmClass> classes = this.getClassesByName(st).iterator();
            if (!classes.hasNext()) {
                return true;
            }
            while (classes.hasNext()) {
                if (!this.inheritsFromLibraryClass(classes.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Boolean isInheritorOf(JvmNodeReferenceID who, JvmNodeReferenceID whom) {
        if (who.equals(whom) || !Iterators.isEmpty((Iterable)Iterators.filter(this.allSupertypes(who), st -> st.equals(whom)))) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Predicate<JvmMethod> lessSpecific(JvmMethod than) {
        return m -> {
            if (m.isConstructor() || !Objects.equals(m.getName(), than.getName())) {
                return false;
            }
            Iterator<TypeRepr> it = m.getArgTypes().iterator();
            for (TypeRepr thanArgType : than.getArgTypes()) {
                if (!it.hasNext()) {
                    return false;
                }
                TypeRepr mArgType = it.next();
                Boolean subtypeOf = this.isSubtypeOf(thanArgType, mArgType);
                if (subtypeOf == null || subtypeOf.booleanValue()) continue;
                return false;
            }
            return !it.hasNext();
        };
    }

    @Nullable
    public Boolean isSubtypeOf(TypeRepr who, TypeRepr whom) {
        if (who.equals(whom)) {
            return Boolean.TRUE;
        }
        if (who instanceof TypeRepr.PrimitiveType || whom instanceof TypeRepr.PrimitiveType) {
            return Boolean.FALSE;
        }
        if (who instanceof TypeRepr.ArrayType) {
            if (whom instanceof TypeRepr.ArrayType) {
                return this.isSubtypeOf(((TypeRepr.ArrayType)who).getElementType(), ((TypeRepr.ArrayType)whom).getElementType());
            }
            String descr = whom.getDescriptor();
            if (descr.equals("Ljava/lang/Cloneable") || descr.equals("Ljava/lang/Object") || descr.equals("Ljava/io/Serializable")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (whom instanceof TypeRepr.ClassType) {
            return this.isInheritorOf(new JvmNodeReferenceID(((TypeRepr.ClassType)who).getJvmName()), new JvmNodeReferenceID(((TypeRepr.ClassType)whom).getJvmName()));
        }
        return Boolean.FALSE;
    }

    public boolean incrementalDecision(DifferentiateContext context, JvmClass owner, @Nullable JvmField field) {
        if ((field != null ? field : owner).isPublic()) {
            this.debug("Public access, switching to a non-incremental mode");
            return false;
        }
        HashSet toRecompile = new HashSet();
        if ((field != null ? field : owner).isProtected()) {
            Set<JvmNodeReferenceID> propagated;
            this.debug("Protected access, softening non-incremental decision: adding all relevant subclasses for a recompilation");
            this.debug("Root class: " + owner.getName());
            if (field != null) {
                propagated = this.collectSubclassesWithoutField(owner.getReferenceID(), field.getName());
            } else {
                JvmNodeReferenceID ownerID = owner.getReferenceID();
                propagated = new HashSet<JvmNodeReferenceID>();
                for (ReferenceID id2 : this.withAllSubclasses(ownerID)) {
                    if (!(id2 instanceof JvmNodeReferenceID) || id2.equals(ownerID)) continue;
                    propagated.add((JvmNodeReferenceID)id2);
                }
            }
            Iterators.collect((Iterable)Iterators.flat((Iterable)Iterators.map(propagated, id -> this.myGraph.getSources((ReferenceID)id))), toRecompile);
        }
        String packageName = owner.getPackageName();
        this.debug("Softening non-incremental decision: adding all package classes for a recompilation");
        this.debug("Package name: " + packageName);
        Iterators.collect((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.filter(this.myGraph.getRegisteredNodes(), id -> id instanceof JvmNodeReferenceID && packageName.equals(JvmClass.getPackageName(((JvmNodeReferenceID)id).getNodeName()))), id -> this.myGraph.getSources((ReferenceID)id))), toRecompile);
        for (NodeSource source : Iterators.filter(toRecompile, s -> !context.isCompiled((NodeSource)s) && !context.getDelta().getDeletedSources().contains(s))) {
            context.affectNodeSource(source);
        }
        return true;
    }

    private static <K, V> Function<K, V> cachingFunction(final Function<K, V> f) {
        return new Function<K, V>(){
            private final Map<K, V> cache = new HashMap();

            @Override
            public V apply(K k) {
                return this.cache.computeIfAbsent(k, f);
            }
        };
    }

    private void debug(String message) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/java/Utils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/java/Utils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withAllSubclasses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "allSubclasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassesByName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModulesByName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

