/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

import org.jetbrains.jps.dependency.java.ElemType;
import org.jetbrains.jps.dependency.java.JvmElementUsage;
import org.jetbrains.jps.dependency.java.JvmNodeReferenceID;
import org.jetbrains.jps.dependency.java.TypeRepr;

public final class AnnotationUsage
extends JvmElementUsage {
    private final TypeRepr.ClassType myClassType;
    private final Iterable<String> myUsedArgNames;
    private final Iterable<ElemType> myTargets;

    public AnnotationUsage(TypeRepr.ClassType classType, Iterable<String> usedArgNames, Iterable<ElemType> targets) {
        super(new JvmNodeReferenceID(classType.getJvmName()));
        this.myClassType = classType;
        this.myUsedArgNames = usedArgNames;
        this.myTargets = targets;
    }

    public TypeRepr.ClassType getClassType() {
        return this.myClassType;
    }

    public Iterable<String> getUsedArgNames() {
        return this.myUsedArgNames;
    }

    public Iterable<ElemType> getTargets() {
        return this.myTargets;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationUsage that = (AnnotationUsage)o;
        if (!this.myClassType.equals(that.myClassType)) {
            return false;
        }
        if (!this.myUsedArgNames.equals(that.myUsedArgNames)) {
            return false;
        }
        return this.myTargets.equals(that.myTargets);
    }

    @Override
    public int hashCode() {
        int result = this.myClassType.hashCode();
        result = 31 * result + this.myUsedArgNames.hashCode();
        result = 31 * result + this.myTargets.hashCode();
        return result;
    }
}

