/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.logging;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;

public abstract class ProjectBuilderLoggerBase
implements ProjectBuilderLogger {
    @Override
    public void logDeletedFiles(Collection<String> paths) {
        if (paths.isEmpty()) {
            return;
        }
        Object[] buffer = new String[paths.size()];
        int i = 0;
        for (String o : paths) {
            buffer[i++] = o;
        }
        Arrays.sort(buffer);
        this.logLine("Cleaning output files:");
        for (Object o : buffer) {
            this.logLine((String)o);
        }
        this.logLine("End of files");
    }

    @Override
    public void logCompiledFiles(Collection<File> files, String builderId, String description) throws IOException {
        this.logLine(description);
        Object[] buffer = new String[files.size()];
        int i = 0;
        for (File f : files) {
            buffer[i++] = FileUtil.toSystemIndependentName((String)f.getCanonicalPath());
        }
        Arrays.sort(buffer);
        for (Object s : buffer) {
            this.logLine((String)s);
        }
        this.logLine("End of files");
    }

    @Override
    public void logCompiledPaths(Collection<String> paths, String builderId, String description) throws IOException {
        ArrayList<File> files = new ArrayList<File>(paths.size());
        for (String path : paths) {
            files.add(new File(path));
        }
        this.logCompiledFiles(files, builderId, description);
    }

    protected abstract void logLine(@NonNls String var1);
}

