/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.model.taskModel;

import com.intellij.gradle.toolingExtension.impl.util.GradleProjectUtil;
import com.intellij.gradle.toolingExtension.modelAction.GradleModelFetchPhase;
import com.intellij.gradle.toolingExtension.util.GradleNegotiationUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.tooling.model.ProjectIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;

public final class GradleTaskCache {
    private final ModelBuilderContext context;
    private final ConcurrentMap<ProjectIdentifier, Set<Task>> allTasks;
    @NotNull
    private static final ModelBuilderContext.DataProvider<GradleTaskCache> INSTANCE_PROVIDER = GradleTaskCache::new;

    private GradleTaskCache(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleTaskCache.$$$reportNull$$$0(0);
        }
        this.context = context;
        this.allTasks = new ConcurrentHashMap<ProjectIdentifier, Set<Task>>();
    }

    public Set<Task> getAllTasks(@NotNull Project project) {
        if (project == null) {
            GradleTaskCache.$$$reportNull$$$0(1);
        }
        LinkedHashSet<Task> result = new LinkedHashSet<Task>(this.getProjectTasks(project));
        for (Project subProject : project.getSubprojects()) {
            result.addAll(this.getProjectTasks(subProject));
        }
        return result;
    }

    private Set<Task> getProjectTasks(@NotNull Project project) {
        ProjectIdentifier projectIdentifier;
        Set projectTasks;
        if (project == null) {
            GradleTaskCache.$$$reportNull$$$0(2);
        }
        if ((projectTasks = (Set)this.allTasks.get(projectIdentifier = GradleProjectUtil.getProjectIdentifier(project))) == null) {
            this.context.getMessageReporter().createMessage().withGroup("gradle.taskModel.cacheGet.group").withTitle("Task model aren't found").withText("Tasks for " + GradleNegotiationUtil.getProjectDisplayName((Project)project) + " wasn't collected. All tasks should be collected during " + GradleModelFetchPhase.TASK_WARM_UP_PHASE + ".").withException((Exception)new IllegalStateException()).withKind(Message.Kind.INTERNAL).reportMessage(project);
            return Collections.emptySet();
        }
        return projectTasks;
    }

    public void setProjectTasks(@NotNull Project project, @NotNull Set<Task> tasks) {
        ProjectIdentifier projectIdentifier;
        Set<Task> previousTasks;
        if (project == null) {
            GradleTaskCache.$$$reportNull$$$0(3);
        }
        if (tasks == null) {
            GradleTaskCache.$$$reportNull$$$0(4);
        }
        if ((previousTasks = this.allTasks.put(projectIdentifier = GradleProjectUtil.getProjectIdentifier(project), tasks)) != null) {
            this.context.getMessageReporter().createMessage().withGroup("gradle.taskModel.cacheSet.group").withTitle("Task model redefinition").withText("Tasks for " + GradleNegotiationUtil.getProjectDisplayName((Project)project) + " was already collected.").withException((Exception)new IllegalStateException()).withKind(Message.Kind.INTERNAL).reportMessage(project);
        }
    }

    public void markTaskModelAsError(@NotNull Project project) {
        if (project == null) {
            GradleTaskCache.$$$reportNull$$$0(5);
        }
        ProjectIdentifier projectIdentifier = GradleProjectUtil.getProjectIdentifier(project);
        this.allTasks.put(projectIdentifier, Collections.emptySet());
    }

    @NotNull
    public static GradleTaskCache getInstance(@NotNull ModelBuilderContext context) {
        if (context == null) {
            GradleTaskCache.$$$reportNull$$$0(6);
        }
        GradleTaskCache gradleTaskCache = (GradleTaskCache)context.getData(INSTANCE_PROVIDER);
        if (gradleTaskCache == null) {
            GradleTaskCache.$$$reportNull$$$0(7);
        }
        return gradleTaskCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/model/taskModel/GradleTaskCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/model/taskModel/GradleTaskCache";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllTasks";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectTasks";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setProjectTasks";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markTaskModelAsError";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

