/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.WCInfoWithBranches;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.mergeinfo.MergeCheckResult;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoCached;
import org.jetbrains.idea.svn.mergeinfo.MergeRange;
import org.jetbrains.idea.svn.mergeinfo.MergeRangeList;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class BranchInfo {
    private static final Logger LOG = Logger.getInstance(BranchInfo.class);
    @NotNull
    private final Map<String, Set<Long>> myPathMergedMap;
    @NotNull
    private final Map<String, Set<Long>> myNonInheritablePathMergedMap;
    private boolean myMixedRevisionsFound;
    @NotNull
    private final Map<Long, MergeCheckResult> myAlreadyCalculatedMap;
    @NotNull
    private final Object myCalculatedLock;
    @NotNull
    private final WCInfoWithBranches myInfo;
    @NotNull
    private final WCInfoWithBranches.Branch myBranch;
    @NotNull
    private final SvnVcs myVcs;
    private SvnMergeInfoCache.CopyRevison myCopyRevison;
    @NotNull
    private final MultiMap<Long, String> myPartlyMerged;

    public BranchInfo(@NotNull SvnVcs vcs, @NotNull WCInfoWithBranches info2, @NotNull WCInfoWithBranches.Branch branch) {
        if (vcs == null) {
            BranchInfo.$$$reportNull$$$0(0);
        }
        if (info2 == null) {
            BranchInfo.$$$reportNull$$$0(1);
        }
        if (branch == null) {
            BranchInfo.$$$reportNull$$$0(2);
        }
        this.myCalculatedLock = new Object();
        this.myVcs = vcs;
        this.myInfo = info2;
        this.myBranch = branch;
        this.myPathMergedMap = new HashMap<String, Set<Long>>();
        this.myPartlyMerged = MultiMap.create();
        this.myNonInheritablePathMergedMap = new HashMap<String, Set<Long>>();
        this.myAlreadyCalculatedMap = new HashMap<Long, MergeCheckResult>();
    }

    private long calculateCopyRevision(String branchPath) {
        if (this.myCopyRevison != null && Objects.equals(this.myCopyRevison.getPath(), branchPath)) {
            return this.myCopyRevison.getRevision();
        }
        this.myCopyRevison = new SvnMergeInfoCache.CopyRevison(this.myVcs, branchPath, this.myInfo.getRootInfo().getRepositoryUrl(), this.myBranch.getUrl(), this.myInfo.getUrl());
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.myPathMergedMap.clear();
        Object object = this.myCalculatedLock;
        synchronized (object) {
            this.myAlreadyCalculatedMap.clear();
        }
        this.myMixedRevisionsFound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public MergeInfoCached getCached() {
        Object object = this.myCalculatedLock;
        // MONITORENTER : object
        long revision = this.myCopyRevison != null ? this.myCopyRevison.getRevision() : -1L;
        MergeInfoCached mergeInfoCached = new MergeInfoCached(Collections.unmodifiableMap(this.myAlreadyCalculatedMap), revision);
        // MONITOREXIT : object
        if (mergeInfoCached != null) return mergeInfoCached;
        BranchInfo.$$$reportNull$$$0(3);
        return mergeInfoCached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public MergeCheckResult checkList(@NotNull SvnChangeList list, String branchPath) {
        if (list == null) {
            BranchInfo.$$$reportNull$$$0(4);
        }
        Object object = this.myCalculatedLock;
        // MONITORENTER : object
        long revision = this.calculateCopyRevision(branchPath);
        MergeCheckResult result = revision != -1L && revision >= list.getNumber() ? MergeCheckResult.COMMON : this.myAlreadyCalculatedMap.computeIfAbsent(list.getNumber(), __ -> this.checkAlive(list, branchPath));
        MergeCheckResult mergeCheckResult = result;
        // MONITOREXIT : object
        if (mergeCheckResult != null) return mergeCheckResult;
        BranchInfo.$$$reportNull$$$0(5);
        return mergeCheckResult;
    }

    @NotNull
    private MergeCheckResult checkAlive(@NotNull SvnChangeList list, @NotNull String branchPath) {
        Info info2;
        if (list == null) {
            BranchInfo.$$$reportNull$$$0(6);
        }
        if (branchPath == null) {
            BranchInfo.$$$reportNull$$$0(7);
        }
        if ((info2 = this.myVcs.getInfo(new File(branchPath))) == null || info2.getUrl() == null || !SvnUtil.isAncestor(this.myBranch.getUrl(), info2.getUrl())) {
            MergeCheckResult mergeCheckResult = MergeCheckResult.NOT_MERGED;
            if (mergeCheckResult == null) {
                BranchInfo.$$$reportNull$$$0(8);
            }
            return mergeCheckResult;
        }
        MultiMap<MergeCheckResult, String> result = this.checkPaths(list, branchPath, info2.getUrl());
        if (result.containsKey((Object)MergeCheckResult.NOT_EXISTS)) {
            MergeCheckResult mergeCheckResult = MergeCheckResult.NOT_EXISTS;
            if (mergeCheckResult == null) {
                BranchInfo.$$$reportNull$$$0(9);
            }
            return mergeCheckResult;
        }
        if (result.containsKey((Object)MergeCheckResult.NOT_MERGED)) {
            this.myPartlyMerged.put((Object)list.getNumber(), result.get((Object)MergeCheckResult.NOT_MERGED));
            MergeCheckResult mergeCheckResult = MergeCheckResult.NOT_MERGED;
            if (mergeCheckResult == null) {
                BranchInfo.$$$reportNull$$$0(10);
            }
            return mergeCheckResult;
        }
        MergeCheckResult mergeCheckResult = MergeCheckResult.MERGED;
        if (mergeCheckResult == null) {
            BranchInfo.$$$reportNull$$$0(11);
        }
        return mergeCheckResult;
    }

    @NotNull
    private MultiMap<MergeCheckResult, String> checkPaths(@NotNull SvnChangeList list, @NotNull String branchPath, @NotNull Url underBranchUrl) {
        if (list == null) {
            BranchInfo.$$$reportNull$$$0(12);
        }
        if (branchPath == null) {
            BranchInfo.$$$reportNull$$$0(13);
        }
        if (underBranchUrl == null) {
            BranchInfo.$$$reportNull$$$0(14);
        }
        MultiMap result = MultiMap.create();
        String subPathUnderBranch = SvnUtil.getRelativeUrl(this.myBranch.getUrl(), underBranchUrl);
        Url myTrunkUrlCorrespondingToLocalBranchPath = BranchInfo.appendPath(this.myInfo.getCurrentBranch().getUrl(), subPathUnderBranch);
        for (String path : list.getAffectedPaths()) {
            MergeCheckResult mergeCheckResult;
            Url url = BranchInfo.appendPath(this.myInfo.getRepoUrl(), path);
            if (!SvnUtil.isAncestor(myTrunkUrlCorrespondingToLocalBranchPath, url)) {
                mergeCheckResult = MergeCheckResult.NOT_EXISTS;
            } else {
                String relativeToTrunkPath = SvnUtil.getRelativeUrl(myTrunkUrlCorrespondingToLocalBranchPath, url);
                String localPathInBranch = new File(branchPath, relativeToTrunkPath).getAbsolutePath();
                try {
                    mergeCheckResult = this.checkPathGoingUp(list.getNumber(), -1L, branchPath, localPathInBranch, path, true);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    mergeCheckResult = MergeCheckResult.NOT_MERGED;
                }
            }
            result.putValue((Object)mergeCheckResult, (Object)path);
            if (!MergeCheckResult.NOT_EXISTS.equals((Object)mergeCheckResult)) continue;
            break;
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            BranchInfo.$$$reportNull$$$0(15);
        }
        return multiMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private MergeCheckResult goUp(long revisionAsked, long targetRevision, String branchRootPath, String string, @NotNull String string2) throws VcsException {
        Info svnInfo;
        void path;
        String newPath;
        void trunkUrl;
        String newTrunkUrl;
        if (string2 == null) {
            BranchInfo.$$$reportNull$$$0(16);
        }
        MergeCheckResult result = (newTrunkUrl = Url.removeTail((String)trunkUrl).trim()).length() == 0 || "/".equals(newTrunkUrl) ? MergeCheckResult.NOT_MERGED : ((newPath = new File((String)path).getParent()).length() < branchRootPath.length() ? (targetRevision == -1L ? MergeCheckResult.NOT_EXISTS : ((svnInfo = this.myVcs.getInfo(new File(branchRootPath))) == null || svnInfo.getUrl() == null ? MergeCheckResult.NOT_MERGED : this.goUpInRepo(revisionAsked, targetRevision, SvnUtil.removePathTail(svnInfo.getUrl()), newTrunkUrl))) : this.checkPathGoingUp(revisionAsked, targetRevision, branchRootPath, newPath, newTrunkUrl, false));
        MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            BranchInfo.$$$reportNull$$$0(17);
        }
        return mergeCheckResult;
    }

    @NotNull
    private MergeCheckResult goUpInRepo(long revisionAsked, long targetRevision, Url branchUrl, String trunkUrl) throws VcsException {
        MergeCheckResult result;
        Set<Long> mergeInfo = this.myPathMergedMap.get(branchUrl.toString() + "@" + targetRevision);
        if (mergeInfo != null) {
            result = MergeCheckResult.getInstance(mergeInfo.contains(revisionAsked));
        } else {
            Target target = Target.on(branchUrl);
            PropertyValue mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, Revision.of(targetRevision));
            if (mergeinfoProperty == null) {
                String newTrunkUrl = Url.removeTail(trunkUrl).trim();
                Url newBranchUrl = SvnUtil.removePathTail(branchUrl);
                Url absoluteTrunk = SvnUtil.append(this.myInfo.getRepoUrl(), newTrunkUrl);
                result = newTrunkUrl.length() <= 1 || newBranchUrl.toString().length() <= this.myInfo.getRepoUrl().toString().length() || newBranchUrl.equals(absoluteTrunk) ? MergeCheckResult.NOT_MERGED : this.goUpInRepo(revisionAsked, targetRevision, newBranchUrl, newTrunkUrl);
            } else {
                result = this.processMergeinfoProperty(branchUrl.toString() + "@" + targetRevision, revisionAsked, mergeinfoProperty, trunkUrl, false);
            }
        }
        MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            BranchInfo.$$$reportNull$$$0(18);
        }
        return mergeCheckResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private MergeCheckResult checkPathGoingUp(long revisionAsked, long targetRevision, @NotNull String branchRootPath, @NotNull String path, String string, boolean bl) throws VcsException {
        MergeCheckResult result;
        if (branchRootPath == null) {
            BranchInfo.$$$reportNull$$$0(19);
        }
        if (path == null) {
            BranchInfo.$$$reportNull$$$0(20);
        }
        File pathFile = new File(path);
        if (targetRevision == -1L && !pathFile.exists()) {
            result = this.goUp(revisionAsked, targetRevision, branchRootPath, path, (String)trunkUrl);
        } else {
            Info svnInfo = this.myVcs.getInfo(pathFile);
            if (svnInfo == null || svnInfo.getUrl() == null) {
                LOG.info("Svninfo for " + pathFile + " is null or not full.");
                result = MergeCheckResult.NOT_MERGED;
            } else {
                void self;
                long actualRevision = svnInfo.getRevision().getNumber();
                long targetRevisionCorrected = targetRevision == -1L ? actualRevision : targetRevision;
                String keyString = path + "@" + targetRevisionCorrected;
                Set<Long> selfInfo = self != false ? this.myNonInheritablePathMergedMap.get(keyString) : null;
                Set<Long> mergeInfo = this.myPathMergedMap.get(keyString);
                if (mergeInfo != null || selfInfo != null) {
                    boolean merged = mergeInfo != null && mergeInfo.contains(revisionAsked) || selfInfo != null && selfInfo.contains(revisionAsked);
                    result = MergeCheckResult.getInstance(merged);
                } else {
                    Revision revision;
                    Target target;
                    if (actualRevision != targetRevisionCorrected) {
                        this.myMixedRevisionsFound = true;
                    }
                    if (actualRevision == targetRevisionCorrected) {
                        target = Target.on(pathFile, Revision.WORKING);
                        revision = Revision.WORKING;
                    } else {
                        target = Target.on(svnInfo.getUrl());
                        revision = Revision.of(targetRevisionCorrected);
                    }
                    PropertyValue mergeinfoProperty = this.myVcs.getFactory(target).createPropertyClient().getProperty(target, "svn:mergeinfo", false, revision);
                    result = mergeinfoProperty == null ? this.goUp(revisionAsked, targetRevisionCorrected, branchRootPath, path, (String)trunkUrl) : this.processMergeinfoProperty(keyString, revisionAsked, mergeinfoProperty, (String)trunkUrl, (boolean)self);
                }
            }
        }
        MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            BranchInfo.$$$reportNull$$$0(21);
        }
        return mergeCheckResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private MergeCheckResult processMergeinfoProperty(String pathWithRevisionNumber, long revisionAsked, @NotNull PropertyValue value, String trunkRelativeUrl, boolean bl) throws SvnBindException {
        MergeCheckResult result;
        Map<String, MergeRangeList> mergedPathsMap;
        String mergedPathAffectingTrunkUrl;
        if (value == null) {
            BranchInfo.$$$reportNull$$$0(22);
        }
        if ((mergedPathAffectingTrunkUrl = (String)ContainerUtil.find((mergedPathsMap = MergeRangeList.parseMergeInfo(value.toString())).keySet(), path -> trunkRelativeUrl.startsWith((String)path))) != null) {
            void self;
            MergeRangeList mergeRangeList = mergedPathsMap.get(mergedPathAffectingTrunkUrl);
            this.fillMergedRevisions(pathWithRevisionNumber, mergeRangeList);
            boolean isAskedRevisionMerged = ContainerUtil.or(mergeRangeList.getRanges(), arg_0 -> BranchInfo.lambda$processMergeinfoProperty$2(revisionAsked, (boolean)self, arg_0));
            result = MergeCheckResult.getInstance(isAskedRevisionMerged);
        } else {
            this.myPathMergedMap.put(pathWithRevisionNumber, Collections.emptySet());
            result = MergeCheckResult.NOT_MERGED;
        }
        MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            BranchInfo.$$$reportNull$$$0(23);
        }
        return mergeCheckResult;
    }

    private void fillMergedRevisions(String pathWithRevisionNumber, @NotNull MergeRangeList mergeRangeList) {
        if (mergeRangeList == null) {
            BranchInfo.$$$reportNull$$$0(24);
        }
        HashSet revisions = new HashSet();
        HashSet nonInheritableRevisions = new HashSet();
        for (MergeRange range : mergeRangeList.getRanges()) {
            ContainerUtil.addAll(range.isInheritable() ? revisions : nonInheritableRevisions, (Iterable)range.getRevisions());
        }
        this.myPathMergedMap.put(pathWithRevisionNumber, revisions);
        if (!nonInheritableRevisions.isEmpty()) {
            this.myNonInheritablePathMergedMap.put(pathWithRevisionNumber, nonInheritableRevisions);
        }
    }

    public boolean isMixedRevisionsFound() {
        return this.myMixedRevisionsFound;
    }

    @NotNull
    public Collection<String> getNotMergedPaths(long number) {
        Collection collection = this.myPartlyMerged.get((Object)number);
        if (collection == null) {
            BranchInfo.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @NotNull
    private static Url appendPath(@NotNull Url url, @NotNull String path) {
        Url url2;
        if (url == null) {
            BranchInfo.$$$reportNull$$$0(26);
        }
        if (path == null) {
            BranchInfo.$$$reportNull$$$0(27);
        }
        try {
            url2 = url.appendPath(path, false);
        }
        catch (SvnBindException e) {
            ExceptionUtil.rethrow((Throwable)((Object)e));
            if (null == null) {
                BranchInfo.$$$reportNull$$$0(29);
            }
            return null;
        }
        if (url2 == null) {
            BranchInfo.$$$reportNull$$$0(28);
        }
        return url2;
    }

    private static /* synthetic */ boolean lambda$processMergeinfoProperty$2(long revisionAsked, boolean self, MergeRange range) {
        return range.contains(revisionAsked) && (range.isInheritable() || self);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 8, 9, 10, 11, 15, 17, 18, 21, 23, 25, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/mergeinfo/BranchInfo";
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underBranchUrl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trunkUrl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchRootPath";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeRangeList";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/mergeinfo/BranchInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCached";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkList";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAlive";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPaths";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "goUp";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "goUpInRepo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPathGoingUp";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "processMergeinfoProperty";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotMergedPaths";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkList";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkAlive";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkPaths";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "goUp";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkPathGoingUp";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processMergeinfoProperty";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fillMergedRevisions";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 8, 9, 10, 11, 15, 17, 18, 21, 23, 25, 28, 29 -> new IllegalStateException(string);
        };
    }
}

