/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.frontend.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrontendMethodCallFixer
implements Fixer {
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            FrontendMethodCallFixer.$$$reportNull$$$0(0);
        }
        if (!BasicJavaAstTreeUtil.is((ASTNode)astNode, (IElementType)BasicJavaElementType.BASIC_METHOD_CALL_EXPRESSION) && !BasicJavaAstTreeUtil.is((ASTNode)astNode, (IElementType)BasicJavaElementType.BASIC_NEW_EXPRESSION)) {
            return;
        }
        ASTNode argList = BasicJavaAstTreeUtil.getExpressionList((ASTNode)astNode);
        int caret = editor.getCaretModel().getOffset();
        if (argList != null && !FrontendMethodCallFixer.hasRParenth(argList)) {
            PsiElement psiElement = BasicJavaAstTreeUtil.toPsi((ASTNode)astNode);
            if (psiElement == null) {
                return;
            }
            ASTNode innermostCall = BasicJavaAstTreeUtil.findElementOfClassAtOffset((PsiFile)psiElement.getContainingFile(), (int)(caret - 1), (IElementType)BasicJavaElementType.BASIC_METHOD_CALL_EXPRESSION, (boolean)false);
            while (innermostCall != null && innermostCall != psiElement && FrontendMethodCallFixer.hasRParenth(BasicJavaAstTreeUtil.getExpressionList((ASTNode)innermostCall))) {
                innermostCall = BasicJavaAstTreeUtil.getParentOfType((ASTNode)innermostCall, (IElementType)BasicJavaElementType.BASIC_METHOD_CALL_EXPRESSION);
            }
            if (innermostCall == null) {
                return;
            }
            argList = BasicJavaAstTreeUtil.getExpressionList((ASTNode)innermostCall);
            if (argList == null) {
                return;
            }
            int endOffset = FrontendMethodCallFixer.getMissingParenthesisOffset(argList);
            TextRange argListRange = argList.getTextRange();
            if (endOffset == -1) {
                endOffset = argListRange.getEndOffset();
            }
            endOffset = CharArrayUtil.shiftBackward((CharSequence)editor.getDocument().getCharsSequence(), (int)(endOffset - 1), (String)" \t\n") + 1;
            editor.getDocument().insertString(endOffset, (CharSequence)")");
        }
    }

    private static int getMissingParenthesisOffset(ASTNode argList) {
        for (ASTNode child = argList.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiErrorElement errorElement;
            PsiElement psiElement = BasicJavaAstTreeUtil.toPsi((ASTNode)child);
            if (!(psiElement instanceof PsiErrorElement) || !(errorElement = (PsiErrorElement)psiElement).getErrorDescription().contains("')'")) continue;
            return errorElement.getTextRange().getStartOffset();
        }
        return -1;
    }

    private static boolean hasRParenth(@Nullable ASTNode args) {
        if (args == null) {
            return false;
        }
        ASTNode parenth = args.getLastChildNode();
        return parenth != null && ")".equals(parenth.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/java/frontend/codeInsight/editorActions/smartEnter/FrontendMethodCallFixer", "apply"));
    }
}

