/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.execution.junit.JUnitExternalLibraryDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.util.ThreeState;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitExternalLibraryResolver
extends ExternalLibraryResolver {
    private static final Set<String> JUNIT4_ANNOTATIONS = Set.of("Test", "Ignore", "RunWith", "Before", "BeforeClass", "After", "AfterClass");

    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (shortClassName == null) {
            JUnitExternalLibraryResolver.$$$reportNull$$$0(0);
        }
        if (isAnnotation == null) {
            JUnitExternalLibraryResolver.$$$reportNull$$$0(1);
        }
        if (contextModule == null) {
            JUnitExternalLibraryResolver.$$$reportNull$$$0(2);
        }
        if ("TestCase".equals(shortClassName)) {
            return new ExternalLibraryResolver.ExternalClassResolveResult("junit.framework.TestCase", JUnitExternalLibraryDescriptor.JUNIT3);
        }
        if (isAnnotation == ThreeState.YES && JUNIT4_ANNOTATIONS.contains(shortClassName)) {
            return new ExternalLibraryResolver.ExternalClassResolveResult("org.junit." + shortClassName, JUnitExternalLibraryDescriptor.JUNIT4);
        }
        return null;
    }

    @Nullable
    public ExternalLibraryDescriptor resolvePackage(@NotNull String packageName) {
        if (packageName == null) {
            JUnitExternalLibraryResolver.$$$reportNull$$$0(3);
        }
        if (packageName.equals("org.junit")) {
            return JUnitExternalLibraryDescriptor.JUNIT4;
        }
        if (packageName.equals("junit.framework")) {
            return JUnitExternalLibraryDescriptor.JUNIT3;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAnnotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/junit/codeInsight/JUnitExternalLibraryResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvePackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

