/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class AbstractAllInDirectoryConfigurationProducer
extends JUnitConfigurationProducer {
    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return "directory".equals(type);
    }

    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        if (configuration == null) {
            AbstractAllInDirectoryConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AbstractAllInDirectoryConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            AbstractAllInDirectoryConfigurationProducer.$$$reportNull$$$0(2);
        }
        Project project = configuration.getProject();
        PsiElement element = context.getPsiLocation();
        if (!(element instanceof PsiDirectory)) {
            return false;
        }
        PsiPackage aPackage = AbstractJavaTestConfigurationProducer.checkPackage((PsiElement)element);
        if (aPackage == null) {
            return false;
        }
        VirtualFile virtualFile = ((PsiDirectory)element).getVirtualFile();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        if (!ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(virtualFile)) {
            return false;
        }
        int testRootCount = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE).size();
        if (testRootCount < 2) {
            return false;
        }
        if (!LocationUtil.isJarAttached((Location)context.getLocation(), (PsiPackage)aPackage, (String[])new String[]{"junit.framework.TestCase", "org.junit.jupiter.api.Test", "org.junit.platform.engine.TestEngine"})) {
            return false;
        }
        this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        data.setDirName(virtualFile.getPath());
        data.TEST_OBJECT = "directory";
        configuration.setGeneratedName();
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceElement";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/junit/AbstractAllInDirectoryConfigurationProducer";
        objectArray[2] = "setupConfigurationFromContext";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

