/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpIntersection;
import org.jetbrains.annotations.NotNull;

public class RedundantNestedCharacterClassInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantNestedCharacterClassInspection.$$$reportNull$$$0(0);
        }
        return new RedundantNestedCharacterClassVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/RedundantNestedCharacterClassInspection", "buildVisitor"));
    }

    private static class RedundantNestedCharacterClassVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RedundantNestedCharacterClassVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpClass(RegExpClass regExpClass) {
            RegExpClass grandparentClass;
            PsiElement grandParent;
            super.visitRegExpClass(regExpClass);
            PsiElement parent = regExpClass.getParent();
            if (parent instanceof RegExpClass) {
                RegExpClass parentClass = (RegExpClass)parent;
                if (!parentClass.isNegated() && !regExpClass.isNegated()) {
                    this.myHolder.registerProblem(regExpClass.getFirstChild(), RegExpBundle.message("inspection.warning.redundant.nested.character.class", new Object[0]), new LocalQuickFix[]{new RedundantNestedCharacterClassFix()});
                }
            } else if (parent instanceof RegExpIntersection && (grandParent = parent.getParent()) instanceof RegExpClass && !(grandparentClass = (RegExpClass)grandParent).isNegated() && !regExpClass.isNegated()) {
                this.myHolder.registerProblem(regExpClass.getFirstChild(), RegExpBundle.message("inspection.warning.redundant.nested.character.class", new Object[0]), new LocalQuickFix[]{new RedundantNestedCharacterClassFix()});
            }
        }

        private static class RedundantNestedCharacterClassFix
        implements LocalQuickFix {
            private RedundantNestedCharacterClassFix() {
            }

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string2 = RegExpBundle.message("inspection.quick.fix.replace.redundant.character.class.with.contents", new Object[0]);
                if (string2 == null) {
                    RedundantNestedCharacterClassFix.$$$reportNull$$$0(0);
                }
                return string2;
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                PsiElement element;
                if (project2 == null) {
                    RedundantNestedCharacterClassFix.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    RedundantNestedCharacterClassFix.$$$reportNull$$$0(2);
                }
                if ((element = descriptor.getPsiElement().getParent()) instanceof RegExpClass) {
                    RegExpClass regExpClass = (RegExpClass)element;
                    RegExpClassElement[] elements = regExpClass.getElements();
                    PsiElement parent = regExpClass.getParent();
                    for (RegExpClassElement classElement : elements) {
                        parent.addBefore((PsiElement)classElement, (PsiElement)regExpClass);
                    }
                    regExpClass.delete();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/inspection/RedundantNestedCharacterClassInspection$RedundantNestedCharacterClassVisitor$RedundantNestedCharacterClassFix";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/inspection/RedundantNestedCharacterClassInspection$RedundantNestedCharacterClassVisitor$RedundantNestedCharacterClassFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2 -> new IllegalArgumentException(string2);
                };
            }
        }
    }
}

