/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaInfo {
    @Nullable
    private final JsonSchemaFileProvider myProvider;
    @Nullable
    @NlsSafe
    private final String myUrl;
    @Nullable
    @Nls
    private String myName;
    @Nullable
    @Nls
    private String myDocumentation;
    @NotNull
    private static final Set<String> myDumbNames = Set.of("schema", "lib", "cli", "packages", "master", "format", "angular", "config");
    private static final @NotNull Map<String, @Nls String> myWeirdNames = Map.of("http://json.schemastore.org/config", "asp.net config", "https://schemastore.azurewebsites.net/schemas/json/config.json", "asp.net config", "http://json.schemastore.org/2.0.0-csd.2.beta.2018-10-10.json", "sarif-2.0.0-csd.2.beta.2018-10-10", "https://schemastore.azurewebsites.net/schemas/json/2.0.0-csd.2.beta.2018-10-10.json", "sarif-2.0.0-csd.2.beta.2018-10-10");

    public JsonSchemaInfo(@NotNull JsonSchemaFileProvider provider) {
        if (provider == null) {
            JsonSchemaInfo.$$$reportNull$$$0(0);
        }
        this.myName = null;
        this.myDocumentation = null;
        this.myProvider = provider;
        this.myUrl = null;
    }

    public JsonSchemaInfo(@NotNull String url) {
        if (url == null) {
            JsonSchemaInfo.$$$reportNull$$$0(1);
        }
        this.myName = null;
        this.myDocumentation = null;
        this.myUrl = url;
        this.myProvider = null;
    }

    @Nullable
    public JsonSchemaFileProvider getProvider() {
        return this.myProvider;
    }

    @NotNull
    public String getUrl(Project project2) {
        if (this.myProvider != null) {
            String remoteSource = this.myProvider.getRemoteSource();
            if (remoteSource != null) {
                String string2 = remoteSource;
                if (string2 == null) {
                    JsonSchemaInfo.$$$reportNull$$$0(2);
                }
                return string2;
            }
            VirtualFile schemaFile = this.myProvider.getSchemaFile();
            if (schemaFile == null) {
                return "";
            }
            if (schemaFile instanceof HttpVirtualFile) {
                String string3 = schemaFile.getUrl();
                if (string3 == null) {
                    JsonSchemaInfo.$$$reportNull$$$0(3);
                }
                return string3;
            }
            if (schemaFile.getFileSystem() instanceof JarFileSystem) {
                String string4 = schemaFile.getUrl();
                if (string4 == null) {
                    JsonSchemaInfo.$$$reportNull$$$0(4);
                }
                return string4;
            }
            return JsonSchemaInfo.getRelativePath(project2, schemaFile.getPath());
        }
        assert (this.myUrl != null);
        String string5 = this.myUrl;
        if (string5 == null) {
            JsonSchemaInfo.$$$reportNull$$$0(5);
        }
        return string5;
    }

    @NotNull
    @Nls
    public String getDescription() {
        if (this.myProvider != null) {
            String providerName = this.myProvider.getPresentableName();
            return JsonSchemaInfo.sanitizeName(providerName);
        }
        if (this.getName() != null) {
            String string2 = this.getName();
            if (string2 == null) {
                JsonSchemaInfo.$$$reportNull$$$0(6);
            }
            return string2;
        }
        assert (this.myUrl != null);
        if (myWeirdNames.containsKey(this.myUrl)) {
            String string3 = myWeirdNames.get(this.myUrl);
            if (string3 == null) {
                JsonSchemaInfo.$$$reportNull$$$0(7);
            }
            return string3;
        }
        String url = this.myUrl.replace('\\', '/');
        String string4 = ContainerUtil.reverse((List)StringUtil.split((String)url, (String)"/")).stream().filter(p -> !JsonSchemaInfo.isVeryDumbName(p)).findFirst().orElse(this.myUrl);
        if (string4 == null) {
            JsonSchemaInfo.$$$reportNull$$$0(8);
        }
        return string4;
    }

    @Nullable
    @Nls
    public String getDocumentation() {
        return this.myDocumentation;
    }

    public void setDocumentation(@Nullable @Nls String documentation) {
        this.myDocumentation = documentation;
    }

    @Nullable
    @Nls
    public String getName() {
        return this.myName;
    }

    public void setName(@Nullable @Nls String name) {
        this.myName = name;
    }

    public static boolean isVeryDumbName(@Nullable String possibleName) {
        if (StringUtil.isEmptyOrSpaces((String)possibleName) || myDumbNames.contains(possibleName)) {
            return true;
        }
        return StringUtil.split((String)possibleName, (String)".").stream().allMatch(s -> JsonSchemaType.isInteger(s));
    }

    @NotNull
    @NlsSafe
    private static String sanitizeName(@NotNull String providerName) {
        if (providerName == null) {
            JsonSchemaInfo.$$$reportNull$$$0(9);
        }
        String string2 = StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)providerName, (String)".json"), (String)"-schema"), (String)".schema");
        if (string2 == null) {
            JsonSchemaInfo.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    public JsonSchemaVersion getSchemaVersion() {
        JsonSchemaVersion jsonSchemaVersion = this.myProvider != null ? this.myProvider.getSchemaVersion() : JsonSchemaVersion.SCHEMA_4;
        if (jsonSchemaVersion == null) {
            JsonSchemaInfo.$$$reportNull$$$0(11);
        }
        return jsonSchemaVersion;
    }

    @NotNull
    public static String getRelativePath(@NotNull Project project2, @NotNull String text2) {
        String path2;
        if (project2 == null) {
            JsonSchemaInfo.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            JsonSchemaInfo.$$$reportNull$$$0(13);
        }
        text2 = text2.trim();
        if (project2.isDefault() || project2.getBasePath() == null || Strings.isEmptyOrSpaces((CharSequence)text2)) {
            String string2 = text2;
            if (string2 == null) {
                JsonSchemaInfo.$$$reportNull$$$0(14);
            }
            return string2;
        }
        Path file = Paths.get(text2, new String[0]);
        if (!file.isAbsolute()) {
            String string3 = text2;
            if (string3 == null) {
                JsonSchemaInfo.$$$reportNull$$$0(15);
            }
            return string3;
        }
        String relativePath = FileUtil.getRelativePath((String)project2.getBasePath(), (String)FileUtil.toSystemIndependentName((String)file.toString()), (char)'/');
        if (relativePath != null) {
            String string4 = relativePath;
            if (string4 == null) {
                JsonSchemaInfo.$$$reportNull$$$0(16);
            }
            return string4;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByNioFile(file);
        if (virtualFile == null) {
            String string5 = text2;
            if (string5 == null) {
                JsonSchemaInfo.$$$reportNull$$$0(17);
            }
            return string5;
        }
        VirtualFile projectBaseDir = LocalFileSystem.getInstance().findFileByPath(project2.getBasePath());
        if (projectBaseDir == null) {
            String string6 = text2;
            if (string6 == null) {
                JsonSchemaInfo.$$$reportNull$$$0(18);
            }
            return string6;
        }
        if (JsonSchemaInfo.isMeaningfulAncestor(VfsUtilCore.getCommonAncestor((VirtualFile)virtualFile, (VirtualFile)projectBaseDir)) && (path2 = VfsUtilCore.findRelativePath((VirtualFile)projectBaseDir, (VirtualFile)virtualFile, (char)File.separatorChar)) != null) {
            String string7 = path2;
            if (string7 == null) {
                JsonSchemaInfo.$$$reportNull$$$0(19);
            }
            return string7;
        }
        String string8 = text2;
        if (string8 == null) {
            JsonSchemaInfo.$$$reportNull$$$0(20);
        }
        return string8;
    }

    private static boolean isMeaningfulAncestor(@Nullable VirtualFile ancestor) {
        if (ancestor == null) {
            return false;
        }
        VirtualFile homeDir = VfsUtil.getUserHomeDir();
        return homeDir != null && VfsUtilCore.isAncestor((VirtualFile)homeDir, (VirtualFile)ancestor, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 10, 11, 14, 15, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaVersion";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5, 6, 7, 8, 10, 11, 14, 15, 16, 17, 18, 19, 20 -> new IllegalStateException(string2);
        };
    }
}

