/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.collect.EnumMultiset;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.impl.VcsLogErrorHandler;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.impl.VcsProjectLogErrorHandlerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/impl/VcsProjectLogErrorHandler;", "", "projectLog", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/vcs/log/impl/VcsProjectLog;Lkotlinx/coroutines/CoroutineScope;)V", "countBySource", "Lcom/google/common/collect/EnumMultiset;", "Lcom/intellij/vcs/log/impl/VcsLogErrorHandler$Source;", "kotlin.jvm.PlatformType", "recreateOnError", "", "source", "t", "", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsProjectLogErrorHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsProjectLogErrorHandler.kt\ncom/intellij/vcs/log/impl/VcsProjectLogErrorHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n8#2:88\n8#2:95\n8#2:96\n1549#3:89\n1620#3,3:90\n1855#3,2:93\n*S KotlinDebug\n*F\n+ 1 VcsProjectLogErrorHandler.kt\ncom/intellij/vcs/log/impl/VcsProjectLogErrorHandler\n*L\n31#1:88\n41#1:95\n44#1:96\n31#1:89\n31#1:90,3\n33#1:93,2\n*E\n"})
public final class VcsProjectLogErrorHandler {
    @NotNull
    private final VcsProjectLog projectLog;
    @NotNull
    private final CoroutineScope coroutineScope;
    private final EnumMultiset<VcsLogErrorHandler.Source> countBySource;

    public VcsProjectLogErrorHandler(@NotNull VcsProjectLog projectLog, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)projectLog, (String)"projectLog");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.projectLog = projectLog;
        this.coroutineScope = coroutineScope;
        this.countBySource = EnumMultiset.create(VcsLogErrorHandler.Source.class);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void recreateOnError(@NotNull VcsLogErrorHandler.Source source2, @NotNull Throwable t) {
        boolean invalidateCaches;
        Intrinsics.checkNotNullParameter((Object)((Object)source2), (String)"source");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (this.projectLog.isDisposing()) {
            return;
        }
        VcsLogManager vcsLogManager = this.projectLog.getLogManager();
        if (vcsLogManager == null) {
            return;
        }
        VcsLogManager logManager2 = vcsLogManager;
        this.countBySource.add((Object)source2);
        int count = this.countBySource.count((Object)source2);
        if (source2 == VcsLogErrorHandler.Source.Index && count > 10) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Set<VirtualFile> set = logManager2.getDataManager().getIndex().getIndexingRoots();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getIndexingRoots(...)");
            Set<VirtualFile> rootsForIndexing = set;
            Object $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(VcsProjectLogErrorHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            $this$thisLogger$iv = rootsForIndexing;
            Logger logger2 = logger;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            logger2.error("Disabling indexing for " + (List)destination$iv$iv + " due to corruption (count=" + count + ").", t);
            Iterable $this$forEach$iv = rootsForIndexing;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                VcsLogBigRepositoriesList.getInstance().addRepository(it);
            }
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, logManager2, null){
                int label;
                final /* synthetic */ VcsProjectLogErrorHandler this$0;
                final /* synthetic */ VcsLogManager $logManager;
                {
                    this.this$0 = $receiver;
                    this.$logManager = $logManager;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = VcsProjectLogErrorHandlerKt.access$recreateLog(VcsProjectLogErrorHandler.access$getProjectLog$p(this.this$0), this.$logManager, true, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return;
        }
        boolean bl = invalidateCaches = count % 5 == 0;
        if (invalidateCaches) {
            VcsProjectLogErrorHandler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(VcsProjectLogErrorHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Invalidating Vcs Log caches after " + source2 + " corruption (count=" + count + ").", t);
        } else {
            VcsProjectLogErrorHandler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(VcsProjectLogErrorHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Recreating Vcs Log after " + source2 + " corruption (count=" + count + ").", t);
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, logManager2, invalidateCaches, null){
            int label;
            final /* synthetic */ VcsProjectLogErrorHandler this$0;
            final /* synthetic */ VcsLogManager $logManager;
            final /* synthetic */ boolean $invalidateCaches;
            {
                this.this$0 = $receiver;
                this.$logManager = $logManager;
                this.$invalidateCaches = $invalidateCaches;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = VcsProjectLogErrorHandlerKt.access$recreateLog(VcsProjectLogErrorHandler.access$getProjectLog$p(this.this$0), this.$logManager, this.$invalidateCaches, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ VcsProjectLog access$getProjectLog$p(VcsProjectLogErrorHandler $this) {
        return $this.projectLog;
    }
}

