/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.EventListener;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="Vcs.Log.Big.Repositories", storages={@Storage(value="$CACHE_FILE$")})
@Service(value={Service.Level.APP})
public final class VcsLogBigRepositoriesList
implements PersistentStateComponent<State> {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);
    private State myState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsLogBigRepositoriesList() {
        Object object = this.myLock;
        synchronized (object) {
            this.myState = new State();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public State getState() {
        Object object = this.myLock;
        // MONITORENTER : object
        State state = new State(this.myState);
        // MONITOREXIT : object
        if (state != null) return state;
        VcsLogBigRepositoriesList.$$$reportNull$$$0(0);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        if (state == null) {
            VcsLogBigRepositoriesList.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myState = new State(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepository(@NotNull VirtualFile root) {
        boolean added2;
        if (root == null) {
            VcsLogBigRepositoriesList.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            added2 = this.myState.repositories.add(root.getPath());
        }
        if (added2) {
            ((Listener)this.myDispatcher.getMulticaster()).onRepositoryAdded(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRepository(@NotNull VirtualFile root) {
        boolean removed2;
        if (root == null) {
            VcsLogBigRepositoriesList.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            removed2 = this.myState.repositories.remove(root.getPath());
        }
        if (removed2) {
            ((Listener)this.myDispatcher.getMulticaster()).onRepositoryRemoved(root);
        }
        return removed2;
    }

    public boolean isBig(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogBigRepositoriesList.$$$reportNull$$$0(4);
        }
        return this.isBig(root.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBig(@NotNull String path2) {
        if (path2 == null) {
            VcsLogBigRepositoriesList.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myState.repositories.contains(path2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRepositoryCount() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myState.repositories.size();
        }
    }

    public void addListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            VcsLogBigRepositoriesList.$$$reportNull$$$0(6);
        }
        if (disposable == null) {
            VcsLogBigRepositoriesList.$$$reportNull$$$0(7);
        }
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    @NotNull
    public static VcsLogBigRepositoriesList getInstance() {
        VcsLogBigRepositoriesList vcsLogBigRepositoriesList = (VcsLogBigRepositoriesList)ApplicationManager.getApplication().getService(VcsLogBigRepositoriesList.class);
        if (vcsLogBigRepositoriesList == null) {
            VcsLogBigRepositoriesList.$$$reportNull$$$0(8);
        }
        return vcsLogBigRepositoriesList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogBigRepositoriesList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogBigRepositoriesList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRepository";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeRepository";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isBig";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string2);
        };
    }

    public static interface Listener
    extends EventListener {
        default public void onRepositoryAdded(@NotNull VirtualFile root) {
            if (root == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        default public void onRepositoryRemoved(@NotNull VirtualFile root) {
            if (root == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "root";
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogBigRepositoriesList$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onRepositoryAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onRepositoryRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class State {
        @XCollection(elementName="repository", valueAttributeName="path", style=XCollection.Style.v2)
        public SortedSet<String> repositories;

        public State() {
            this.repositories = new TreeSet<String>();
        }

        public State(@NotNull State state) {
            if (state == null) {
                State.$$$reportNull$$$0(0);
            }
            this.repositories = new TreeSet<String>();
            this.repositories = new TreeSet<String>(state.repositories);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/vcs/log/data/index/VcsLogBigRepositoriesList$State", "<init>"));
        }
    }

    public static interface Adapter
    extends Listener {
        @Override
        default public void onRepositoryAdded(@NotNull VirtualFile root) {
            if (root == null) {
                Adapter.$$$reportNull$$$0(0);
            }
            this.onRepositoriesListChanged();
        }

        @Override
        default public void onRepositoryRemoved(@NotNull VirtualFile root) {
            if (root == null) {
                Adapter.$$$reportNull$$$0(1);
            }
            this.onRepositoriesListChanged();
        }

        public void onRepositoriesListChanged();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "root";
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogBigRepositoriesList$Adapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onRepositoryAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onRepositoryRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

