/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpan;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceKt;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.TopCommitsCache;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogJoiner;
import com.intellij.vcs.log.data.VcsLogMultiRepoJoiner;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogRefreshNotEnoughDataException;
import com.intellij.vcs.log.data.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.GraphCommitImpl;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.RequirementsImpl;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogRefresherImpl
implements VcsLogRefresher,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogRefresherImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myProviders;
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;
    @NotNull
    private final VcsLogModifiableIndex myIndex;
    @NotNull
    private final TopCommitsCache myTopCommitsDetailsCache;
    @NotNull
    private final VcsLogProgress myProgress;
    private final int myRecentCommitCount;
    @NotNull
    private final SingleTaskController<RefreshRequest, DataPack> mySingleTaskController;
    @NotNull
    private volatile DataPack myDataPack;
    @NotNull
    private final Tracer myTracer;

    public VcsLogRefresherImpl(@NotNull Project project2, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsUserRegistryImpl userRegistry, @NotNull VcsLogModifiableIndex index, @NotNull VcsLogProgress progress, @NotNull TopCommitsCache topCommitsDetailsCache, @NotNull java.util.function.Consumer<? super DataPack> dataPackUpdateHandler, int recentCommitsCount) {
        if (project2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(1);
        }
        if (providers == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(2);
        }
        if (userRegistry == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(3);
        }
        if (index == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(4);
        }
        if (progress == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(5);
        }
        if (topCommitsDetailsCache == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(6);
        }
        if (dataPackUpdateHandler == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(7);
        }
        this.myDataPack = DataPack.EMPTY;
        this.myTracer = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope);
        this.myProject = project2;
        this.myStorage = storage;
        this.myProviders = providers;
        this.myUserRegistry = userRegistry;
        this.myIndex = index;
        this.myTopCommitsDetailsCache = topCommitsDetailsCache;
        this.myRecentCommitCount = recentCommitsCount;
        this.myProgress = progress;
        this.mySingleTaskController = new SingleTaskController<RefreshRequest, DataPack>("permanent", (Disposable)this, dataPack -> {
            this.myDataPack = dataPack;
            dataPackUpdateHandler.accept((DataPack)dataPack);
        }){

            @Override
            @NotNull
            protected SingleTaskController.SingleTask startNewBackgroundTask() {
                SingleTaskController.SingleTask singleTask = VcsLogRefresherImpl.this.startNewBackgroundTask(new MyRefreshTask(VcsLogRefresherImpl.this.myDataPack));
                if (singleTask == null) {
                    1.$$$reportNull$$$0(0);
                }
                return singleTask;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogRefresherImpl$1", "startNewBackgroundTask"));
            }
        };
    }

    protected SingleTaskController.SingleTask startNewBackgroundTask(@NotNull Task.Backgroundable refreshTask) {
        if (refreshTask == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(8);
        }
        LOG.debug("Starting a background task...");
        ProgressIndicator indicator = this.myProgress.createProgressIndicator(VcsLogData.DATA_PACK_REFRESH);
        Future future2 = ((CoreProgressManager)ProgressManager.getInstance()).runProcessWithProgressAsynchronously(refreshTask, indicator, null);
        return new SingleTaskController.SingleTaskImpl(future2, indicator);
    }

    @Override
    @NotNull
    public DataPack getCurrentDataPack() {
        DataPack dataPack = this.myDataPack;
        if (dataPack == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(9);
        }
        return dataPack;
    }

    @Override
    public void readFirstBlock() {
        try {
            LogInfo data2 = this.loadRecentData(new CommitCountRequirements(this.myRecentCommitCount).asMap(this.myProviders.keySet()));
            Collection<List<GraphCommit<Integer>>> commits2 = data2.getCommits();
            Map<VirtualFile, CompressedRefs> refs = data2.getRefs();
            List compoundList = VcsLogRefresherImpl.multiRepoJoin(commits2);
            compoundList = ContainerUtil.getFirstItems(compoundList, (int)this.myRecentCommitCount);
            this.myDataPack = DataPack.build(compoundList, refs, this.myProviders, this.myStorage, false);
            this.mySingleTaskController.request((RefreshRequest[])new RefreshRequest[]{RefreshRequest.RELOAD_ALL});
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            this.myDataPack = new DataPack.ErrorDataPack(e);
        }
    }

    @NotNull
    private LogInfo loadRecentData(@NotNull Map<VirtualFile, VcsLogProvider.Requirements> requirements) throws VcsException {
        if (requirements == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(10);
        }
        LogInfo logInfo = (LogInfo)TraceUtil.computeWithSpanThrows((Tracer)this.myTracer, (String)VcsTelemetrySpan.LogData.LoadingCommits.getName(), __ -> {
            LogInfo logInfo = new LogInfo(this.myStorage);
            for (Map.Entry<VirtualFile, VcsLogProvider> entry2 : this.getProvidersForRoots(requirements.keySet()).entrySet()) {
                VirtualFile root = entry2.getKey();
                VcsLogProvider provider = entry2.getValue();
                TraceUtil.runWithSpanThrows((Tracer)this.myTracer, (String)VcsTelemetrySpan.LogData.LoadingCommits.getName(), spanForRoot -> {
                    spanForRoot.setAttribute("rootName", root.getName());
                    VcsLogProvider.DetailedLogData data2 = provider.readFirstBlock(root, (VcsLogProvider.Requirements)requirements.get(root));
                    logInfo.put(root, this.compactCommits(data2.getCommits(), root));
                    logInfo.put(root, data2.getRefs());
                    this.storeUsersAndDetails(data2.getCommits());
                });
            }
            this.myUserRegistry.flush();
            this.myIndex.scheduleIndex(false);
            return logInfo;
        });
        if (logInfo == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(11);
        }
        return logInfo;
    }

    @NotNull
    private Map<VirtualFile, VcsLogProvider> getProvidersForRoots(@NotNull Set<? extends VirtualFile> roots) {
        if (roots == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(12);
        }
        Map map2 = ContainerUtil.map2Map(roots, root -> Pair.create((Object)root, (Object)this.myProviders.get(root)));
        if (map2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(13);
        }
        return map2;
    }

    @Override
    public void refresh(@NotNull Collection<VirtualFile> rootsToRefresh) {
        if (rootsToRefresh == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(14);
        }
        if (!rootsToRefresh.isEmpty()) {
            this.mySingleTaskController.request((RefreshRequest[])new RefreshRequest[]{new RefreshRequest(rootsToRefresh)});
        }
    }

    @NotNull
    private static <T extends GraphCommit<Integer>> List<T> multiRepoJoin(@NotNull Collection<? extends List<T>> commits2) {
        if (commits2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(15);
        }
        Span span = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(VcsTelemetrySpan.LogData.MultiRepoJoin.getName()).startSpan();
        List joined = new VcsLogMultiRepoJoiner().join(commits2);
        span.end();
        List list2 = joined;
        if (list2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    private List<GraphCommit<Integer>> compactCommits(@NotNull List<? extends TimedVcsCommit> commits2, @NotNull VirtualFile root) {
        if (commits2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(17);
        }
        if (root == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(18);
        }
        List list2 = (List)TraceKt.computeWithSpan((Tracer)this.myTracer, (String)VcsTelemetrySpan.LogData.CompactingCommits.getName(), span -> {
            if (commits2.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<GraphCommit<Integer>> list2 = new ArrayList<GraphCommit<Integer>>(commits2.size());
            for (TimedVcsCommit commit2 : commits2) {
                list2.add(this.compactCommit(commit2, root));
            }
            return list2;
        });
        if (list2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    private GraphCommit<Integer> compactCommit(@NotNull TimedVcsCommit commit2, @NotNull VirtualFile root) {
        List<Integer> parents;
        List collection;
        if (commit2 == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(20);
        }
        if (root == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(21);
        }
        if ((collection = commit2.getParents()).isEmpty()) {
            parents = Collections.emptyList();
        } else {
            parents = new ArrayList(collection.size());
            for (Hash t : collection) {
                parents.add(this.myStorage.getCommitIndex(t, root));
            }
        }
        int index = this.myStorage.getCommitIndex((Hash)commit2.getId(), root);
        this.myIndex.markForIndexing(index, root);
        GraphCommit<Integer> graphCommit = GraphCommitImpl.createIntCommit(index, parents, commit2.getTimestamp());
        if (graphCommit == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(22);
        }
        return graphCommit;
    }

    private void storeUsersAndDetails(@NotNull List<? extends VcsCommitMetadata> metadatas) {
        if (metadatas == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(23);
        }
        for (VcsCommitMetadata vcsCommitMetadata : metadatas) {
            this.myUserRegistry.addUser(vcsCommitMetadata.getAuthor());
            this.myUserRegistry.addUser(vcsCommitMetadata.getCommitter());
        }
        this.myTopCommitsDetailsCache.storeDetails(metadatas);
    }

    @NotNull
    public VcsLogProgress getProgress() {
        VcsLogProgress vcsLogProgress = this.myProgress;
        if (vcsLogProgress == null) {
            VcsLogRefresherImpl.$$$reportNull$$$0(24);
        }
        return vcsLogProgress;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 13, 16, 19, 22, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topCommitsDetailsCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPackUpdateHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshTask";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToRefresh";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metadatas";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentDataPack";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRecentData";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersForRoots";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "multiRepoJoin";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "compactCommits";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "compactCommit";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "startNewBackgroundTask";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 24: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadRecentData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersForRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "multiRepoJoin";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "compactCommits";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "compactCommit";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "storeUsersAndDetails";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 9, 11, 13, 16, 19, 22, 24 -> new IllegalStateException(string2);
        };
    }

    private static class CommitCountRequirements
    implements VcsLogProvider.Requirements {
        private final int myCommitCount;

        CommitCountRequirements(int commitCount) {
            this.myCommitCount = commitCount;
        }

        @Override
        public int getCommitCount() {
            return this.myCommitCount;
        }

        @NotNull
        Map<VirtualFile, VcsLogProvider.Requirements> asMap(@NotNull Collection<? extends VirtualFile> roots) {
            if (roots == null) {
                CommitCountRequirements.$$$reportNull$$$0(0);
            }
            Map map2 = ContainerUtil.map2Map(roots, root -> Pair.create((Object)root, (Object)this));
            if (map2 == null) {
                CommitCountRequirements.$$$reportNull$$$0(1);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$CommitCountRequirements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$CommitCountRequirements";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "asMap";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static final class LogInfo {
        private final VcsLogStorage myStorage;
        private final Map<VirtualFile, CompressedRefs> myRefs = new HashMap<VirtualFile, CompressedRefs>();
        private final Map<VirtualFile, List<GraphCommit<Integer>>> myCommits = new HashMap<VirtualFile, List<GraphCommit<Integer>>>();

        LogInfo(VcsLogStorage storage) {
            this.myStorage = storage;
        }

        void put(@NotNull VirtualFile root, @NotNull List<GraphCommit<Integer>> commits2) {
            if (root == null) {
                LogInfo.$$$reportNull$$$0(0);
            }
            if (commits2 == null) {
                LogInfo.$$$reportNull$$$0(1);
            }
            this.myCommits.put(root, commits2);
        }

        void put(@NotNull VirtualFile root, @NotNull Set<VcsRef> refs) {
            if (root == null) {
                LogInfo.$$$reportNull$$$0(2);
            }
            if (refs == null) {
                LogInfo.$$$reportNull$$$0(3);
            }
            this.myRefs.put(root, new CompressedRefs(refs, this.myStorage));
        }

        @NotNull
        Collection<List<GraphCommit<Integer>>> getCommits() {
            Collection<List<GraphCommit<Integer>>> collection = this.myCommits.values();
            if (collection == null) {
                LogInfo.$$$reportNull$$$0(4);
            }
            return collection;
        }

        List<GraphCommit<Integer>> getCommits(@NotNull VirtualFile root) {
            if (root == null) {
                LogInfo.$$$reportNull$$$0(5);
            }
            return this.myCommits.get(root);
        }

        @NotNull
        Map<VirtualFile, CompressedRefs> getRefs() {
            Map<VirtualFile, CompressedRefs> map2 = this.myRefs;
            if (map2 == null) {
                LogInfo.$$$reportNull$$$0(6);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commits";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refs";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$LogInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommits";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommits";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 4, 6 -> new IllegalStateException(string2);
            };
        }
    }

    private static class RefreshRequest {
        private static final RefreshRequest RELOAD_ALL = new RefreshRequest((Collection)Collections.emptyList()){

            @Override
            @NonNls
            public String toString() {
                return "RELOAD_ALL";
            }
        };
        private final Collection<VirtualFile> rootsToRefresh;

        RefreshRequest(@NotNull Collection<VirtualFile> rootsToRefresh) {
            if (rootsToRefresh == null) {
                RefreshRequest.$$$reportNull$$$0(0);
            }
            this.rootsToRefresh = rootsToRefresh;
        }

        public String toString() {
            return "{" + this.rootsToRefresh + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsToRefresh", "com/intellij/vcs/log/data/VcsLogRefresherImpl$RefreshRequest", "<init>"));
        }
    }

    private class MyRefreshTask
    extends Task.Backgroundable {
        @NotNull
        private DataPack myCurrentDataPack;
        @NotNull
        private final LogInfo myLoadedInfo;

        MyRefreshTask(DataPack currentDataPack) {
            if (currentDataPack == null) {
                MyRefreshTask.$$$reportNull$$$0(0);
            }
            super(VcsLogRefresherImpl.this.myProject, VcsLogBundle.message("vcs.log.refreshing.process", new Object[0]), false);
            this.myLoadedInfo = new LogInfo(VcsLogRefresherImpl.this.myStorage);
            this.myCurrentDataPack = currentDataPack;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyRefreshTask.$$$reportNull$$$0(1);
            }
            LOG.debug("Refresh task started");
            indicator.setIndeterminate(true);
            DataPack dataPack = this.myCurrentDataPack;
            while (true) {
                List<RefreshRequest> requests = VcsLogRefresherImpl.this.mySingleTaskController.popRequests();
                Collection<VirtualFile> rootsToRefresh = this.getRootsToRefresh(requests);
                LOG.debug("Requests: " + requests + ". roots to refresh: " + rootsToRefresh);
                if (rootsToRefresh.isEmpty()) break;
                try {
                    dataPack = this.doRefresh(rootsToRefresh);
                }
                catch (ProcessCanceledException e) {
                    VcsLogRefresherImpl.this.mySingleTaskController.taskCompleted(null);
                    throw e;
                }
            }
            VcsLogRefresherImpl.this.mySingleTaskController.taskCompleted(dataPack);
        }

        @NotNull
        private Collection<VirtualFile> getRootsToRefresh(@NotNull List<? extends RefreshRequest> requests) {
            if (requests == null) {
                MyRefreshTask.$$$reportNull$$$0(2);
            }
            ArrayList<VirtualFile> rootsToRefresh = new ArrayList<VirtualFile>();
            for (RefreshRequest refreshRequest : requests) {
                if (refreshRequest == RefreshRequest.RELOAD_ALL) {
                    this.myCurrentDataPack = DataPack.EMPTY;
                    Set<VirtualFile> set = VcsLogRefresherImpl.this.myProviders.keySet();
                    if (set == null) {
                        MyRefreshTask.$$$reportNull$$$0(3);
                    }
                    return set;
                }
                rootsToRefresh.addAll(refreshRequest.rootsToRefresh);
            }
            ArrayList<VirtualFile> arrayList = rootsToRefresh;
            if (arrayList == null) {
                MyRefreshTask.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @NotNull
        private DataPack doRefresh(@NotNull Collection<? extends VirtualFile> roots) {
            if (roots == null) {
                MyRefreshTask.$$$reportNull$$$0(5);
            }
            DataPack dataPack = (DataPack)TraceUtil.computeWithSpanThrows((Tracer)VcsLogRefresherImpl.this.myTracer, (String)VcsTelemetrySpan.LogData.Refresh.getName(), span -> {
                try {
                    PermanentGraph<Integer> permanentGraph = this.myCurrentDataPack.isFull() ? this.myCurrentDataPack.getPermanentGraph() : null;
                    Map<VirtualFile, CompressedRefs> currentRefs = this.myCurrentDataPack.getRefsModel().getAllRefsByRoot();
                    Collection providers = ContainerUtil.filter(VcsLogRefresherImpl.this.myProviders, roots::contains).values();
                    boolean supportsIncrementalRefresh = ContainerUtil.all(providers, provider -> VcsLogProperties.SUPPORTS_INCREMENTAL_REFRESH.getOrDefault((VcsLogProvider)provider));
                    if (permanentGraph != null && supportsIncrementalRefresh) {
                        int commitCount = VcsLogRefresherImpl.this.myRecentCommitCount;
                        for (int attempt = 0; attempt <= 1; ++attempt) {
                            this.loadLogAndRefs(roots, currentRefs, commitCount);
                            List<GraphCommit<Integer>> compoundLog = VcsLogRefresherImpl.multiRepoJoin(this.myLoadedInfo.getCommits());
                            Map<VirtualFile, CompressedRefs> allNewRefs = MyRefreshTask.getAllNewRefs(this.myLoadedInfo, currentRefs);
                            List<? extends GraphCommit<Integer>> joinedFullLog = this.join(compoundLog, new ArrayList<GraphCommit<Integer>>(permanentGraph.getAllCommits()), currentRefs, allNewRefs);
                            if (joinedFullLog == null) {
                                commitCount *= 5;
                                continue;
                            }
                            return DataPack.build(joinedFullLog, allNewRefs, VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myStorage, true);
                        }
                        LOG.info("Couldn't join " + commitCount / 5 + " recent commits to the log (" + permanentGraph.getAllCommits().size() + " commits)");
                    }
                    return this.loadFullLog();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                    return new DataPack.ErrorDataPack(e);
                }
            });
            if (dataPack == null) {
                MyRefreshTask.$$$reportNull$$$0(6);
            }
            return dataPack;
        }

        @NotNull
        private static Map<VirtualFile, CompressedRefs> getAllNewRefs(@NotNull LogInfo newInfo, @NotNull Map<VirtualFile, CompressedRefs> previousRefs) {
            if (newInfo == null) {
                MyRefreshTask.$$$reportNull$$$0(7);
            }
            if (previousRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(8);
            }
            HashMap<VirtualFile, CompressedRefs> result2 = new HashMap<VirtualFile, CompressedRefs>();
            for (VirtualFile root : previousRefs.keySet()) {
                CompressedRefs newInfoRefs = newInfo.getRefs().get(root);
                result2.put(root, newInfoRefs != null ? newInfoRefs : previousRefs.get(root));
            }
            HashMap<VirtualFile, CompressedRefs> hashMap = result2;
            if (hashMap == null) {
                MyRefreshTask.$$$reportNull$$$0(9);
            }
            return hashMap;
        }

        private void loadLogAndRefs(@NotNull Collection<? extends VirtualFile> roots, @NotNull Map<VirtualFile, CompressedRefs> prevRefs, int commitCount) throws VcsException {
            if (roots == null) {
                MyRefreshTask.$$$reportNull$$$0(10);
            }
            if (prevRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(11);
            }
            LogInfo logInfo = VcsLogRefresherImpl.this.loadRecentData(MyRefreshTask.prepareRequirements(roots, commitCount, prevRefs));
            for (VirtualFile virtualFile : roots) {
                this.myLoadedInfo.put(virtualFile, logInfo.getCommits(virtualFile));
                this.myLoadedInfo.myRefs.put(virtualFile, logInfo.getRefs().get(virtualFile));
            }
        }

        @NotNull
        private static Map<VirtualFile, VcsLogProvider.Requirements> prepareRequirements(@NotNull Collection<? extends VirtualFile> roots, int commitCount, @NotNull Map<VirtualFile, CompressedRefs> prevRefs) {
            if (roots == null) {
                MyRefreshTask.$$$reportNull$$$0(12);
            }
            if (prevRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(13);
            }
            HashMap<VirtualFile, VcsLogProvider.Requirements> requirements = new HashMap<VirtualFile, VcsLogProvider.Requirements>();
            for (VirtualFile virtualFile : roots) {
                requirements.put(virtualFile, new RequirementsImpl(commitCount, true, prevRefs.get(virtualFile).getRefs()));
            }
            HashMap<VirtualFile, VcsLogProvider.Requirements> hashMap = requirements;
            if (hashMap == null) {
                MyRefreshTask.$$$reportNull$$$0(14);
            }
            return hashMap;
        }

        @Nullable
        private List<? extends GraphCommit<Integer>> join(@NotNull List<? extends GraphCommit<Integer>> recentCommits, @NotNull List<? extends GraphCommit<Integer>> fullLog, @NotNull Map<VirtualFile, CompressedRefs> previousRefs, @NotNull Map<VirtualFile, CompressedRefs> newRefs) {
            if (recentCommits == null) {
                MyRefreshTask.$$$reportNull$$$0(15);
            }
            if (fullLog == null) {
                MyRefreshTask.$$$reportNull$$$0(16);
            }
            if (previousRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(17);
            }
            if (newRefs == null) {
                MyRefreshTask.$$$reportNull$$$0(18);
            }
            if (fullLog.isEmpty()) {
                return recentCommits;
            }
            return (List)TraceKt.computeWithSpan((Tracer)VcsLogRefresherImpl.this.myTracer, (String)VcsTelemetrySpan.LogData.JoiningNewCommits.getName(), span -> {
                Collection prevRefIndices = previousRefs.values().stream().flatMap(refs -> refs.getCommits().stream()).collect(Collectors.toSet());
                Collection newRefIndices = newRefs.values().stream().flatMap(refs -> refs.getCommits().stream()).collect(Collectors.toSet());
                try {
                    return (List)new VcsLogJoiner<CommitId, Commit>().addCommits(fullLog, prevRefIndices, recentCommits, newRefIndices).first;
                }
                catch (VcsLogRefreshNotEnoughDataException e) {
                    LOG.info((Throwable)e);
                }
                catch (IllegalStateException e) {
                    LOG.info((Throwable)e);
                }
                return null;
            });
        }

        @NotNull
        private DataPack loadFullLog() throws VcsException {
            DataPack dataPack = (DataPack)TraceUtil.computeWithSpanThrows((Tracer)VcsLogRefresherImpl.this.myTracer, (String)VcsTelemetrySpan.LogData.FullLogReload.getName(), span -> {
                LogInfo logInfo = this.readFullLogFromVcs();
                List<GraphCommit<Integer>> graphCommits = VcsLogRefresherImpl.multiRepoJoin(logInfo.getCommits());
                return DataPack.build(graphCommits, logInfo.getRefs(), VcsLogRefresherImpl.this.myProviders, VcsLogRefresherImpl.this.myStorage, true);
            });
            if (dataPack == null) {
                MyRefreshTask.$$$reportNull$$$0(19);
            }
            return dataPack;
        }

        @NotNull
        private LogInfo readFullLogFromVcs() throws VcsException {
            LogInfo logInfo = (LogInfo)TraceUtil.computeWithSpanThrows((Tracer)VcsLogRefresherImpl.this.myTracer, (String)VcsTelemetrySpan.LogData.ReadFullLogFromVcs.getName(), span -> {
                LogInfo logInfo = new LogInfo(VcsLogRefresherImpl.this.myStorage);
                for (Map.Entry<VirtualFile, VcsLogProvider> entry2 : VcsLogRefresherImpl.this.myProviders.entrySet()) {
                    VirtualFile root = entry2.getKey();
                    VcsLogProvider provider = entry2.getValue();
                    TraceUtil.runWithSpanThrows((Tracer)VcsLogRefresherImpl.this.myTracer, (String)VcsTelemetrySpan.LogData.ReadFullLogFromVcsForRoot.getName(), scopeSpan -> {
                        scopeSpan.setAttribute("rootName", root.getName());
                        ArrayList<GraphCommit<Integer>> graphCommits = new ArrayList<GraphCommit<Integer>>();
                        VcsLogProvider.LogData data2 = provider.readAllHashes(root, (Consumer<? super TimedVcsCommit>)((Consumer)commit2 -> graphCommits.add(VcsLogRefresherImpl.this.compactCommit((TimedVcsCommit)commit2, root))));
                        logInfo.put(root, graphCommits);
                        logInfo.put(root, data2.getRefs());
                        VcsLogRefresherImpl.this.myUserRegistry.addUsers(data2.getUsers());
                    });
                }
                VcsLogRefresherImpl.this.myUserRegistry.flush();
                VcsLogRefresherImpl.this.myIndex.scheduleIndex(true);
                return logInfo;
            });
            if (logInfo == null) {
                MyRefreshTask.$$$reportNull$$$0(20);
            }
            return logInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6, 9, 14, 19, 20 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentDataPack";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requests";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 14: 
                case 19: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask";
                    break;
                }
                case 5: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newInfo";
                    break;
                }
                case 8: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousRefs";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prevRefs";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recentCommits";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullLog";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/VcsLogRefresherImpl$MyRefreshTask";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootsToRefresh";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doRefresh";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllNewRefs";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareRequirements";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadFullLog";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readFullLogFromVcs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getRootsToRefresh";
                    break;
                }
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 14: 
                case 19: 
                case 20: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "doRefresh";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getAllNewRefs";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "loadLogAndRefs";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareRequirements";
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3, 4, 6, 9, 14, 19, 20 -> new IllegalStateException(string2);
            };
        }
    }
}

