/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomFileMetaData
implements PluginAware {
    static final ExtensionPointName<DomFileMetaData> EP_NAME = new ExtensionPointName("com.intellij.dom.fileMetaData");
    private transient PluginDescriptor pluginDescriptor;
    @Attribute(value="implementation")
    @RequiredElement
    public String implementation;
    @Attribute(value="rootTagName")
    @Nullable
    public String rootTagName;
    @Attribute(value="domVersion")
    public int domVersion;
    @Attribute(value="stubVersion")
    @Nullable
    public Integer stubVersion;
    volatile DomFileDescription<?> lazyInstance;

    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            DomFileMetaData.$$$reportNull$$$0(0);
        }
        this.pluginDescriptor = pluginDescriptor;
    }

    public DomFileMetaData() {
    }

    public DomFileMetaData(DomFileDescription<?> description2) {
        this.lazyInstance = description2;
        this.implementation = description2.getClass().getName();
        this.rootTagName = description2.acceptsOtherRootTagNames() ? null : description2.getRootTagName();
        this.domVersion = description2.getVersion();
        this.stubVersion = description2.hasStubs() ? Integer.valueOf(description2.getStubVersion()) : null;
    }

    DomFileDescription<?> getDescription() {
        DomFileDescription instance = this.lazyInstance;
        if (instance != null) {
            return instance;
        }
        instance = (DomFileDescription)ApplicationManager.getApplication().instantiateClass(this.implementation, this.pluginDescriptor);
        if (Strings.isEmpty((String)this.rootTagName)) {
            if (!instance.acceptsOtherRootTagNames()) {
                throw new PluginException(this.implementation + " should either specify 'rootTagName' in XML, or return true from 'acceptsOtherRootTagNames'", this.pluginDescriptor.getPluginId());
            }
        } else if (!this.rootTagName.equals(instance.getRootTagName())) {
            throw new PluginException(this.implementation + " XML declaration should have '" + instance.getRootTagName() + "' for 'rootTagName'", this.pluginDescriptor.getPluginId());
        }
        try {
            DomApplicationComponent.getInstance().initDescription(instance);
            this.lazyInstance = instance;
        }
        catch (PluginException | ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginException((Throwable)e, this.pluginDescriptor.getPluginId());
        }
        return instance;
    }

    public boolean hasStubs() {
        return this.stubVersion != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/util/xml/impl/DomFileMetaData", "setPluginDescriptor"));
    }
}

