/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SimpleHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class CompiledPattern {
    public static final Key<MatchingHandler> HANDLER_KEY = Key.create((String)"ss.handler");
    private final Map<Object, MatchingHandler> handlers = new HashMap<Object, MatchingHandler>();
    private final MultiMap<String, PsiElement> variableNodes = new MultiMap();
    private SearchScope scope;
    private NodeIterator nodes;
    private MatchingStrategy strategy;
    private PsiElement targetNode;
    private int nodeCount;
    private PsiElement last;
    private MatchingHandler lastHandler;

    public abstract String @NotNull [] getTypedVarPrefixes();

    public abstract boolean isTypedVar(@NotNull String var1);

    public void setTargetNode(@NotNull PsiElement element) {
        if (element == null) {
            CompiledPattern.$$$reportNull$$$0(0);
        }
        this.targetNode = element;
    }

    public PsiElement getTargetNode() {
        return this.targetNode;
    }

    public MatchingStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(MatchingStrategy strategy) {
        this.strategy = strategy;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public NodeIterator getNodes() {
        return this.nodes;
    }

    public void setNodes(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            CompiledPattern.$$$reportNull$$$0(1);
        }
        this.nodes = new ArrayBackedNodeIterator(PsiUtilCore.toPsiElementArray(elements));
        this.nodeCount = elements.size();
    }

    @Contract(value="null -> false")
    public boolean isTypedVar(PsiElement element) {
        return element != null && this.isTypedVar(element.getText());
    }

    public boolean isRealTypedVar(PsiElement element) {
        if (element == null || element.getTextLength() <= 0) {
            return false;
        }
        String str = this.getTypedVarString(element);
        return !str.isEmpty() && this.isTypedVar(str);
    }

    @NotNull
    public String getTypedVarString(@NotNull PsiElement element) {
        StructuralSearchProfile profile;
        if (element == null) {
            CompiledPattern.$$$reportNull$$$0(2);
        }
        String typedVarString = (profile = StructuralSearchUtil.getProfileByPsiElement(element)) == null ? element.getText() : profile.getTypedVarString(element);
        String string2 = typedVarString.trim();
        if (string2 == null) {
            CompiledPattern.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public MatchingHandler getHandlerSimple(@NotNull PsiElement node) {
        if (node == null) {
            CompiledPattern.$$$reportNull$$$0(4);
        }
        return this.handlers.get(node);
    }

    @NotNull
    public MatchingHandler getHandler(@NotNull PsiElement node) {
        if (node == null) {
            CompiledPattern.$$$reportNull$$$0(5);
        }
        if (node == this.last) {
            MatchingHandler matchingHandler = this.lastHandler;
            if (matchingHandler == null) {
                CompiledPattern.$$$reportNull$$$0(6);
            }
            return matchingHandler;
        }
        MatchingHandler handler2 = this.handlers.get(node);
        if (handler2 == null) {
            handler2 = new SimpleHandler();
            this.setHandler(node, handler2);
        }
        this.last = node;
        this.lastHandler = handler2;
        MatchingHandler matchingHandler = handler2;
        if (matchingHandler == null) {
            CompiledPattern.$$$reportNull$$$0(7);
        }
        return matchingHandler;
    }

    public MatchingHandler getHandler(@NotNull String name) {
        if (name == null) {
            CompiledPattern.$$$reportNull$$$0(8);
        }
        return this.handlers.get(name);
    }

    public void setHandler(@NotNull PsiElement node, @NotNull MatchingHandler handler2) {
        if (node == null) {
            CompiledPattern.$$$reportNull$$$0(9);
        }
        if (handler2 == null) {
            CompiledPattern.$$$reportNull$$$0(10);
        }
        this.last = null;
        this.handlers.put(node, handler2);
    }

    @NotNull
    public SubstitutionHandler createSubstitutionHandler(@NotNull String name, @NotNull String compiledName, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        SubstitutionHandler handler2;
        if (name == null) {
            CompiledPattern.$$$reportNull$$$0(11);
        }
        if (compiledName == null) {
            CompiledPattern.$$$reportNull$$$0(12);
        }
        if ((handler2 = (SubstitutionHandler)this.handlers.get(compiledName)) != null) {
            SubstitutionHandler substitutionHandler = handler2;
            if (substitutionHandler == null) {
                CompiledPattern.$$$reportNull$$$0(13);
            }
            return substitutionHandler;
        }
        handler2 = this.doCreateSubstitutionHandler(name, target, minOccurs, maxOccurs, greedy);
        this.handlers.put(compiledName, handler2);
        SubstitutionHandler substitutionHandler = handler2;
        if (substitutionHandler == null) {
            CompiledPattern.$$$reportNull$$$0(14);
        }
        return substitutionHandler;
    }

    @NotNull
    protected SubstitutionHandler doCreateSubstitutionHandler(@NotNull String name, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        if (name == null) {
            CompiledPattern.$$$reportNull$$$0(15);
        }
        return new SubstitutionHandler(name, target, minOccurs, maxOccurs, greedy);
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope2) {
        this.scope = scope2;
    }

    public void clearHandlers() {
        this.handlers.clear();
        this.last = null;
        this.lastHandler = null;
    }

    void clearHandlersState() {
        for (MatchingHandler h : this.handlers.values()) {
            if (h == null) continue;
            h.reset();
        }
    }

    public boolean isToResetHandler(@NotNull PsiElement element) {
        if (element == null) {
            CompiledPattern.$$$reportNull$$$0(16);
        }
        return true;
    }

    @NotNull
    public List<PsiElement> getVariableNodes(@NotNull String name) {
        Collection elements;
        if (name == null) {
            CompiledPattern.$$$reportNull$$$0(17);
        }
        return (elements = this.variableNodes.get((Object)name)) instanceof List ? (List)elements : new SmartList(elements);
    }

    public void putVariableNode(@NotNull String name, @NotNull PsiElement node) {
        if (name == null) {
            CompiledPattern.$$$reportNull$$$0(18);
        }
        if (node == null) {
            CompiledPattern.$$$reportNull$$$0(19);
        }
        this.variableNodes.putValue((Object)name, (Object)node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 7, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/CompiledPattern";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/CompiledPattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubstitutionHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTargetNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNodes";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTypedVarString";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 13: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHandlerSimple";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setHandler";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createSubstitutionHandler";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doCreateSubstitutionHandler";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isToResetHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getVariableNodes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putVariableNode";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 6, 7, 13, 14 -> new IllegalStateException(string2);
        };
    }
}

